<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * SNG Network service configuration wrapper
 *
 * @author William Adam
 * @version
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
safe_require_class('service');

class Sng_network_route_class extends Safe_configurable_object_class
{
    public function __construct($node, $parent_name, $name)
    {
        // Parent constructor to invoke unserialize if needed
        parent::__construct($parent_name, $name, $node);
    }
    public function configure()
    {
        // General settings
        $adapters = $this->_node->hardware()->adapters();
        $interfaces=array();
        foreach($adapters as $k => $v){
            $interfaces[$k] = $k;
        }
        $this->add_enum_field('interface', 'Network Interface', 'dropdown', '', $interfaces);
        $this->set_field_help('interface', 'The Network Interface used to reach network number '.$this->name());

        $this->add_field('netmask', 'Network Mask', 'text', '',25);
        $this->set_field_help('netmask', 'The netmask for the network number '.$this->name());
        $this->set_field_rules('netmask', 'required|valid_ip');
        $this->add_field('gateway', 'Gateway', 'text', '',25);
        $this->set_field_help('gateway', 'The default gateway, or an IP address that can be used to reach '.$this->name());
        $this->set_field_rules('gateway', 'required|valid_ip');

        return parent::configure();
    }

    public function description()
    {
        $data = $this->get_data_values();
        return $data['interface'] . ' - ' . $data['netmask'] . ' - ' . $data['gateway'];
    }
}


class Sng_network_service_class extends Safe_service_class
{
    public function __construct($software)
    {
        parent::__construct($software, "network", $process_name);
    }

    /**
     * @brief
     *         
     * @return
     */
    public function configure()
    {
        // Set the module description
        $this->set_description("Network");

        // Register objects
        $this->register_aggregate_object('route', 
            array(
                'name' => 'Static Route',
                'base_path' => $this->object_name() . '/route',
                'dynamic' => true,
                /* Add some extra infos for config_manager create object */
                'controller' => array( 
                    'config_manager' => array(
                        'new_label' => 'Destination IP address',
                        'new_rule' => 'required|valid_ip',
                        'summary_headings' => array('Destination', 'Interface', 'Netmask', 'Gateway'),
                        // List of fields to display in summary (object name 
                        // being included by default
                        'summary_fields' => array('interface', 'netmask', 'gateway'),
                    ),
                ),
                'methods' => array(
                    'create' => array(
                        'name' => 'Create',
                        'description' => 'Create a Static Route',
                        'request' => 'POST'
                        ),
                    'retrieve' => array(
                        'name' => 'Retrieve',
                        'description' => 'Retrieve a Static Route',
                        'request' => 'GET'
                        ),
                    ),
            )
        );

        return parent::configure();
    }

    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     * @param[in out] $output
     *
     * @return
     */
    public function api_create_route($name, $data=null, &$output = null) {
        $route = new Sng_network_route_class($this->node(), $this->object_name().'/route', $name);
        $route->configure();
        if($data) {
            $route->set_data_values($data);
        }
        return $route;
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     * @param[in out] $output
     *
     * @return
     */
    public function api_retrieve_route($name, $data=null, &$output = null) {
        $objs = $this->get_aggregate_objects('route');
        return $objs[$name];
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     * @param[in out] $output
     *
     * @return
     */
    public function api_update_profile($name, $data=null, &$output = null) {
        $profile = $this->api_retrieve_profile($name);
        if($profile) {
            if ($profile->validate($data,$output)) {
                if (true == $profile->save()) {
                    return true;
                }
            }
        }
        return false;
    }

    public function can_restore(&$reason)
    {
        // Prevent calling parent as service status will be checked
        return true;
    }
    /**
     * @brief Create config jobs for dialplan module
     *           
     * @param[in out] $config_manager
     *           
     * @return
     */
    public function reload_generate_config(&$config_manager, $obj_type=null)
    {
        if(!$this->_generate_config($config_manager, $obj_type)) return false;
        return parent::reload_generate_config($config_manager, $obj_type);
    }
    /**
     * @brief 
     *
     * @param[in out] $obj_type
     *
     * @return 
     */
    public function reload_clear_modified($obj_type=null)
    {
        // the hard way :)
        Safe_object_serializer_class::get_serializer()->clear_modified($this->object_name().'/route', true);
    }

    /**
     * @brief 
     *
     * @param[in out] $config_manager
     *
     * @return 
     */
    public function generate_config(&$config_manager)
    {
        if(!$this->_generate_config($config_manager)) return false;
        return parent::generate_config($config_manager);
    }
    /**
     * @brief Invoked after a successfull write_config
     *
     * @return
     */
    public function post_write_config($obj_type=null)
    {
        // restart service
        $this->restart();
        return parent::post_write_config($obj_type);
    }
    /**
     * @brief 
     *
     * @param[in out] $config_manager
     *
     * @return 
     */
    private function _generate_config(&$config_manager, $obj_type=null)
    {
        $adapters = $this->node()->hardware()->adapters();
        foreach($adapters as $if){
            $file = "/etc/sysconfig/network-scripts/route-".$if->name();
            $config_manager->add_config(
                new Safe_configuration_class(
                    $file, '', 
                    Safe_configuration_class::CFG_DELETE, 
                    Safe_configuration_class::CFG_FILE));
        }

        // Loop around static routes to create interface route def
        $interfaces = array();
        foreach($this->get_aggregate_objects('route') as $route) {
            $tmp = $route->get_data_values(false);
            $if = $tmp['interface'];
            unset($tmp['interface']);
            $data['address'] = $route->name();
            $data = array_merge($data,$tmp);
            $id = count($interfaces[$if]);

            $route_def = array();
            foreach($data as $k => $v) {
                $route_def[strtoupper($k).$id] = $v;
            }
            $interfaces[$if][] = $route_def;
        }

        // Loop around interface route def to create file
        foreach($interfaces as $if => $routes) {
            $content = '';

            foreach($routes as $route){
                // Write all entries
                foreach($route as $k => $v){
                    $content[] = $k.'='.$v;
                }
            }

            $file = "/etc/sysconfig/network-scripts/route-".$if;
            $config_manager->add_config(
                new Safe_configuration_class(
                    $file, $content) );
        }

        return true;
    }

}
/* End of file sng_firewall_service_class.php */
