#!/bin/bash

UPDATE_DIR=$1
UPDATE_WORKING=$2

echo $$ > ${UPDATE_WORKING}/update.pid
echo "Starting update"
date
echo "--------------------------------------------------------------"

# Read update jobs and execute

while read line; do
  # trim
  line=`echo ${line}`
  if [ -n "$line" ] && ! [[ "$line" == \#* ]] ; then
    label=`echo ${line} | cut -d"=" -f1`
    cmd=`echo ${line} | cut -d"=" -f2`
    echo "${label}" > ${UPDATE_WORKING}/update.status
    echo "Starting ${cmd}"
    cmd="${UPDATE_DIR}/${cmd} ${UPDATE_DIR} ${UPDATE_WORKING}"
    ${cmd}
    rc=$?
    echo "Completed with ${rc}"
    echo "--------------------------------------------------------------"
    if [ "0" -ne "${rc}" ]; then
      break
    fi
  fi

done < ${UPDATE_DIR}/conf/update-jobs.cfg


echo "Update Done"
echo "Update Done" > ${UPDATE_WORKING}/update.status
echo ${rc} > ${UPDATE_WORKING}/update.done
rm -f ${UPDATE_WORKING}/update.pid
