<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/*
 * FS distributor module class
*/
require_once ('application/helpers/safe_helper.php');
safe_require_class('safe_module_class');

class Fs_distributor_resource_config_class extends Safe_configurable_object_class
{
    /**
     * @brief Constructor
     *           
     * @param[in out] $parent_name
     * @param[in out] $name
     *           
     * @return
     */
    public function __construct($node, $parent_name, $name)
    {
        parent::__construct($parent_name, $name, $node);
    }
    /**
     * @brief Configure the config class object
     *         
     * @return
     */
    public function configure()
    {
        // General settings
        $this->add_field('resource', 'Resource', 'text', '',50);
        $this->set_field_rules('resource', 'required');
        $this->set_field_help('resource', 
            array( 
                'Resource Identifier.'
            )
        );
        $this->add_field('weight', 'Weight', 'text', '1',10);
        $this->set_field_rules('weight', 'required|integer|greater_than[0]');
        $this->set_field_help('weight', 
            array( 
                'Weight of the resource.',
                'Defines the number of time this Resource will be returned before balancing to next resource in list.'
            )
        );
        $this->add_field('description', 'Description', 'text', '',50);
        return parent::configure();
    }

    public function weight()
    {
        return $this->get_data_value('weight', false);
    }
    public function resource()
    {
        return $this->get_data_value('resource', false);
    }
}

class Fs_distributor_list_config_class extends Safe_configurable_object_class
{
    /**
     * @brief Constructor
     *
     * @param[in out] $parent_name
     * @param[in out] $name
     *
     * @return
     */
    public function __construct($node, $parent_name, $name)
    {
        parent::__construct($parent_name, $name, $node);
    }
    /**
     * @brief Configure the config class object
     *
     * @return
     */
    public function configure()
    {
        // General settings
        $this->add_enum_field('enable', 'Enable List', 'dropdown', 'true', $this->enable_disable_enum());
        $this->set_field_help('enable', 
            array( 
                'Enable/Disable List from being used by Load Balancing module.'
            )
        );
        $this->add_field('description', 'Description', 'text', '',50);


        // Register objects
        $this->register_aggregate_object('resource', 
            array(
                'name' => 'Resource',
                'base_path' => $this->object_name() . '/resource',
                'dynamic' => true,
                /* Add some extra infos for config_manager create object */
                'controller' => array( 
                    'config_manager' => array(
                        'summary_headings' => array('Id', 'Resource', 'Weight', 'Description'),
                        // List of fields to display in summary (object name 
                        // being included by default
                        'summary_fields' => array('resource', 'weight', 'description'),
                    ),
                ),
                'methods' => array(
                    'create' => array(
                        'name' => 'Create',
                        'description' => 'Create a Resource',
                        'request' => 'POST',
                        ),
                    'retrieve' => array(
                        'name' => 'Retrieve',
                        'description' => 'Retrieve a Resource',
                        'request' => 'GET',
                        ),
                    'update' => array(
                        'name' => 'Update',
                        'description' => 'Update a Resource',
                        'request' => 'POST',
                        ),
                    'delete' => array(
                        'name' => 'Delete',
                        'description' => 'Delete a Resource',
                        'request' => 'POST',
                        ),
                    ),
            )
        );
        return parent::configure();
    }
    public function resources()
    {
        $nodes = $this->get_aggregate_objects('resource');
        return $nodes;
    }

    public function is_enabled()
    {
        $data = $this->get_data_values(false);
        return ('true' == $data['enable']);
    }
    public function weight()
    {
        $weight = 0;
        foreach($this->resources() as $node){
            $weight += $node->weight();
        }
        return $weight;
    }
    /**
     * @brief 
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return 
     */
    public function api_create_resource($name, $data=null) {
        $condition = new Fs_distributor_resource_config_class($this->node(), $this->object_name() . '/resource', $name);
        $condition->configure();
        if($data) {
            $condition->set_data_values($data);
        }
        return $condition;
    }
    /**
     * @brief 
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return 
     */
    public function api_retrieve_resource($name, $data=null) {
        $nodes = $this->resources();
        return $nodes[$name];
    }
    /**
     * @brief 
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return 
     */
    public function api_update_resource($name, $data=null) {
        $nodes = $this->resources();
        if($nodes[$name]) {
            $nodes[$name]->set_data_values($data);
            // Run validation
            return true;
        }
        return false;
    }
    /**
     * @brief 
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return 
     */
    public function api_delete_resource($name, $data=null) {
        $nodes = $this->resources();
        if($nodes[$name]) {
            if($nodes[$name]->can_dispose()) {
                return $nodes[$name]->dispose();
            }
        }
        return false;
    } 
    /**
     * @brief Delete an object
     *         Mark the object as deleted
     *         
     * @return
     *         true on success
     */
    public function dispose()
    {
        foreach($this->resources() as $node){
            $node->dispose();
        }
        return parent::dispose();
    }
}
class Fs_distributor_config_class extends Safe_configurable_object_class
{
    /**
     * @brief Constructor
     *           
     * @param[in out] $parent_name
     * @param[in out] $name
     *           
     * @return
     */
    public function __construct($node, $parent_name)
    {
        parent::__construct($parent_name, "distributor");
    }
    /**
     * @brief Configure the config class object
     *         
     * @return
     */
    public function configure()
    {
        // General settings
        $this->add_enum_field('enable', 'Enable Load Balancing', 'dropdown', 'false', $this->enable_disable_enum());
        $this->set_field_help('enable', 
            array( 
                'Enable/Disable Balancing module.'
            )
        );

        return parent::configure();
    }
}



class Fs_distributor_module_class extends Fs_module_class
{
    protected $_obj_base_path = '';
    /**
     * @brief
     *           
     * @param[in out] $fs_app
     *           
     * @return
     */
    public function __construct($fs_app)
    {
        parent::__construct($fs_app, "distributor");
        $this->_obj_base_path = $fs_app->object_name();
    }
    /**
     * @brief
     *         
     * @return
     */
    public function configure()
    {
        // Set the module description
        $this->set_description("Load Balancing");

        // Create the config object
        $cfg = new Fs_distributor_config_class($this->node() , $this->_obj_base_path, $this->name());
        // Synch with DB
        $cfg->configure();
        $cfg->synch();
        // Attach config to module
        $this->set_config($cfg);
        // Register objects
        $this->register_aggregate_object('list', 
            array(
                'name' => 'List',
                'base_path' => $this->_obj_base_path . '/list',
                'dynamic' => true,
                'has_child' => true,
                /* Add some extra infos for config_manager create object */
                'controller' => array( 
                    'config_manager' => array(
                        'summary_headings' => array('Name', 'Status', 'Description'),
                        // List of fields to display in summary (object name 
                        // being included by default
                        'summary_fields' => array('enable', 'description'),
                    ),
                ),
                'methods' => array(
                    'create' => array(
                        'name' => 'Create',
                        'description' => 'Create a List',
                        'request' => 'POST',
                        ),
                    'retrieve' => array(
                        'name' => 'Retrieve',
                        'description' => 'Retrieve a List',
                        'request' => 'GET',
                        ),
                    'update' => array(
                        'name' => 'Update',
                        'description' => 'Update a List',
                        'request' => 'POST',
                        ),
                    'delete' => array(
                        'name' => 'Delete',
                        'description' => 'Delete a List',
                        'request' => 'POST',
                        ),
                    ),
            )
        );

        return parent::configure();
    }
    public function lists()
    {
        return $this->get_aggregate_objects('list');
    }
    /**
     * Decides whether the module is enabled or disabled
     * @see Fs_module_class::is_enabled()
     */
    public function is_enabled($mod_name = "")
    {
        // Always enable mod_distributor, so it can support reload
        return true;
        /*
        $enabled = false;
        $cfg  = $this->config();
        if('true' == $cfg->get_data_value('enable', false)){
            // Loop around list to check if at least one is enabled
            foreach($this->lists() as $list){
                if($list->is_enabled()){
                    $enabled = true;
                    break;
                }
            }
        }
        return $enabled;
         */
    }

    /**
     * @brief 
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return 
     */
    public function api_create_list($name, $data=null) {
        $list = new Fs_distributor_list_config_class($this->node(), $this->_obj_base_path . '/list', $name);
        $list->configure();
        if($data) {
            $list->set_data_values($data);
        }
        return $list;
    }
    /**
     * @brief 
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return 
     */
    public function api_retrieve_list($name, $data=null) {
        $lists = $this->lists();
        return $lists[$name];
    }
    /**
     * @brief 
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return 
     */
    public function api_update_list($name, $data=null) {
        $lists = $this->lists();
        if($lists[$name]) {
            $lists[$name]->set_data_values($data);
            // Run validation
            return true;
        }
        return false;
    }
    /**
     * @brief 
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return 
     */
    public function api_delete_list($name, $data=null) {
        $lists = $this->lists();
        if($lists[$name]) {
            if($lists[$name]->can_dispose()) {
                return $lists[$name]->dispose();
            }
        }
        return false;
    }
    /**
     * @brief Create config jobs for dialplan module
     *           
     * @param[in out] $config_manager
     *           
     * @return
     */
    public function reload_generate_config(&$config_manager, $obj_type=null)
    {
        if(!$this->_generate_config($config_manager)) return false;
        return parent::reload_generate_config($config_manager, $obj_type);
    }

    /**
     * @brief 
     *
     * @param[in out] $obj_type
     *
     * @return 
     */
    public function reload_clear_modified($obj_type=null)
    {
        // the hard way :)
        Safe_object_serializer_class::get_serializer()->clear_modified($this->_obj_base_path, true);
    }

    /**
     * @brief 
     *
     * @param[in out] $config_manager
     *
     * @return 
     */
    public function generate_config(&$config_manager)
    {
        if(!$this->_generate_config($config_manager)) return false;
        return parent::generate_config($config_manager);
    }
    /**
     * @brief 
     *
     * @param[in out] $config_manager
     *
     * @return 
     */
    private function _generate_config(&$config_manager)
    {
        // Get our configuration data (unresolved)
        $cfg = $this->config()->get_data_values(false);
        // Create xml document
        $xml_writer = new XMLWriter();
        $xml_writer->openMemory();
        $xml_writer->startDocument('1.0', 'UTF-8');
        $xml_writer->startElement('configuration');
        $xml_writer->writeAttribute('name', 'distributor.conf');
        $xml_writer->writeAttribute('description', 'Distributor Configuration');
        $xml_writer->startElement('lists');
        if('true' == $cfg['enable']){
            // Process all lists
            foreach($this->lists() as $list){
                if($list->is_enabled()){
                    $xml_writer->startElement('list');
                    $xml_writer->writeAttribute('name', $list->name());
                    $xml_writer->writeAttribute('total-weight', $list->weight());
                    // Add nodes
                    foreach($list->resources() as $node){
                        $xml_writer->startElement('node');
                        $xml_writer->writeAttribute('name', $node->resource());
                        $xml_writer->writeAttribute('weight', $node->weight());
                        $xml_writer->endElement(); // Close node
                    }

                    $xml_writer->fullEndElement(); // Close list
                }
            }
        }

        $xml_writer->fullEndElement(); // Close lists
        $xml_writer->fullEndElement(); // Close Configuration
        // Content
        $xmlstr = Safe_format_xml($xml_writer->outputMemory(true));
        $file = 'autoload_configs/distributor.conf.xml';
        $config_manager->add_config(new Safe_configuration_class($file, $xmlstr));
        return true;
    }
    /**
     * @brief Invoked after a successfull write_config
     *         
     * @return
     */
    public function post_write_config()
    {
        // Reload configuration
        if(!$this->fs_app()->reloadxml()) return false;
        $output = array();
        $rc = $this->eslapi_execute("distributor_ctl reload", '', $output);
        if (!$rc) return $rc;
        return parent::post_write_config();
    }
    public function support_reload(&$cfg_modified = null)
    {
        parent::support_reload($cfg_modified);
        return true;
    }
}
/* End of file sng_rest_module_class.php */

