<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/*
 * FS CORE module class
*/
require_once ('application/helpers/safe_helper.php');
safe_require_class('safe_service_class');
safe_module_require_class('fs', 'application');
safe_module_require_class('sng', 'transcoding_config');
class Fs_core_config_class extends Safe_configurable_object_class
{
    /**
     * @brief Constructor
     *           
     * @param[in out] $parent_name
     * @param[in out] $name
     *           
     * @return
     */
    public function __construct($node, $parent_name)
    {
        parent::__construct($parent_name, "core");
    }
    /**
     * @brief Configure the config class object
     *         
     * @return
     */
    public function configure()
    {
        /*
         * Max Sessions
        */
        $this->add_field('max-sessions', 'Max Sessions', 'int', 4000);
        $this->set_field_rules('max-sessions', 'required|greater_than[-1]');
        $this->set_field_help('max-sessions', 'Global maximum number of simultaneous sessions.');
        /*
         * Sessions Per Second
        */
        $this->add_field('sessions-per-second', 'Sessions Per Second', 'int', 150);
        $this->set_field_rules('sessions-per-second', 'required|greater_than[-1]');
        $this->set_field_help('sessions-per-second', 'Global maximum number of sessions per second.');
        /*
         * Log Level
        */
        $log_level = array(
            'debug' => 'Debug',
            'info' => 'Info',
            'notice' => 'Notice',
            'warning' => 'Warning',
            'err' => 'Error',
            'crit' => 'Critical',
            'alert' => 'Alert'
        );
        $this->add_enum_field('loglevel', 'Log Level', 'dropdown', 'info', $log_level);
        $this->set_field_help('loglevel', 'Global logging level for the call control engine. Listed in order of severity.');

        $this->add_enum_field('sofia/tracelevel', 'SIP Trace Log Level', 'dropdown', 'debug', $log_level);
        $this->set_field_help('sofia/tracelevel', 
            array(
                'The log level to use when logging SIP traces (SIP messages logged) for SIP profiles with tracing enabled.',
                'If a log level is used that is below the core log level, the SIP messages will not be logged even when the SIP profiles have tracing enabled.')
            );
        return parent::configure();
    }
    /**
     * @brief Returns a config description string
     *         
     * @return string
     */
    public function description()
    {
        return parent::description();
    }
}
class Fs_core_module_class extends Fs_module_class
{
    /**
     * @brief
     *           
     * @param[in out] $fs_app
     *           
     * @return
     */
    public function __construct($fs_app)
    {
        parent::__construct($fs_app, "core");
    }
    /**
     * @brief
     *         
     * @return
     */
    public function configure()
    {
        // Set the module description
        $this->set_description("Core");
        // Create the config object
        $cfg = new Fs_core_config_class($this->node() , $this->fs_app()->object_name() , $this->name());
        // Synch with DB
        $cfg->configure();
        $cfg->synch();
        // Attach config to module
        $this->set_config($cfg);
        return parent::configure();
    }
    /**
     * @brief
     *           
     * @param[in out] $config_manager
     *           
     * @return
     */
    public function reload_generate_config(&$config_manager, $obj_type=null)
    {
        return $this->generate_config($config_manager);
    }
    public function reload_clear_modified($obj_type=null)
    {
        return $this->clear_configuration_modified();
    }
    public function generate_config(&$config_manager)
    {
        // Get our configuration data (unresolved)
        $cfg = $this->config()->get_data_values_exploded(false);
        // Create xml document
        $xml_writer = new XMLWriter();
        $xml_writer->openMemory();
        $xml_writer->startDocument('1.0', 'UTF-8');
        // Document container
        $xml_writer->startElement('include');
        foreach ($cfg['__all__'] as $k => $v) {
            $xml_writer->startElement('param');
            $xml_writer->writeAttribute('name', $k);
            $xml_writer->writeAttribute('value', $v);
            $xml_writer->EndElement();
        }
        // Check if we're in software transcoding mode
        $transcoding_config = new Sng_transcoding_config_class($this->node());
        $transcoding_config->configure();
        if( !$transcoding_config->is_enabled()) {
            // Grab RTP ports for software transcoding
            $transcoding_config->udp_ports($start, $stop);
            $xml_writer->startElement('param');
            $xml_writer->writeAttribute('name', 'rtp-start-port');
            $xml_writer->writeAttribute('value', $start);
            $xml_writer->EndElement();
            $xml_writer->startElement('param');
            $xml_writer->writeAttribute('name', 'rtp-end-port');
            $xml_writer->writeAttribute('value', $stop);
            $xml_writer->EndElement();
        }
        // Close settings
        $xml_writer->EndElement();
        $xml_writer->endDocument();
        $xmlstr = Safe_format_xml($xml_writer->outputMemory(true));
        $file = 'autoload_configs/switch_additional.xml';
        $config_manager->add_config(new Safe_configuration_class($file, $xmlstr));

        // No take care of other modules if set
        unset($cfg['__all__']);
        foreach($cfg as $mod=>$mod_cfg) {
            // Create xml document
            $xml_writer = new XMLWriter();
            $xml_writer->openMemory();
            $xml_writer->startDocument('1.0', 'UTF-8');
            // Document container
            $xml_writer->startElement('include');
            foreach ($mod_cfg as $k => $v) {
                $xml_writer->startElement('param');
                $xml_writer->writeAttribute('name', $k);
                $xml_writer->writeAttribute('value', $v);
                $xml_writer->EndElement();
            }

            $xml_writer->EndElement();
            $xml_writer->endDocument();
            $xmlstr = Safe_format_xml($xml_writer->outputMemory(true));
            $file = 'autoload_configs/'.$mod.'_additional.xml';
            $config_manager->add_config(new Safe_configuration_class($file, $xmlstr));
        }
        return parent::generate_config($config_manager);
    }
    /**
     * @brief Overload Safe_module::support_reload
     *           
     * @param[in out] $cfg_modified
     *           
     * @return
     */
    public function support_reload(&$cfg_modified = null)
    {
        parent::support_reload($cfg_modified);
        return true;
    }
    /**
     * @brief Invoked after a successfull write_config
     *         
     * @return
     */
    public function post_write_config()
    {
        // Check if FS is running
        if (Safe_service_class::STATUS_RUNNING == $this->fs_app()->status()) {
            $cfg = $this->config()->get_data_values_exploded(false);
            // Prepare switch reload parameters (requires name remapping)
            $data = $cfg['__all__'];
            $reload_param = array(
                'max_sessions' => $data['max-sessions'],
                'sps' => $data['sessions-per-second'],
                'loglevel' => $data['loglevel'],
            );
            // Loop to apply new parameters value
            foreach ($reload_param as $k => $v) {
                $output = array();
                $rc = $this->eslapi_execute("fsctl " . $k . " " . $v, '', $output);
                if (!$rc) return $rc;
            }
            // Same but for other modules parameters (assuming no conversion 
            // required)
            unset($cfg['__all__']);
            foreach($cfg as $mod=>$data) {
                // Loop to apply new parameters value
                foreach ($data as $k => $v) {
                    $output = array();
                    $rc = $this->eslapi_execute($mod ." " . $k . " " . $v, '', $output);
                    if (!$rc) return $rc;
                }
            }
        }
        return parent::post_write_config();
    }
}
/* End of file fs_core_module_class.php */
