<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
 */
/**
 * FS Call Admission Control Base Class
 * @author Shaunt Libarian
 */
require_once ('application/helpers/safe_helper.php');
safe_require_class('object');
safe_require_class('hardware');
safe_module_require_class('nsc', 'application');
safe_module_require_class('fs', 'ipaddr_cac_condition');
safe_module_require_class('fs', 'user_cac_condition');
class Fs_cac_rule_class extends Safe_configurable_object_class
{
    private $_sip_profiles;
    private $_conditions;
    /**
     * @brief 
     *
     * @param[in out] $node
     * @param[in out] $parent_name
     * @param[in out] $name
     *
     * @return 
     */
    public function __construct($node, $parent_name, $name)
    {
        // Parent constructor to invoke unserialize if needed
        parent::__construct($parent_name, $name, $node);
    }
    /**
     * @brief 
     *
     * @return 
     */
    public function configure()
    {
        //Adds hidden record in db to hold sip-profiles
        $this->add_field('sip-profiles', 'sip profiles', 'private', array());
        // Register objects
        $this->register_aggregate_object('ipaddr', 
            array(
                'name' => 'IP Address Condition',
                'dynamic' => true,
                'base_path' => $this->object_name() . '/ipaddr',
                'methods' => array(
                    'create' => array(
                        'name' => 'Create',
                        'description' => 'Create a CAC IP Address Condition',
                        'request' => 'POST',
                        ),
                    'retrieve' => array(
                        'name' => 'Retrieve',
                        'description' => 'Retrieve a CAC IP Address Condition',
                        'request' => 'GET',
                        ),
                    'update' => array(
                        'name' => 'Update',
                        'description' => 'Update a CAC IP Address Condition',
                        'request' => 'POST',
                        ),
                    'delete' => array(
                        'name' => 'Delete',
                        'description' => 'Delete a CAC IP Address Condition',
                        'request' => 'POST',
                        ),
                    ),
            )
        );
        $this->register_aggregate_object('user', 
            array(
                'name' => 'User Condition',
                'dynamic' => true,
                'base_path' => $this->object_name() . '/user',
                'methods' => array(
                    'create' => array(
                        'name' => 'Create',
                        'description' => 'Create a CAC User Condition',
                        'request' => 'POST',
                        ),
                    'retrieve' => array(
                        'name' => 'Retrieve',
                        'description' => 'Retrieve a CAC User Condition',
                        'request' => 'GET',
                        ),
                    'update' => array(
                        'name' => 'Update',
                        'description' => 'Update a CAC User Condition',
                        'request' => 'POST',
                        ),
                    'delete' => array(
                        'name' => 'Delete',
                        'description' => 'Delete a CAC User Condition',
                        'request' => 'POST',
                        ),
                    ),
            )
        );

        return parent::configure();
    }
    /**
     * @brief 
     *
     * @return 
     */
    public function profile_binding()
    {
        return $this->get_data_value('sip-profiles', false);
    }
    /**
     * Pulls CAC conditions based on rule name and rule type
     *
     * @return array $_conditions
     *               							Array of conditions based on rule type and rule name
     */
    public function conditions($obj_type=null)
    {
        $conditions = array();
        if($obj_type) {
            $conditions = $this->get_aggregate_objects($obj_type);
        } else {
            $objs_def = $this->get_aggregate_object_definition();

            foreach($objs_def as $obj_type => $obj_def) {
                $tmp = $this->get_aggregate_objects($obj_type);
                if($tmp) {
                    $conditions = array_merge($conditions, $tmp);
                }
            }
        }

        return $conditions;
    }
    /**
     * @brief 
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return 
     */
    public function api_create_ipaddr($name, $data=null, &$output = null) {
        $condition = new Fs_ipaddr_cac_condition_class($this->node(), $this->object_name() . '/ipaddr', $name);
        $condition->configure();
        if($data) {
            $condition->set_data_values($data);
        }
        return $condition;
    }
    /**
     * @brief 
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return 
     */
    public function api_retrieve_ipaddr($name, $data=null, &$output = null) {
        $conditions = $this->conditions('ipaddr');
        return $conditions[$name];
    }
    /**
     * @brief 
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return 
     */
    public function api_update_ipaddr($name, $data=null, &$output = null) {
        $condition = $this->api_retrieve_ipaddr($name);
        if($condition) {
            if ($condition->validate($data,$output)) {
                if (true == $condition->save()) {
                    return true;
                }
            }
        }
        return false;
    }
    /**
     * @brief 
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return 
     */
    public function api_delete_ipaddr($name, $data=null, &$output = null) {
        $condition = $this->api_retrieve_ipaddr($name);
        if($condition) {
            if($condition->can_dispose($output)) {
                return $condition->dispose();
            }
        }
        return false;
    }
    /**
     * @brief 
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return 
     */
    public function api_create_user($name, $data=null, &$output = null) {
        $condition = new Fs_user_cac_condition_class($this->node(), $this->object_name() . '/user', $name);
        $condition->configure();
        if($data) {
            $condition->set_data_values($data);
        }
        return $condition;
    }
    /**
     * @brief 
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return 
     */
    public function api_retrieve_user($name, $data=null, &$output = null) {
        $conditions = $this->conditions('user');
        return $conditions[$name];
    }
    /**
     * @brief 
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return 
     */
    public function api_update_user($name, $data=null, &$output = null) {
        $condition = $this->api_retrieve_user($name);
        if($condition) {
            if ($condition->validate($data,$output)) {
                if (true == $condition->save()) {
                    return true;
                }
            }
        }
        return false;
    }
    /**
     * @brief 
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return 
     */
    public function api_delete_user($name, $data=null, &$output = null) {
        $condition = $this->api_retrieve_user($name);
        if($condition) {
            if($condition->can_dispose($output)) {
                return $condition->dispose();
            }
        }
        return false;
    }
}
?>
