<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * FS Advanced Dialplan Class
 * @author: Shaunt Libarian
 */
require_once ('application/helpers/safe_helper.php');
safe_require_class('object');
safe_require_class('hardware');
safe_module_require_class('fs', 'application');
class Fs_advanced_dialplan_class extends Safe_configurable_object_class
{
    public function __construct($node, $parent_name, $name)
    {
        // Parent constructor to invoke unserialize if needed
        parent::__construct($parent_name, $name, $node);
    }
    public function configure()
    {
        $this->add_field('data', 'XML Dialplan', 'hidden', '');
        parent::configure();
    }
    /**
     * Returns dialplan type
     * @return string
     */
    public function type()
    {
        return 'advanced';
    }
    public function description()
    {
        return "Advanced Call Routing Dialplan";
    }
    function display_xml_error($xmlstr)
    {
        $xml = explode("\n", $xmlstr);
        $errors = libxml_get_errors();
        $return = "";
        foreach ($errors as $error) {
            /*
            switch ($error->level) {
            case LIBXML_ERR_WARNING:
            $return .= "Warning $error->code: ";
            break;
            case LIBXML_ERR_ERROR:
            $return .= "Error $error->code: ";
            break;
            case LIBXML_ERR_FATAL:
            $return .= "Fatal Error $error->code: ";
            break;
            }
            */
            $return.= "\nLine: $error->line " . trim($error->message);
            $return.= "\n";
        }
        libxml_clear_errors();
        return $return;
    }
    // Overload save to validate data before save
    public function save($data, &$error)
    {
        // Steps to validate:
        //  1- Valid xml
        //  2- doesn't contain context element
        $error = "Fail to save dialplan";
        $xml_obj = null;
        // Disable error output
        libxml_use_internal_errors(true);
        $xml_validation = "<validation_____>" . $data['data'] . "\n</validation_____>";
        // Try to create a xml object
        $xml_obj = simplexml_load_string($xml_validation);
        if (!$xml_obj) {
            $error = "Invalid XML data.\n" . $this->display_xml_error($xml_validation);
            return false;
        }
        // Check for context element
        if (false != $xml_obj->xpath("//context")) {
            $error = "Context element not allowed.";
            return false;
        }
        // Check if root has a value (i.e. text element)
        $root_value = trim((string)$xml_obj[0]);
        if (strlen($root_value)) {
            $error = "Text value not allowed outside XML elements.\n" . $root_value;
            return false;
        }
        // All good, we can proceed to save
        $this->set_data_values($data);
        if (true == parent::save()) return true;
        return false;
    }
}
?>
