/*  
 * mirrorMOdes a array of all modes
 * [ Name, mime, CodeMirror Modes, [CodeMirror Option] ]
 * modes that bug in IE9 has been removed.
 *  this must be moved to a string and parse has a JSON for old browser compatibility.
 */
var mirrorModes = new Array(
                   	[ "C", "text/x-csrc", "text/x-csrc" ], 
                    [ "C++", "text/x-c++src", "text/x-c++src" ],
                    [ "Java", "text/x-java", "text/x-java" ], 
                    [ "Groovy", "text/x-groovy", "text/x-groovy" ],
                    [ "CoffeeScript", "text/x-coffeescript", "text/x-coffeescript" ], 
                    [ "CSS", "text/css", "text/css" ],
                    [ "Diff", "text/x-diff", "text/x-diff" ], 
                    [ "Groovy", "text/x-groovy", "text/x-groovy" ], 
                    [ "Haskell", "text/x-haskell", "text/x-haskell" ], 
                    [ "HTML", "text/html", "text/html" ], 
                    [ "JavaScript", "text/javascript", {"name":"javascript","json":true} ],
                    [ "JSON", "application/json", "application/json" ], 
                    [ "Jinja2", "jinja2", {"name":"jinja2","htmlMode":true} ],
                    [ "Lua", "text/x-lua", "text/x-lua" ], 
                    [ "Markdown", "text/x-markdown", "text/x-markdown" ], 
                    [ "NTriples", "text/n-triples", "text/n-triples" ], 
                    [ "Pascal", "text/x-pascal", "text/x-pascal" ],
                    [ "Perl", "text/x-perl", "text/x-perl" ], 
                    [ "PHP", "application/x-httpd-php", "application/x-httpd-php" ], 
                    [ "PHPplain", "text/x-php", "text/x-php" ], 
                    [ "PL/SQL", "text/x-plsql", "text/x-plsql" ], 
                    [ "Python2", "text/x-python", {"name":"python","version":2} ],
                    [ "Python3", "phyton3", {"name":"python",	"version":3} ], 
                    [ "R", "text/x-rsrc", "text/x-rsrc" ], 
                    [ "reStructuredText", "text/x-rst", "text/x-rst" ],
                    [ "Ruby", "text/x-ruby", "text/x-ruby" ],
                    [ "Rust", "text/x-rustsrc", "text/x-rustsrc" ], 
                    [ "Scheme", "text/x-scheme", "text/x-scheme" ], 
                    [ "Smalltalk", "text/x-stsrc", "text/x-stsrc" ], 
                    [ "SPARQL", "application/x-sparql-query", "application/x-sparql-query" ], 
                    [ "sTeX", "text/stex", "stex" ], 
                    [ "TiddlyWiki", "text/x-tiddlywiki", "tiddlywiki" ], 
                    [ "Velocity", "text/velocity", "text/velocity" ], 
                    [ "XML/XHTML", "application/xml", {"name":"xml","htmlMode":true} ], 
                    [ "XML", "xml", {"name":"xml","htmlMode":false} ], 
                    [ "XMLpure", "text/xml", "xmlpure" ], 
                    [ "YAML", "text/x-yaml", "text/x-yaml" ]
                   );


/*
 * Return the mode array
 */
function findMode(sMime) {
	var indexs = new Array();
	var aaModes = $.grep(mirrorModes, function(asMode, i) {
		if (asMode[1].match(RegExp(sMime, "i"))
				|| asMode[0].match(RegExp(sMime, "i"))) {
			indexs.push(i);
			return true;
		}
		return false;
	});
	if (indexs.length > 0)
		return new Array(indexs[0], aaModes[0]);
	return Array(-1, [ "text", "text/plain", "null" ]);
}

if (!$.browser.msie) {
	//alert(1);
	$('.CodeMirror-scroll').css({
		  "overflow": "auto",
		  "height": "500px",
		  "min-height": "500px",
		  "max-height": "500px",
		  "position": "relative"
		} );

}

var editorTextArea = document.getElementById('editorTextArea');
var defaultModeIndex = new Array(-1, [ "text", "text/plain", "null" ]);
// if (defaultModeMIME)
// defaultMode=findMode(defaultModeMIME);
// else
defaultMode = findMode("application/xml");


var editor = CodeMirror.fromTextArea(editorTextArea, {
	mode : defaultMode[1][2],
  lineNumbers: true,
  lineWrapping: false,
	onCursorActivity : function() {
		var coords = editor.getCursor();
		$('#editorLine').html(coords.ch);
		$('#editorColumn').html(coords.line);
	},
	onChange : function() {
		$('#editorLength').html(editor.lineCount());
		var min_height = parseInt($(editor.getScrollerElement()).parent().parent().find('.CodeMirror').first().css('min-height').replace("px",""),10);
		if( isNaN(min_height) == false && min_height>0 ){
			//set min height
			if($(editor.getScrollerElement()).children().first().height() > min_height ){
				$(editor.getScrollerElement()).parent().height($(editor.getScrollerElement()).children().first().height()+10);
				$(editor.getScrollerElement()).height($(editor.getScrollerElement()).children().first().height()+8);
			}else{
				$(editor.getScrollerElement()).parent().height(min_height+10);
				$(editor.getScrollerElement()).height(min_height+8);
			}
		}  
	}
});

$('#editorLength').html(editor.lineCount());

// load Mode Menu
// fixed for IE
$("#editorModeSelect").prepend(
//		new Option(defaultMode[1][0], String(defaultMode[0]), false, true));
		'<option value="'+String(defaultMode[0])+'" selected>'+defaultMode[1][0]+'</option>');
$.each(mirrorModes, function(i, mirrorMode) {
	//$("#editorModeSelect").append(new Option(mirrorMode[0], String(i)));
	$("#editorModeSelect").append('<option value="'+String(i)+'">'+mirrorMode[0]+'</option>');
});

//  load 
	
$('document').ready(function() {
	//  menu
	$("#editorModeSelect").change(function() {
		var i = $("#editorModeSelect option:selected").val();
		var mirrorMode = mirrorModes[i];
		editor.setOption('mode', mirrorMode[2]);

	});

	// toolbar
	$('#editorUndoButton').click(function() {
		editor.undo();
	});
	$('#editorRedoButton').click(function() {
		editor.undo();
	});

	$('#editorReIndentButton').click(function() {
		var lineCount = editor.lineCount();
		for ( var line = 0; line < lineCount; line++) {
			editor.indentLine(line);
		}
	});
	$('#editorReIndentSelectButton').click(function() {
		var cur = editor.getCursor()
		var start = editor.getCursor(true)["line"]
		var end = editor.getCursor(false)["line"]
		for ( var line = start; line <= end; line++) {
			editor.indentLine(line);
		}
	});	
	$('#editorJumpToLineButton').click(function() {
		var line = prompt("Jump to line:", "");
		if (line && !isNaN(Number(line))) {
			editor.setCursor(Number(line), 0);
			editor.setSelection({
				line : Number(line),
				ch : 0
			}, {
				line : Number(line) + 1,
				ch : 0
			});
			editor.focus();
		}
	});
	$('#editorLineNumbersButton').click(function(){
		if (editor.getOption('lineNumbers'))
			editor.setOption('lineNumbers',false);
		else
			editor.setOption('lineNumbers',true);
	});
	
	
	//the file loaded at the beginning
	editorLoad();
	//cancel: load the last saved file...
	$("#editorCancelButton").click(editorLoad);
	// the save button
	$('#editorSaveButton').click(editorSave);
	
	//TODO: plug the searching and replacing button 

});
