<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/*
 * Software class
*/
require_once ('application/helpers/safe_helper.php');
safe_require_class('safe_config_class');
safe_require_class('safe_node_class');
safe_require_class('safe_version_class');
safe_require_class('safe_license_class');
safe_require_class('safe_service_class');
class Safe_software_class extends Safe_object_class
{
    private $_application = null;
    private $_node = null;
    private $_services = array();
    protected $_version = null;
    protected $_license = null;
    public function __construct($node)
    {
        $this->_node = $node;
        parent::__construct($node->object_name() , 'software');
    }
    public function node()
    {
        return $this->_node;
    }
    protected function create_version()
    {
        // Process known stuff
        $this->_version = new Safe_version($this);
        $this->_version->configure($this->_node);
    }
    protected function create_license()
    {
        // Process known stuff
        $this->_license = new Safe_license($this);
        $this->_license->configure($this->_node);
    }

    public function &version()
    {
        if(!$this->_version){
            $this->create_version();
        }
        return $this->_version;
    }
    public function &license()
    {
        if(!$this->_license){
            $this->create_license();
        }
        return $this->_license;
    }
    public function &service($name)
    {
        if (isset($this->_services[$name])) return $this->_services[$name];
        else return null;
    }
    public function services()
    {
        return $this->_services;
    }
    public function add_service($service)
    {
        if (!isset($this->_services[$service->name() ])) {
            $this->_services[$service->name() ] = $service;
            return true;
        }
        safe_add_error("Service " . $service->name() . " already registered.");
        return false;
    }
    public function application()
    {
        return $this->_application;
    }
    public function set_application($application)
    {
        $this->_application = $application;
    }
    public function generate_config(&$config_mgr)
    {
        // Invoke generate on application (an application is a service ;)
        foreach ($this->_services as $service) {
            if (!$service->generate_config($config_mgr)) {
                return false;
            }
        }
        return true;
    }
    public function checklist(&$list)
    {
        // Check license
        $type='';
        if(!$this->_license->status($type)){
            $list[] = array(
                'module' =>'application',
                'obj_type' =>'license',
                'description' => $type,
            );
        }
        // Loop around services
        foreach ($this->_services as $service) {
            $service->checklist($list);
        }
    }
}
/* End of file safe_software_class.php */
