<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/*
 * Safe global application settings class
*/
require_once ('application/helpers/safe_helper.php');
safe_require_class('safe_module_class');
class Safe_application_settings_class extends Safe_configurable_object_class
{
    /**
     * @brief Constructor
     *           
     * @param[in out] $parent_name
     * @param[in out] $name
     *           
     * @return
     */
    public function __construct($node)
    {
        parent::__construct($node->path() , "settings");
    }
    /**
     * @brief Configure the config class object
     *         
     * @return
     */
    public function configure()
    {
        /*
         * Editor key binding mode
        */
        $editor_mode = array(
            'standard' => 'Standard',
            'vim' => 'Vi',
            'emacs' => 'Emacs'
        );
        $this->add_enum_field('keyboard_mode', 'Editor Key Bindings Mode', 'dropdown', 'standard', $editor_mode);
        $this->set_field_help('keyboard_mode', array(
            'Keyboard layout for text editor component.',
            'Select Standard if unsure.'
        ));
        return parent::configure();
    }
    /**
     * @brief Returns a config description string
     *         
     * @return string
     */
    public function description()
    {
        return parent::description();
    }
}
/* End of file safe_application_settings_class.php */
