# !bin/sh
#
# Author: William Adam
# Date: 15/02/2013
# Description:
#
# This script adjust the product according to brand
#
# Parameters:
# $1 - Product brand to use (Ex: "Vega Session Controller")
#
# Return code:
# 0 - No error
#
# Copyright: Sangoma Technologies Corp. 2013

product=$1

if [ ! "${product}" ]; then
  echo "Product brand not specified."
  # Check for installed license (to get product brand)
  license_file=`grep /usr/local/sng/conf/prod-def.xml -e "<license>" | sed 's/<\/*license>//g'`
  # Check if old prod-def.xml (ie. using xinclude)
  if [ -z "$license_file" ]; then
    prod_def_file=`grep /usr/local/sng/conf/prod-def.xml -e xi:include | sed -e 's/.*href="\(.*\)".*/\1/'`
    if [ -f "$prod_def_file" ]; then
      license_file=`grep ${prod_def_file} -e "<license>" | sed 's/<\/*license>//g'`
    fi
  fi

  product=`/usr/local/sng/scripts/product-brand.sh $license_file`
fi


sng_dir=/usr/local/sng
sng_conf_dir=$sng_dir/conf
product_text=${product}
product=`echo ${product} | cut -d= -f2 | tr '[:upper:]' '[:lower:]' | sed 's/ /_/g'`


# Check if need to adjust web template
webtemplate=/var/webconfig/htdocs/templates/sng
if [ -d $webtemplate ];then
  # Be sure we can access templates directory
  sudo chown webconfig -R $webtemplate

  if [ -f $webtemplate/images/${product}.png ]; then
    rm -f $webtemplate/images/logo.png
    ln -s $webtemplate/images/${product}.png $webtemplate/images/logo.png
  fi

  if [ -f $webtemplate/images/${product}_login.png ]; then
    rm -f $webtemplate/images/SNG_logo.png
    ln -s $webtemplate/images/${product}_login.png $webtemplate/images/SNG_logo.png
  fi
fi

# Update product definition
if [ -d $sng_conf_dir ];then

  if [ -f $sng_conf_dir/$product.xml ]; then
    rm -f $sng_conf_dir/prod-def.xml
    ln -s $sng_conf_dir/$product.xml $sng_conf_dir/prod-def.xml
  fi
fi

# Adjust menus
webmenu=/var/webconfig/htdocs/menus
if [ -d $webmenu ];then
  # Be sure we can access templates directory
  sudo chown webconfig -R $webmenu

  # backup old menus
  mkdir -p $webmenu/backup
  find $webmenu -maxdepth 1 -type f -name "*" -exec mv -f {} $webmenu/backup \;

  # Create menus
  python $sng_dir/scripts/python/sngprod.py -d \
    $sng_conf_dir/$product.xml \
    -a menu -o $webmenu/

fi

# Get short product name
product_short=`grep /usr/local/sng/conf/prod-def.xml -e '<product' | sed -e 's/.*<product.*name=\"\([^"]*\)\">.*/\1/'`
# Ensure log symlink exists
if [ -d "/usr/local/${product_short}/log" ]; then
  ln -sf /usr/local/${product_short}/log /var/log/${product_short}
fi

# Get the about file to grab version
version_file=`grep /usr/local/sng/conf/prod-def.xml -e "<about>" | sed 's/<\/*about>//g'`
# extract version
if [ -f ${version_file} ]; then
  version=`grep ${version_file} -e product_version | sed -e 's/.*product_version=\"\([^"]*\)\" .*/\1/'`
  release=`grep ${version_file} -e release_version | sed -e 's/.*release_version=\"\([^"]*\)\" .*/\1/'`
else
  version="?"
  release="?"
fi

# update issue (console login banner)
echo $product_text "-" ${version} "("${release}")" > /etc/issue
echo "" >> /etc/issue
echo $product_text "-" ${version} "("${release}")" > /etc/release
echo "" >> /etc/release

# update sshd banner
echo $product_text "-" ${version} "("${release}")" > /etc/banner
echo "" >> /etc/banner

#Ensure banner is displayed
sed -i /etc/ssh/sshd_config -e 's/^.*Banner.*/Banner \/etc\/banner/g'

#Update boot welcome
sed -i /etc/system/product -e "s/^name =.*/name = ${product_text}/g"
sed -i /etc/system/product -e "s/^version =.*/version = ${version}/g"





