# !bin/sh
#
# Author: Jean-Philippe Boily, jr. eng.
# Date: 15/06/2011
# Description:
#
# Look for updates using the product specific repositories using the name of the
# product given as the first argument.
# 
# Parameters:
# $1 - Yum configuration file path
# $2 - Product name
# $3 - repo type (base|patches|upgrades)
#
# Return code:
# 0 - No error
# 1 - check-update cmd failed
# 2 - No updates available
#
# Copyright: Sangoma Technologies Corp. 2011

yumConfPath=$1
prodName=$2
repoType=$3

sudo yum -c $yumConfPath --enablerepo=$prodName-$repoType check-update

rc=$?

if [ "$rc" -eq 1 ]; then
  echo "check-update failed"
  exit 1
fi

if [ "$rc" -eq 0 ]; then
  echo "No updates available"
  exit 2
fi


