<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/*
 * Node class
*/
require_once ('application/helpers/safe_helper.php');
safe_require_class('safe_node_class');
safe_require_class('safe_hardware_class');
safe_module_require_class('sng', 'transcoding_adapter');
safe_module_require_class('sng', 'ethernet_adapter');
class Sng_transcoding_detector_class extends Safe_hardware_adapter_detector_class
{
    public function __construct()
    {
        parent::__construct(Safe_hardware_adapter_class::TRANSCODING_ADAPTER);
    }
    public function detect($hardware, $user_arguments = null)
    {
        $output = array();
        $eth_list = array();
        $hardware->node()->execute("/usr/local/sng/bin/sng-detect-adapters transcoding", $output);
        foreach ($output as $line) {
            $info = explode(" ", $line);
            // Get the adpter info
            $ifname = $info[1];
            $mac = $info[2];
            // IP and mask may not be present in case IP address not assigned to
            // interface
            if (isset($info[3])) {
                $ip = $info[3];
                $mask = $info[4];
            } else {
                $ip = null;
                $mask = null;
            }
            // Create the transcoding adapter class
            $adapter = new Sng_transcoding_adapter_class($hardware, $ifname, $mac, $ip, $mask);
            $adapter->configure();
            $adapter->synch();
            if (isset($arguments)) $adapter->detect_modules($arguments);
            $eth_list[$ifname] = $adapter;
        }
        return $eth_list;
    }
}
class Sng_management_detector_class extends Safe_hardware_adapter_detector_class
{
    public function __construct()
    {
        parent::__construct(Safe_hardware_adapter_class::ETHERNET_ADAPTER);
    }
    public function detect($hardware, $user_arguments = null)
    {
        $arguments = (isset($user_arguments)) ? $user_arguments : array();
        $output = array();
        $eth_list = array();
        $hardware->node()->execute("/usr/local/sng/bin/sng-detect-adapters management", $output);
        //$hardware->node()->execute("/usr/local/sng/bin/sng-detect-adapters all",$output);
        foreach ($output as $line) {
            $info = explode(" ", $line);
            // Get the adpter info
            $ifname = $info[1];
            $mac = $info[2];
            // IP and mask may not be present in case IP address not assigned to
            // interface
            if (isset($info[3])) {
                $ip = $info[3];
                $mask = $info[4];
            } else {
                $ip = '';
                $mask = '';
            }
            // Create the ethernet adapter class
            //$adapter = new Safe_ethernet_adapter_class($hardware, $ifname, $mac, $ip, $mask);
            $adapter = new Sng_ethernet_adapter_class($hardware, $ifname, $mac, $ip, $mask);
            $adapter->configure();
            $adapter->synch();
            $eth_list[$ifname] = $adapter;
        }
        return $eth_list;
    }
}
/* End of file safe_transcoding_detector_class.php */
