<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/*
 * Service class
*/
require_once ('application/helpers/safe_helper.php');
require_once ('safe_module_class.php');
class Safe_service_class extends Safe_module_class
{
    /*
     * Service status enumeration
     * TODO(wadam) values are result of tests with service exit status
    */
    const STATUS_ERROR = - 1;
    const STATUS_UNRECOGNIZED = 1;
    const STATUS_RUNNING = 0;
    const STATUS_STOPPED = 3;
    const STATUS_DEAD = 2;
    /* Service startup modes */
    const STARTUP_MANUAL = 'manual';
    const STARTUP_AUTOMATIC = 'automatic';
    /* service kill signals */
    const SIGHUP = 'SIGHUP';
    /* Private data */
    private $_process_name;
    /* Functions */
    public function __construct($software, $name, $process_name = null)
    {
        parent::__construct($software, $name, "service");
        // process name may be different than service name (ntg service is
        // freeswitch for example)
        if (isset($process_name)) $this->_process_name = $process_name;
        else $this->_process_name = $name;
    }
    public function configure()
    {
        $methods = array();
        // expose service as aggregate object
        if(true === $this->allow_user_ctl()) {
            $methods = array(
                        'status' => array(
                            'name' => 'Service Status',
                            'description' => 'Returns service status and statistics.',
                            'request' => 'GET',
                        ),
                        'start' => array(
                            'name' => 'Start Service',
                            'description' => 'Starts the service and change startup mode to automatic.',
                            'request' => 'POST',
                        ),
                        'stop' => array(
                            'name' => 'Stop Service',
                            'description' => 'Stops the service and change startup mode to manual.',
                            'request' => 'POST',
                        ),
                        'restart' => array(
                            'name' => 'Start Service',
                            'description' => 'Restarts the service and change startup mode to automatic.',
                            'request' => 'POST',
                        ),
                    );
        }else if(false === $this->allow_user_ctl()){
            $methods = array(
                        'status' => array(
                            'name' => 'Get Service Status',
                            'description' => 'Returns service status and statistics.',
                            'request' => 'GET',
                        ),
                    );
        } 
        // Anything to expose ?
        if($methods){
            $this->register_aggregate_object( 'service',
                array(
                    'name' => 'Service',
                    'description' => 'Controls the service running state and startup mode.',
                    'dynamic' => true,
                    'singleton' => true,
                    'methods' => $methods,
                )
            );
        }

        return parent::configure();
    }
    private function _status_text($status)
    {
        switch($status) {
        case Safe_service_class::STATUS_ERROR: return 'ERROR';
        case Safe_service_class::STATUS_UNRECOGNIZED: return 'UNRECOGNIZED';
        case Safe_service_class::STATUS_RUNNING: return 'RUNNING';
        case Safe_service_class::STATUS_STOPPED: return 'STOPPED';
        case Safe_service_class::STATUS_DEAD: return 'DEAD';
        default: return $status;
        }
    }
    public function api_status_service($obj_name=null, $params=null, &$output=null)
    {
        $stats = array();
        $rc = $this->status($stats);
        $stats['status'] = $rc;
        $stats['status_text'] = $this->_status_text($rc);

        return $stats;
    }
    public function api_start_service($obj_name=null, $params=null, &$output=null)
    {
        // success is 0
        return (!$this->start($output)) ?true:false;
    }
    public function api_stop_service($obj_name=null, $params=null, &$output=null)
    {
        // success is 0
        return (!$this->stop($output)) ?true:false;
    }
    public function api_restart_service($obj_name=null, $params=null, &$output=null)
    {
        // success is 0
        return (!$this->restart($output)) ?true:false;
    }
    // service control
    public function start(&$result = null)
    {
        return $this->node()->service_ctl($this->name() , "start", $result, $this->_process_name);
    }
    public function stop(&$result = null)
    {
        return $this->node()->service_ctl($this->name() , "stop", $result, $this->_process_name);
    }
    public function status(&$stats = null)
    {
        return $this->node()->service_ctl($this->name() , "status", $stats, $this->_process_name);
    }
    public function restart($force = false, &$result = null)
    {
        return $this->node()->service_ctl($this->name() , "restart", $result, $this->_process_name);
    }
    public function reload($force = false, &$result = null)
    {
        return $this->node()->service_ctl($this->name() , "reload", $result, $this->_process_name);
    }
    public function startup()
    {
        $auto = $this->node()->is_service_auto($this->name());
        return (true == $auto) ? Safe_service_class::STARTUP_AUTOMATIC : Safe_service_class::STARTUP_MANUAL;
    }
    public function set_startup($mode)
    {
        return $this->node()->set_service_startup($this->name() , ($mode == Safe_service_class::STARTUP_AUTOMATIC));
    }
    public function stats()
    {
        $result = array();
        // Use process name
        $this->node()->service_ctl($this->name() , "stats", $result, $this->_process_name);
        return $result;
    }
    public function execute($cmd, &$result = null)
    {
        $result = array();
        // Use process name
        return $this->node()->service_ctl($this->name() , $cmd, $result, $this->_process_name);
    }
    public function kill($signal)
    {
        return $this->node()->kill($this->name() , $signal, $this->_process_name);
    }
    public function allow_user_ctl()
    {
        return true;
    }
    public function can_start()
    {
        return true;
    }
    /**
     * Resets the Service
     */
    public function reset(&$retCode)
    {
        safe_sudo_exec('/usr/local/sng/scripts/sng-reset-service', '', $this->name() , $retCode);
        if ($retCode == 0) return true;
        else return false;
    }
    /**
     * Function which returns whether the function is enabled or not
     * @return boolean
     */
    public function is_enabled($mod_name = "")
    {
        return false;
    }
    /**
     * @brief Check if archive restore can be done
     *           
     * @param[in out] $reason
     *           
     * @return true/false
     */
    public function can_restore(&$reason)
    {
        // If we're a service, and we're running no way we can restore.
        if (Safe_service_class::STATUS_RUNNING == $this->status()) {
            $reason = $this->description() . ' is Running';
            return false;
        }
        return parent::can_restore($reason);
    }

    /**
     * @brief 
     *
     * @param[in out] $reason
     *
     * @return 
     */
    public function pre_backup(&$reason)
    {
        // Check if product script exists
        $base = $this->node()->configuration_manager()->directory('base');
        $script = $base.'/scripts/'.$this->name().'.backup.pre';
        if(file_exists($script)) {
            error_log('pre_backup - Invoking ' . $script);
            $this->node()->execute($script, $retCode);
        }

        return parent::pre_backup($reason);
    }
    /**
     * @brief 
     *
     * @param[in out] $reason
     *
     * @return 
     */
    public function post_backup(&$reason)
    {
        // Check if product script exists
        $base = $this->node()->configuration_manager()->directory('base');
        $script = $base.'/scripts/'.$this->name().'.backup.post';
        if(file_exists($script)) {
            error_log('post_backup - Invoking ' . $script);
            $this->node()->execute($script, $retCode);
        }

        return parent::post_backup($reason);
    }
    /**
     * @brief 
     *
     * @param[in out] $reason
     *
     * @return 
     */
    public function pre_restore(&$reason)
    {
        // Check if product script exists
        $base = $this->node()->configuration_manager()->directory('base');
        $script = $base.'/scripts/'.$this->name().'.restore.pre';
        if(file_exists($script)) {
            error_log('pre_restore - Invoking ' . $script);
            $this->node()->execute($script, $retCode);
        }

        return parent::pre_restore($reason);
    }
    /**
     * @brief 
     *
     * @param[in out] $reason
     *
     * @return 
     */
    public function post_restore(&$reason)
    {
        // Check if product script exists
        $base = $this->node()->configuration_manager()->directory('base');
        $script = $base.'/scripts/'.$this->name().'.restore.post';
        if(file_exists($script)) {
            error_log('post_restore - Invoking ' . $script);
            $this->node()->execute($script, $retCode);
        }

        return parent::post_restore($reason);
    }
}
/* End of file safe_service_class.php */
