<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/*
 * OS class
*/
require_once ('application/helpers/safe_helper.php');
class Safe_os_wrapper
{
    public function execute($cmd, &$result = null, $escape = true, $superuser = false, &$return_var=null)
    {
        // PHP handle the os specific exec stuff
        // don't need to delegate to os specific class
        $return_var = 0;
        if ($superuser) $result = safe_sudo_exec($cmd, '', '', $return_var, $escape);
        else $result = safe_exec($cmd, '', '', $return_var, $escape);
        if (0 !== $return_var) error_log('Exec <' . $cmd . '> failed=' . $return_var . ' output=' . print_r($result, true));
        return ($return_var === 0);
    }
    public function service_ctl($service_name, $action, &$result = null, $process_name = null)
    {
        return false;
    }
    public function mkdir($pathname, $chown_recursive=true)
    {
        if (!file_exists($pathname)) Safe_sudo_exec('/bin/mkdir -p ' . $pathname);
        if($chown_recursive == true){
            Safe_sudo_exec('/bin/chown -R webconfig ' . $pathname);
        }else{
            Safe_sudo_exec('/bin/chown webconfig ' . $pathname);
        }
        return file_exists($pathname);
    }
    public function rmdir($pathname)
    {
        if (file_exists($pathname)) Safe_sudo_exec('/bin/rm -rf ' . $pathname);
        return (!file_exists($pathname));
    }
    public function delete_file($file_name)
    {
        if (file_exists($file_name)) Safe_sudo_exec('/bin/rm -fr ' . $file_name);
        return (!file_exists($file_name));
    }
    public function move_file($src_file, $dst_file)
    {
        if (file_exists($src_file)) Safe_sudo_exec('/bin/mv -f ' . $src_file . ' ' . $dst_file);
        return (file_exists($dst_file));
    }
    public function search_files($pattern)
    {
        $files = glob($pattern);
        if (false == $files) return array();
        return $files;
    }
    public function check_file_exists($file_name)
    {
        return (file_exists($file_name));
    }
    public function stat_file($file, &$stats)
    {
        clearstatcache(true, $file);
        $stats = stat($file);
        return ($stats);
    }
    /**
     * Creates a symbolic link. Must use absolute paths
     * @param string  $original
     *                           			Original file location
     * @param string  $target  
     *                           			Location where symbolic link
     * @return boolean
     */
    public function symlink_file($original, $target)
    {
        if (file_exists($original)) {
            // Ensure destination directory exists
            $this->mkdir(dirname($target));
            Safe_sudo_exec('/bin/chown webconfig ' . $original);
            Safe_sudo_exec('/bin/rm -f ' . $target);
            Safe_sudo_exec('/bin/ln -sf ' . $original . ' ' . $target);
            Safe_sudo_exec('/bin/chown webconfig ' . $target);
            return true;
        }
        return false;
    }
    /**
     * Unlinks a symbolic link
     * @param string  $file
     *                       			Absolute path to symobolic link
     * @return boolean
     */
    public function unlink_file($file)
    {
        if (file_exists($file)) Safe_sudo_exec('/bin/rm -f ' . $file);
        return true;
    }
    public function write_file($file_name, $buffer, $mode = 'w')
    {
        // Ensure directory exist
        if ($this->mkdir(dirname($file_name))) {
            if (file_exists($file_name)) Safe_sudo_exec('/bin/chown webconfig ' . $file_name);
            if ($file = fopen($file_name, $mode)) {
                if (is_array($buffer)) {
                    foreach ($buffer as $line) fputs($file, $line . "\n");
                } else {
                    fwrite($file, $buffer);
                }
                fclose($file);
                return true;
            }
        }
        return false;
    }
    /**
     * Returns the output of a file
     *
     * @param $file_name = file to open and read
     * @param $buffer    = variable to store file contents in
     * @param mode       = mode to open file in (r, rw, a)
     * @param $as_array  = true to store as array, false to store as string
     *                      
     * @return true       or false
     */
    public function read_file($file_name, &$buffer, $mode = 'r', $as_array = false)
    {
        // TODO(wadam) - use local read file from php
        if (file_exists($file_name)) {
            if ($file = fopen($file_name, $mode)) {
                $buffer = '';
                if ($as_array) {
                    $buffer = array();
                    while ($line = fgets($file)) $buffer[] = $line;
                } else {
                    while (!feof($file)) {
                        $buffer.= fread($file, filesize($file_name));
                    }
                }
                fclose($file);
                return true;
            } else {
                // Fail to open, probably user right issue use cat
                $buffer = Safe_sudo_exec('/bin/cat ' . $file_name, '', '', $rc);
                return (0 === $rc);
            }
        }
        //error_log('Fail to open file' . $file_name);
        return false;
    }
    /**
     * chmod file
     * @param string  $file_name = file to change
     * @param string  $mod  = new file mode
     * @param string  $include_sub  = includ subdir
     *                       			
     * @return boolean
     */
    public function chmod_file($file_name, $mod)
    {
        if (file_exists($file_name)){
            Safe_sudo_exec('/bin/chmod ' .  $mod . ' ' . $file_name,'', '', $rc);
            return (0 === $rc);
        }
        return false;
    }
    /**
     * chown file
     * @param string  $file_name = file to change
     * @param string  $owner  = new file mode
     * @param string  $include_sub  = includ subdir
     *
     * @return boolean
     */
    public function chown_file($file_name, $owner)
    {
        if (file_exists($file_name)){
            Safe_sudo_exec('/bin/chown ' . $owner . ' ' . $file_name,'', '', $rc);
            return (0 === $rc);
        }
        return false;
    }
    /**
     * SED  file
     * @param string  $file_name = file to change
     * @param string  $data  =is an array of SED commands
     *
     * @return boolean
     */
    public function sed_file($file_name, $data = null)
    {
        if (file_exists($file_name)){
            foreach($data as $argument){
                Safe_sudo_exec('/bin/sed -i \'' . $argument . '\' ' . $file_name, '', '', $rc, false);
            }
            return true;
        }
        return false;
    }
    /**
     * Test if $port is a valid port can LISTEN
     * @param string $ip
     * @param string $port
     * @param string $type = (UDP,TCP,ALL)
     * @param string $program_name
     */
    public function valid_ip_port($ip, $port, $type_str = 'TCP', $program_name = '') {
        $ip     = strtoupper(trim($ip));
        $type_str = strtoupper(str_ireplace( array ('TLS','ALL'), array('TCP','TCPUDP'), $type_str));
        $param = '-lpn';
        if(strpos($type_str,'TCP')!==false){
            $param = $param .'t';
        }
        if(strpos($type_str,'UDP')!==false){
            $param = $param .'u';
        }
        $output = array();
        $cmd = "netstat {$param} | grep ':$port '";
        // Loop X times on port check as it not always reliable
        // See bug#8270
        $port_used_count = 0;
        $loop_cnt = 0;
        $max_loop = 5;
        do{
            // Default is used
            $port_used = true;
            // Check for port usage
            $output = safe_sudo_exec($cmd, '', '', $return_var, false);
            if($output != null ){
                // Go matches, loop around result
                foreach($output as $matched_string){
                    if($ip != 'ALL'){
                        //check if ip match or not
                        if(strpos($matched_string,$ip.':'.$port) === false){
                            $port_used = false;
                        }
                    }
                    if($port_used == true && $program_name != '' && false !== ($tmp_pos=strpos($matched_string,$program_name)) ){
                        $get_program_name = trim(substr($matched_string, $tmp_pos));
                        if($get_program_name == $program_name){
                            $port_used = false;
                        }
                    }
                    if($port_used) {
                        error_log('valid_ip_port('.$ip.','.$port.','.$type_str.','.$program_name.') used by <'.$matched_string.'>');
                        $port_used_count++;
                        break;
                    }
                }
            }else{
                $port_used = false;
            }
        } while($loop_cnt++<$max_loop);

        // Check if port marked as used 'max_loop' times
        if($port_used && $port_used_count<$max_loop){
            error_log('valid_ip_port('.$ip.','.$port.','.$type_str.','.$program_name.') marked as used only '.$port_used_count.' - false positive');
            $port_used = false;
        }

        return !$port_used;
    }
}
class Safe_centos_wrapper extends Safe_os_wrapper
{
    public function service_ctl($service_name, $action, &$result = null, $process_name = null)
    {
        $return_var = 0;
        switch ($action) {
        case 'status':
            safe_sudo_exec('service', $service_name . ' ' . $action, '', $return_var, false);
            if (!isset($result)) break;

        case 'stats':
            if (isset($process_name)) $service_name = $process_name;
            $result['process'] = '';
            $result['cputime'] = '';
            $result['%cpu'] = '';
            $result['%mem'] = '';
            $output = safe_exec('ps --no-headers -eo comm,etime,%cpu,%mem| grep -w ' . $service_name, '', '', $dummy, false);
            if (!$dummy) {
                if (empty($output)) $return_var = - 1;
                else {
                    $output[0] = str_replace('  ', ' ', $output[0]);
                    $stats = explode(' ', trim(str_replace($service_name, ' ', $output[0])));
                    $result['process'] = $service_name;
                    $result['cputime'] = $stats[0];
                    $result['%cpu'] = $stats[1];
                    $result['%mem'] = $stats[2];
                }
            }
            break;

        default:
            $result = safe_sudo_exec('/sbin/service ' . $service_name . ' ' . $action, '', '', $return_var, false);
            break;
        }
        return $return_var;
    }
    public function set_service_startup($service_name, $is_auto)
    {
        $rc = null;
        if ($is_auto) {
            safe_sudo_exec('chkconfig --add ' . $service_name, $rc);
            $output = safe_sudo_exec('chkconfig ' . $service_name . ' on', $rc);
        } else {
            $output = safe_sudo_exec('chkconfig ' . $service_name . ' off', $rc);
        }
        return (0 == $rc);
    }
    public function is_service_auto($service_name)
    {
        $output = array();
        $output = safe_sudo_exec('chkconfig --list ' . $service_name . ' | grep :on', '', '', $rc, false);
        return (empty($output)) ? false : true;
    }
    public function kill($service_name, $signal, $process_name = null)
    {
        $rc = null;
        $result = safe_sudo_exec('/usr/bin/pkill', '-' . $signal . ' ' . $service_name, '', $rc, false);
        return (0 == $rc);
    }
}
class Safe_debian_wrapper extends Safe_os_wrapper
{
    public function service_ctl($service_name, $action, &$result = null)
    {
        $return_var = 0;
        $result = safe_exec('/etc/init.d/' . $service_name, $action, '', $return_var);
        return $return_var;
    }
}
/* End of file safe_os_class.php */
