<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/*
 * Hardware class
*/
require_once ('application/helpers/safe_helper.php');
safe_require_class('safe_node_class');
safe_require_class('safe_configuration_manager_class');
safe_require_class('safe_object_class');
class Safe_hardware_adapter_class extends Safe_serializable_object_class
{
    /*
     * Adapter type
    */
    const ETHERNET_ADAPTER = 'ETHERNET';
    const TRANSCODING_ADAPTER = 'TRANSCODING';
    private $_ifname;
    private $_type;
    private $_node;
    public function __construct($parent, $ifname, $type, $sync_type = Safe_serializable_object_class::SYNC_MEM)
    {
        $this->_ifname = $ifname;
        $this->_type = $type;
        $this->_node = $parent->node();
        parent::__construct($parent->object_name() . "/" . $type, $ifname, $sync_type);
    }
    public function configure()
    {
        return TRUE;
    }
    public function type()
    {
        return $this->_type;
    }
    public function node()
    {
        return $this->_node;
    }
    // Serializable interface implementation
    protected function _get_serialized_data()
    {
        $data = array();
        $data['type'] = $this->_type;
        $data['ifname'] = $this->_ifname;
        return $data;
    }
    // Set the php array of retrieved data
    protected function _set_unserialized_data($data)
    {
        $this->_type = $data['type'];
        $this->_ifname = $data['ifname'];
    }
    public function generate_config(&$config)
    {
        // Default is no config
        return TRUE;
    }
}
class Safe_ethernet_adapter_class extends Safe_hardware_adapter_class
{
    private $_mac;
    private $_ip_address;
    private $_mask;
    private $_gateways = array();
    public function __construct($hardware, $ifname, $mac, $ip, $mask, $type = null, $sync_type = Safe_serializable_object_class::SYNC_MEM)
    {
        if (!isset($type)) $type = Safe_hardware_adapter_class::ETHERNET_ADAPTER;
        $this->_mac = $mac;
        $this->_ip_address = $ip;
        $this->_mask = $mask;
        parent::__construct($hardware, $ifname, $type, $sync_type);
    }
    public function mac()
    {
        return $this->_mac;
    }
    public function ip_address()
    {
        return $this->_ip_address;
    }
    public function mask()
    {
        return $this->_mask;
    }
    public function gateways()
    {
        return $this->_gateways();
    }
    public function gateway()
    {
        if (isset($this->_gateways[0])) return $this->_gateways[0];
        else return '';
    }
    // Serializable interface implementation
    // Cumulative array with parent
    protected function _get_serialized_data()
    {
        $data = parent::_get_serialized_data();
        $data['mac'] = $this->_mac;
        $data['ip_address'] = $this->_ip_address;
        $data['mask'] = $this->_mask;
        return $data;
    }
    // Set the php array of retrieved data
    protected function _set_unserialized_data($data)
    {
        $this->_mac = $data['mac'];
        $this->_ip_address = $data['ip_address'];
        $this->_mask = $data['mask'];
        parent::_set_unserialized_data($data);
    }
}
class Safe_hardware_adapter_detector_class
{
    private $_detector_type;
    public function __construct($type)
    {
        $this->_type = $type;
    }
    public function type()
    {
        return $this->_type;
    }
    public function detect($hardware_classe)
    {
        return array();
    }
}
class Safe_hardware_class extends Safe_module_class
{
    private $_node = null;
    protected $_adapters = array();
    private $_detectors = array();
    public function __construct($node)
    {
        parent::__construct($node, 'hardware');
        $this->_node = $node;
    }
    public function configure()
    {
        // Set the module description
        $this->set_description("Hardware");
        // Register objects
        $this->register_aggregate_object('adapter',
            array(
                'name' => 'Adapter',
                'dynamic' => false,
                'controller_url' => '/admin/network.php',
                'methods' => array(
                    'retrieve' => array(
                        'name' => 'Retrieve',
                        'description' => 'Retrieve Adapter',
                        'request' => 'GET',
                    ),
                ),
            )
        );

        return parent::configure();
    }
    public function api_retrieve_adapter($obj_name=null)
    {
        $adapters = $this->adapters();
        if($obj_name){
            return $adapters[$obj_name];
        } else {
            return $adapters;
        }
    }
    //Type can be null for all or ethernet for management interfaces
    public function adapters($type = null)
    {
        $adapters = array();
        if (isset($type)) {
            if (isset($this->_adapters[$type])) $adapters = $this->_adapters[$type];
            else return array();
        } else {
            //walk through adapters array and strip out the type
            foreach ($this->_adapters[Safe_hardware_adapter_class::ETHERNET_ADAPTER] as $adapter) {
                $adapters[$adapter->name() ] = $adapter;
                //$adapters[$adapter->name()]['type'] = $adapter->type();
                
            }
            foreach ($this->_adapters[Safe_hardware_adapter_class::TRANSCODING_ADAPTER] as $adapter) {
                $adapters[$adapter->name() ] = $adapter;
                //$adapters[$adapter->name()]['type'] = $adapter->type();
                //array_push ($adapters,$adapter);
                
            }
        }
        return $adapters;
    }
    public function register_detector($detector)
    {
        // For now assume only one detector per type
        $this->_detectors[$detector->type() ] = $detector;
    }
    public function detect_adapters($type = null, $user_arguments = null)
    {
        if (!isset($type)) {
            // Invoke all detectors
            $this->detect_adapters(Safe_hardware_adapter_class::ETHERNET_ADAPTER, $user_arguments);
            $this->detect_adapters(Safe_hardware_adapter_class::TRANSCODING_ADAPTER, $user_arguments);
            return TRUE;
        } else {
            // Drop only specified adapters type
            if (isset($this->_adapters[$type])) {
                foreach ($this->_adapters[$type] as $adapter) {
                    $adapter->dispose();
                }
                // Drop adapters array
                unset($this->_adapters[$type]);
            }
            // Create type container
            $this->_adapters[$type] = array();
            if (isset($this->_detectors[$type])) {
                // push detected adapters
                $detected_adapters = $this->_detectors[$type]->detect($this, $user_arguments);
                foreach ($detected_adapters as $key => $adapter) $this->_adapters[$type][$key] = $adapter;
                // TODO(wadam) - Delete disposed objects
                return TRUE;
            } else return FALSE;
        }
    }
    public function node()
    {
        return $this->_node;
    }
    public function generate_config(&$configs)
    {
        // Iterate on adapters
        foreach ($this->_adapters as $adapter_type) {
            foreach ($adapter_type as $adapter) {
                if (!$adapter->generate_config($config)) return FALSE;
            }
        }
        return TRUE;
    }
    /**
     * @brief Pre backup hook
     *           
     * @param[in out] $reason
     *           
     * @return TRUE/FALSE
     */
    public function pre_backup(&$reason)
    {
        return TRUE;
    }
    /**
     * @brief Post backup hook
     *           
     * @param[in out] $reason
     *           
     * @return TRUE/FALSE
     */
    public function post_backup(&$reason)
    {
        return TRUE;
    }
    /**
     * @brief Check if archive restore can be done
     *           
     * @param[in out] $reason
     *           
     * @return TRUE/FALSE
     */
    public function can_restore(&$reason)
    {
        return TRUE;
    }
    /**
     * @brief Pre restore hook
     *           
     * @param[in out] $reason
     *           
     * @return TRUE/FALSE
     */
    public function pre_restore(&$reason)
    {
        return TRUE;
    }
    /**
     * @brief Post restore hook
     *           
     * @param[in out] $reason
     *           
     * @return TRUE/FALSE
     */
    public function post_restore(&$reason)
    {
        // Restart network
        $this->node()->os()->service_ctl('network', 'restart');
        // Reconfigure
        $this->configure();
        return TRUE;
    }
}
/* End of file safe_hardware_class.php */
