<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/*
 * Configuration class
*/
require_once ('application/helpers/safe_helper.php');
safe_require_class('safe_object_class');
safe_require_class('safe_db_class');
class Safe_configuration_class
{
    private $_file_name;
    private $_data;
    // Action enumeration
    const CFG_CREATE = 'create';
    const CFG_UPDATE = 'update';
    const CFG_DELETE = 'delete';
    const CFG_EMPTY = 'empty';
    const CFG_LINK = 'link';
    const CFG_UNLINK = 'unlink';
    const CFG_NONE = 'none';
    private $_action;
    // Configuration type enumeration
    const CFG_FILE = 'file';
    const CFG_DIR = 'dir';
    const CFG_SQL = 'sql';
    const CFG_USER = 'user';
    const CFG_SED = 'sed';
    const CFG_CHOWN = 'chown';
    const CFG_CHMOD = 'chmod';
    
    private $_type;
    public function __construct($file_name, $data, $action = Safe_configuration_class::CFG_UPDATE, $type = Safe_configuration_class::CFG_FILE)
    {
        $this->_file_name = $file_name;
        $this->_data = $data;
        $this->_action = $action;
        $this->_type = $type;
    }
    public function file_name()
    {
        return $this->_file_name;
    }
    public function data()
    {
        return $this->_data;
    }
    public function action()
    {
        return $this->_action;
    }
    public function type()
    {
        return $this->_type;
    }
}
class Safe_configuration_user_class extends Safe_configuration_class
{
    public function __construct($file_name, $action_name = Safe_configuration_class::CFG_NONE, $data = array())
    {
        parent::__construct($file_name, $data, $action_name, Safe_configuration_class::CFG_USER);
    }
    public function run($node)
    {
        return false;
    }
}
class Safe_configuration_manager_class extends Safe_object_class
{
    private $_node = null;
    private $_directories;
    private $_configs = array();
    private $_services = array();
    private $_license = array();
    private $_about = array();
    private $_update = array();
    private $_url = array();
    private $_errors = array();
    private $_progress = array();
    private $_archive_manager = null;
    private $_forget_error = false;
    public function __construct($parent, $prod_def)
    {
        parent::__construct($parent->object_name() , "configuration_manager");
        if (!is_subclass_of($parent, 'Safe_node')) throw new Exception('Parent object MUST be a node objet.');
        $this->_node = $parent;
        // Latch known existing stuffs
        if (isset($prod_def['directories'])) $this->_directories = $prod_def['directories'];
        // Check services
        if (isset($prod_def['services'])) {
            $services = $prod_def['services'];
            // Section exists check if some services defined
            if (isset($services['service'])) {
                // Check if
                if (!is_indexed_array($services['service'])) {
                    $tmp = $services['service'];
                    unset($services['service']);
                    $services['service'] = array(
                        '0' => $tmp
                    );
                }
            }
            $this->_services = $services['service'];
        }
        // Make sure configuration,log directories exist and webconfig
        // can play with it
        if (isset($this->_directories['configuration'])) $this->_node->mkdir($this->_directories['configuration']);
        if (isset($this->_directories['log']))
            $this->_node->mkdir($this->_directories['log'] , false);
        if (isset($this->_directories['core-dump']))
            $this->_node->mkdir($this->_directories['core-dump'] , false);
        // License
        $this->_license['file'] = $prod_def['license'];
        $this->_license['pubkey'] = $prod_def['pubkey'];
        // About
        $this->_about['version'] = $prod_def['about'];
        // Update
        if (isset($prod_def['update'])) $this->_update = $prod_def['update'];
        // URL
        if (isset($prod_def['url'])) $this->_url = $prod_def['url'];
    }
    public function forget_error($forget)
    {
        $this->_forget_error = $forget;
    }
    public function add_config($config)
    {
        $this->_configs[] = $config;
    }
    public function add_error($action, $target, $fix_url = null, $fix_url_label = null, $fix_url_value = null)
    {
        if (!$this->_forget_error) {
            $this->_errors[] = array(
                'action' => $action,
                'target' => $target,
                'fix_url' => $fix_url,
                'fix_url_label' => $fix_url_label,
                'fix_url_value' => $fix_url_value
            );
            if (isset($fix_url) && strlen($fix_url)) $url = safe_form_with_submit_button('', $fix_url, (isset($fix_url_label)) ? $fix_url_label : 'Fix it !', (isset($fix_url_value)) ? $fix_url_value : 'fix_it');
            else $url = 'ERROR';
            $this->_progress[] = array(
                $action,
                $target,
                $url
            );
        }
    }
    public function reset_errors()
    {
        $this->_errors = array();
    }
    public function errors()
    {
        if (isset($this->_errors)) return $this->_errors;
        else return array();
    }
    public function reset_progress()
    {
        $this->_progress = array();
    }
    public function progress()
    {
        if (isset($this->_progress)) return $this->_progress;
        else return array();
    }
    public function configs()
    {
        return $this->_configs;
    }
    public function directories()
    {
        return $this->_directories;
    }
    public function directory($type)
    {
        if (isset($this->_directories[$type])) return $this->_directories[$type];
        else throw new Exception('Undefined directory (' . $type . ')');
    }
    public function about()
    {
        return $this->_about;
    }
    public function services()
    {
        return $this->_services;
    }
    public function license()
    {
        return $this->_license;
    }
    public function url()
    {
        return $this->_url;
    }
    public function write_config($node)
    {
        // Write all configuration files
        foreach ($this->_configs as $config) {
            // Assume action will fail
            $success = false;
            $cfg_dir = $this->directory('configuration');
            if (is_array($config->file_name())) {
                $file_name = $config->file_name();
                $display_action = $file_name['target'];
                $full_path = $file_name['target'];
            } else {
                $fname = $config->file_name();
                if ($fname[0] == '/') {
                    $cfg_dir = dirname($fname);
                    $fname = basename($fname);
                }
                $display_action = $config->file_name();
                $full_path = $cfg_dir . '/' . $fname;
            }
            // What do we need to do ?
            switch ($config->type()) {
                // USER action
                
            case Safe_configuration_class::CFG_USER:
                try {
                    $success = $config->run($node);
                }
                catch(Exception $e) {
                }
                break;
                // FILE
                
            case Safe_configuration_class::CFG_FILE:
                switch ($config->action()) {
                case Safe_configuration_class::CFG_UPDATE:
                    $success = $node->write_file($full_path, $config->data());
                    break;

                case Safe_configuration_class::CFG_DELETE:
                    $success = $node->delete_file($full_path);
                    break;

                case Safe_configuration_class::CFG_LINK:
                    $success = $node->symlink_file($file_name['original'], $file_name['target']);
                    break;

                case Safe_configuration_class::CFG_UNLINK:
                    $success = $node->unlink_file($file_name['target']);
                    break;
                }
                break;
                // DIRECTORY
                
            case Safe_configuration_class::CFG_DIR:
                switch ($config->action()) {
                case Safe_configuration_class::CFG_DELETE:
                    $success = $node->rmdir($full_path);
                    break;

                case Safe_configuration_class::CFG_CREATE:
                    $success = $node->mkdir($full_path);
                    break;

                case Safe_configuration_class::CFG_LINK:
                    $success = $node->symlink_file($file_name['original'], $file_name['target']);
                    break;

                case Safe_configuration_class::CFG_UNLINK:
                    $success = $node->unlink_file($file_name['target']);
                    break;
                }
                break;
                // SED
                
            case Safe_configuration_class::CFG_SED:
                switch ($config->action()) {
                    case Safe_configuration_class::CFG_UPDATE:
                    $success = $node->sed_file($full_path, $config->data());
                    break;
                }
                break;
                // chmod
                
            case Safe_configuration_class::CFG_CHMOD:
                    switch ($config->action()) {
                        case Safe_configuration_class::CFG_UPDATE:
                            $success = $node->chmod_file($full_path, $config->data());
                            break;
                    }
                    break;
                    // chown
                    
            case Safe_configuration_class::CFG_CHOWN:
                        switch ($config->action()) {
                            case Safe_configuration_class::CFG_UPDATE:
                                $success = $node->chown_file($full_path, $config->data());
                                break;
                        }
                        break;
                    
                // SQL db
                
            case Safe_configuration_class::CFG_SQL:
                // Check that arguments are valid
                // $config->file_name() MUST contain table name
                // $config->data() MUST be an array containing the following entries
                //   ['db_class'] = The Safe_database_class object to access SQL DB
                //   Depending on action:
                //     For CREATE
                //       ['data'] = an array containing data to insert in a key/value pair format
                //     For UPDATE and DELETE
                //       ['primary_key'] = an array containing primary keys field names  for where clause
                //                         !! Only field names are required, field value
                //                         is extracted from ['data'] array.
                //       ['data'] = an array containing data to update in a key/value pair format
                $data = $config->data();
                if (!isset($data['db_class']) || !is_subclass_of($data['db_class'], 'Safe_database_class')) {
                    $display_action = 'db_class is not a Safe_database_object.';
                } elseif ((!isset($data['data']) || !is_array($data['data'])) && $config->action() != Safe_configuration_class::CFG_EMPTY) {
                    $display_action = 'No valid data supplied.';
                } elseif (!$data['db_class']->connect()) {
                    $display_action = 'Fail to connect to data base';
                } else {
                    $display_action = $fname;
                    // All good :)
                    switch ($config->action()) {
                    case Safe_configuration_class::CFG_CREATE:
                        // Insert a record
                        $success = $data['db_class']->insert($fname, $data['data']);
                        break;

                    case Safe_configuration_class::CFG_UPDATE:
                        if (!isset($data['primary_key']) || !is_array($data['primary_key'])) {
                            $display_action = 'No primary keys supplied.';
                        } else {
                            // Update a record
                            $success = $data['db_class']->update($fname, $data['primary_key'], $data['data']);
                        }
                        break;

                    case Safe_configuration_class::CFG_DELETE:
                        if (!isset($data['primary_key']) || !is_array($data['primary_key'])) {
                            $display_action = 'No primary keys supplied.';
                        } else {
                            // Delete a record
                            $success = $data['db_class']->delete($fname, $data['primary_key'], $data['data']);
                        }
                        break;

                    case Safe_configuration_class::CFG_EMPTY:
                        // Delete all record
                        $success = $data['db_class']->empty_table($fname);
                        break;
                    }
                    if (true != $success) $display_action = $fname . " - " . $data['db_class']->_error_message();
                    // Disconnect from database
                    $data['db_class']->disconnect();
                }
                break;
            }
            // Report error
            $this->_progress[] = array(
                $config->type() . ' ' . $config->action() ,
                $display_action,
                (true == $success) ? 'OK' : 'ERROR'
            );
            error_log('write_config - ' .
                $config->type() . ' ' . $config->action() . ' - ' .
                $display_action . ' - ' . ((true == $success) ? 'OK' : 'ERROR'));
            if (true != $success) return false;
        }
        // Update configuration status
        $this->_update_status();
        return true;
    }
    private function _get_status()
    {
        $ser = safe_object_serializer_class::get_serializer();
        $ser->retrieve_object('/tmp', 'configuration_status', $data);
        return $data;
    }
    private function _update_status()
    {
        // Update configuration status
        $ser = safe_object_serializer_class::get_serializer();
        $ser->retrieve_object('/tmp', 'configuration_status', $data);
        $data['generate']['count'] += 1;
        $data['generate']['date'] = date('Y-m-d-H-i-s');
        $ser->store_object('/tmp', 'configuration_status', 'none', $data, 'tmp');
    }

    public function generate_count()
    {
        $data = $this->_get_status();
        return $data['generate']['count'];
    }

    public function node()
    {
        return $this->_node;
    }
    public function &archive_manager()
    {
        // Create on demand
        if (!isset($this->_archive_manager)) {
            $this->_archive_manager = new Safe_archive_manager_class($this);
            $this->_archive_manager->configure();
        }
        return $this->_archive_manager;
    }
    public function checklist(&$list)
    {
        $status = $this->_get_status();
        if(!$status['generate']['count']){
            $list[] = array(
                'module' =>'application',
                'obj_type' =>'configuration',
                'description' => 'Not generated',
            );

        }
    }
}
class Safe_archive_manager_class extends Safe_object_class
{
    private $_config_manager = null;
    private $_node = null;
    private $_arch_dir = null;
    public function __construct($parent)
    {
        parent::__construct($parent->object_name() , "archive_manager");
        $this->_config_manager = $parent;
        $this->_node = $parent->node();
        // Ensure archives directories are created
        try {
            $this->_arch_dir = $this->_config_manager->directory('archive');
        }
        catch(Exception $e) {
            // use base dir and cat archive
            $this->_arch_dir = $this->_config_manager->directory('base');
            $this->_arch_dir.= '/archive';
        }
        // Create directories
        $this->_node->mkdir($this->_arch_dir);
        $this->_node->mkdir($this->_arch_dir . '/tmp');
    }
    public function restore_archive($archive_name)
    {
        error_log('restore_archive - '.$archive_name);
        $os = $this->_node->os();
        $cmd = '/bin/tar -xpsvzf ';
        $cmd.= $this->_arch_dir . '/' . $archive_name . ' -C /';
        $output = array();
        $rc = $os->execute($cmd, $output, false, true);
        return $rc;
    }
    public function create_archive()
    {
        $backup_conf = array();
        $os = $this->_node->os();
        $rc = $os->read_file('/etc/backup.conf', $backup_conf, true);
        // Clean and adjust file list
        $files_list = array();
        foreach ($backup_conf as $pattern) {
            $pattern = trim($pattern);
            if ('#' != $pattern[0]) {
                $files = $os->search_files($pattern);
                foreach ($files as $file) {
                    $files_list[] = $file;
                }
            }
        }
        // Ready to ZIIIIP....
        $name = php_uname('n') . '-backup-' . date('Y-m-d-H-i-s') . '.tgz';
        error_log('create_archive - '.$name);
        // Create tar command line
        $cmd = '/bin/tar -cpsvzf ';
        $cmd.= $this->_arch_dir . '/tmp/' . $name . ' ';
        $cmd.= implode(' ', $files_list);
        $output = array();
        $rc = $os->execute($cmd, $output, false, true);
        if ($rc) {
            // Succeed move archive to vault
            if ($os->move_file($this->_arch_dir . '/tmp/' . $name, $this->_arch_dir . '/' . $name)) return $name;
        }
        return false;
    }
    public function directory($pattern = false)
    {
        if ($pattern) return $this->_arch_dir . '/*.tgz';
        else return $this->_arch_dir;
    }
}
/* End of file safe_config_manager_class.php */
