<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 *
 * @author Michel Buczynski <mbucyznski@sangoma.com>
 *         
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
define('SAFE_CMD_SUDO', "/usr/bin/sudo");
define('SAFE_CMD_RM', '/bin/rm');
define('SAFE_CMD_CAT', '/bin/cat');
define('SAFE_CMD_MOVE', '/bin/mv');
define('SAFE_CMD_COPY', '/bin/cp');
define('SAFE_CMD_TOUCH', '/bin/touch');
define('SAFE_CMD_CHOWN', '/bin/chown');
define('SAFE_CMD_CHMOD', '/bin/chmod');
define('SAFE_CMD_LS', '/bin/ls');
define('SAFE_CMD_MD5', '/usr/bin/md5sum');
define('SAFE_CMD_FILE', '/usr/bin/file');
define('SAFE_CMD_HEAD', '/usr/bin/head');
define('SAFE_CMD_REPLACE', '/usr/sbin/app-rename');
define('SAFE_CMD_STDERR_REDIRECT', ' 2>&1 ');
define('SAFE_FILE_LOCK', '/var/webconfig/tmp/safe.lock');
/**
 * Authenticate, if not logged it's redirect at a login screen;
 *
 * @return boolean (Should never return false, page are recreated or
 *                 redirected.)
 */
function safe_authenticate()
{
    if (isset($GLOBALS['SAFE_WC_HELPER'])) {
        return SAFE_WC_AUTHENTICATE();
    } else {
        return true;
    }
}
/**
 * Increments an IP Address. Returns true if it can increment successfully. Returns false if IP address beyond Class A/B/C Range.
 * @param string  $ip_address
 * @return boolean
 */
function increment_ip(&$ip_address)
{
    // Increment base IP
    $ip = explode('.', $ip_address);
    if (4 == count($ip)) {
        $ip[3] = $ip[3] + 1;
        // Checks the forth octet for not greater than 255
        if ($ip[3] >= 255) {
            $ip[3] = 1;
            $ip[2] = $ip[2] + 1;
        }
        //Checks the third octed for greater than 255
        if ($ip[2] > 255) {
            $ip[2] = 1;
            $ip[1] = $ip[1] + 1;
        }
        //Checks the second octet for greater than 255
        if ($ip[1] > 255) {
            $ip[1] = 1;
            $ip[0] = $ip[0] + 1;
        }
        //Checks the first octet for a valid first octet (1-223)
        if ($ip[0] > 223) {
            //Not classful range return error
            //Not sure how to handle the error at this point
            return false;
        }
        $ip_address = implode('.', $ip);
    }
    return true;
}
function safe_redirect($url)
{
    echo '
    <script type="text/javascript">
window.location = "' . $url . '";
    </script>';
}
/**
 * Return the default web header
 *
 * @param $title      string
 * @param $summary    string
 * @param $large_icon string
 * @param $small_icon string
 * @return string     
 */
function safe_webheader($title = 'SAFe -', $summary = '', $large_icon = '', $small_icon = '')
{
    // TODO: handle title.
    if (isset($GLOBALS['SAFE_WC_HELPER'])) {
        $html = SAFE_WC_HEADER($title);
        $html.= <<<EOD
<script type="text/javascript">
    $('#clearos_left_menu').accordion({
      autoHeight: false, active: 0 });
    </script>
EOD;
        $html.= SAFE_WC_DIALOGINTRO($title, $summary, $large_icon, $small_icon);
        return $html;
    } else {
        return <<<EOD
    <html>
    <head>
    </head>
    <body>
EOD;
        
    }
}
/**
 * Create a hyperlink
 */
function safe_hyperlink($url, $value, $download = false)
{
    if (isset($GLOBALS['SAFE_WC_HELPER'])) {
        if ($download == true) return "<a style='text-decoration:underline;' href=\"" . $url . "\" target=\"_blank\">" . $value . "</a>";
        else return "<a style='text-decoration:underline;' href=\"" . $url . "\">" . $value . "</a>";
    } else {
        if ($download == true) echo "<a style='text-decoration:underline;' href=\"" . $url . "\" target=\"_blank\">" . $value . "</a>";
        else echo "<a style='text-decoration:underline;' href=\"" . $url . "\">" . $value . "</a>";
    }
}
/**
 * Return the default web footer.
 *
 * @return string
 */
function safe_webfooter()
{
    if (isset($GLOBALS['SAFE_WC_HELPER'])) {
        return SAFE_WC_FOOTER();
    } else {
        return <<<EOD
    </body>
    </html>

EOD;
        
    }
}
/**
 * Return a opening table with a title
 *
 * here style defined by clearos 5.x webconfig
 *         .mytableheader
 *         .mytablesubheader
 *         .rowenabled
 *         .rowhoverhighlight
 *         .rowenabledalt
 *         .rowdisabled
 *         .rowdisabledalt
 *         .mytablealt
 *         .mytablelegend
 *         .mytablecheckboxes
 *
 * @param string $title      
 * @param string $title      
 * @param string $width      
 * @param string $id         
 * @param string $extra_class
 * @param string $extra_style
 * @param string $padding    
 * @return string
 *                
 */
function safe_webtabletitleopen($title = '', $width = '100%', $id = '', $extra_class = '', $extra_style = '', $padding = '3px')
{
    if (isset($GLOBALS['SAFE_WC_HELPER'])) {
        return SAFE_WC_TABLEOPEN($title, $width, $id = '', $extra_class, $extra_style = '', $padding = '3px');
    } else {
        return <<<EOD
    <div width='$width'>$title</div>
    <table width='$width' id='$id'>
EOD;
        
    }
}
/**
 * remove table title and corner style //table_open.inc
 *
 * @param string $html
 * @return string
 *
 */
function safe_webtabletitleopen_json($html)
{
    $html = preg_replace('/(<div[^>]+widget-content-header[^>]+>.+?)+(<\/div>)/i', '', $html);
    $html = preg_replace('/ui-corner-top/', '', $html);//remove corner top
    $html = preg_replace('/ui-corner-bottom/', '', $html);//remove corner bottom
    $html = preg_replace('/ui-state-active/', '', $html);//remove border
    return $html;
}
/**
 * Return closing tag for safe_webtabletitleopen()
 *
 * @return string
 */
function safe_webtableclose()
{
    if (isset($GLOBALS['SAFE_WC_HELPER'])) {
        return SAFE_WC_TABLECLOSE();
    } else {
        return <<<EOD
  </table>
EOD;
        
    }
}
/**
 * Creates a form with a single submit and a message to put before the button.
 * For use when a simple button is required
 *
 * @param $message      string
 *                             The message to display before the submit button
 * @param $action       string
 *                             Page for form to redirect to
 * @param $button_label string
 *                             html value parameter for the submit button
 * @param $button_value string
 *                             html name parameter for the submit button
 *                             
 */
function safe_form_with_submit_button($message, $action, $button_label, $button_value = NULL, $method = 'post', $style = NULL, $hidden_fields = array())
{
    if (isset($button_value)) $button_name = ' name="' . $button_value . '" ';
    else $button_name = '';
    if (isset($style)) $style.= ' style="' . $style . '" ';
    else $style = "";
    $extra_fields = "";
    foreach ($hidden_fields as $k => $v) {
        $extra_fields.= '<input type="hidden" name="' . $k . '" value="' . $v . '"/>';
    }
    return '
    <form action="' . $action . '" method="' . $method . '" enctype="multipart/form-data">' . $message . $extra_fields . '<input ' . $button_name . $style . ' value="' . $button_label . '" type="submit" class="ui-state-default ui-corner-all">
    </form>';
}
function safe_button_click($name, $value, $url, $id = '', $attributes = NULL)
{
    if (!isset($attributes)) {
        $attributes = array(
            'enctype' => 'multipart/form-data',
            'class' => 'ui-state-default ui-corner-all',
        );
    }
    $html = '
    <input name="' . $name . '" value="' . $value . '" type="button" ';
    foreach ($attributes as $attr => $attr_value) {
        $html.= ' ' . $attr . '="' . $attr_value . '"';
    }
    $html.= ' onclick="window.location.href=\'' . $url . '\'" />';
    return $html;
}
/**
 * Return a warning dialog box
 *
 * @param $message array|string
 *                               the message or array of messages
 * @return string; 
 */
function safe_webdialogwarning($message)
{
    if (empty($message)) return '';
    if (is_array($message) && count($message) > 1) {
        $multiple = "";
        foreach ($message as $error) {
            if (!empty($error)) {
                if ($multiple) $multiple.= "<br/>\n";
                $multiple.= "$error\n";
            }
        }
        if (isset($GLOBALS['SAFE_WC_HELPER'])) {
            return SAFE_WC_DIALOGWARNING($multiple);
        } else {
            return <<<EOD
      <table><tr><td>
      $multiple
      </tr></td></table>
EOD;
            
        }
    } else {
        if (is_array($message)) $message = array_pop($message);
        if (isset($GLOBALS['SAFE_WC_HELPER'])) {
            return SAFE_WC_DIALOGWARNING($message);
        } else {
            return <<<EOD
      <table><tr><td>
      $message
      </tr></td></table>
EOD;
            
        }
    }
}
/**
 * Return a info dialog box
 *
 * @param $message array|string
 *                               the message or array of messages
 * @return string; 
 */
function safe_webdialoginfo($message)
{
    if (empty($message)) return '';
    if (is_array($message) && count($message) > 1) {
        $multiple = "";
        foreach ($message as $error) {
            if (!empty($error)) {
                if ($multiple) $multiple.= "<br/>\n";
                $multiple.= "$error\n";
            }
        }
        if (isset($GLOBALS['SAFE_WC_HELPER'])) {
            return SAFE_WC_DIALOGINFO($multiple);
        } else {
            return <<<EOD
      <table><tr><td>
      $multiple
      </tr></td></table>
EOD;
            
        }
    } else {
        if (is_array($message)) $message = $message[0];
        if (isset($GLOBALS['SAFE_WC_HELPER'])) {
            return SAFE_WC_DIALOGINFO($message);
        } else {
            return <<<EOD
  <table><tr><td>
  $message
  </tr></td></table>
EOD;
            
        }
    }
}
/**
 * Return a info dialog box
 *
 * @param $message array|string
 *                               the message or array of messages
 * @return string; 
 */
function safe_webdialog($message, $icon, $class = '')
{
    if (empty($message)) return '';
    if (is_array($message) && count($message) > 1) {
        $multiple = "";
        foreach ($message as $error) {
            if (!empty($error)) {
                if ($multiple) $multiple.= "<br/>\n";
                $multiple.= "$error\n";
            }
        }
        if (isset($GLOBALS['SAFE_WC_HELPER'])) {
            return SAFE_WC_DIALOG($multiple, $icon, $class);
        } else {
            return <<<EOD
      <table><tr><td>
      $multiple
      </tr></td></table>
EOD;
            
        }
    } else {
        if (is_array($message)) $message = $message[0];
        if (isset($GLOBALS['SAFE_WC_HELPER'])) {
            return SAFE_WC_DIALOG($message, $icon, $class);
        } else {
            return <<<EOD
  <table><tr><td>
  $message
  </tr></td></table>
EOD;
            
        }
    }
}
/**
 * Download a file
 *
 * @param $filename string    
 * @param $data     string    
 * @param $accept   string    
 * @param $maxsize  int|string
 * @return boolean  
 */
function safe_download($filename = '', $buffer = NULL, $user_filename = NULL, $mime = NULL)
{
    // TODO: webconfig (the apache server is running under UID 101 so php also
    // $ph = popen("/usr/bin/sudo /bin/cat " . escapeshellarg($filename), "r");
    // if (!$ph)
    // return false;
    // $content = "";
    // while ($chunk = fread($ph, 4096))
    // $content .= $chunk;
    // pclose($ph);
    // or exec("sudo cat ".escapeshellarg($filename),$data); // add \n in each
    // string of the $data array
    // the utilisation of the CodeIgniter output class
    // $this->output->set_header('Content-type: application/json');
    // $this->output->set_output(json_encode($data));
    //
    // Check if file or buffer
    if (!isset($buffer)) {
        if ($filename == '' or !(file_exists($filename)) or !(is_readable($filename))) {
            header('HTTP/1.0 404 Not Found');
            exit();
        }
        // Get file content
        $data = file_get_contents($filename);
    } else {
        $data = $buffer;
    }
    // Check for mime
    if (!isset($mime)) {
        if (!isset($buffer)) {
            $mime = mime_content_type($filename);
        }
    }
    if (!isset($mime)) $mime = 'text/plain';
    // Check exposed file name
    if (!isset($user_filename)) $user_filename = $filename;
    // error_log ( "Safe_download: $filename:$mime " );
    // Generate the server headers
    if (strpos($_SERVER['HTTP_USER_AGENT'], "MSIE") !== FALSE) {
        header('Content-Type: "' . $mime . '"');
        header('Content-Disposition: attachment; filename="' . $user_filename . '"');
        header('Expires: 0');
        header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
        header("Content-Transfer-Encoding: binary");
        header('Pragma: public');
        header("Content-Length: " . strlen($data));
    } else {
        header('Content-Type: "' . $mime . '"');
        header('Content-Disposition: attachment; filename="' . $user_filename . '"');
        header("Content-Transfer-Encoding: binary");
        header('Expires: 0');
        header('Pragma: no-cache');
        header("Content-Length: " . strlen($data));
    }
    exit($data);
}
/**
 * Make a upload (AJAX style).
 * Return nothing.
 *
 * @param $filename    string 
 *                             The target files name and path.
 * @param $data        string 
 *                             data of the uploaded file.
 * @param $make_backup boolean
 *                             If we make backup or not.
 * @param $sudo        boolean
 *                             do it give the root privelege or not
 *                             
 */
function safe_upload_ajax($filename, $data, $make_backup = true, $sudo = true)
{
    // file_put_contents may also be use
    if (safe_write_file($filename, $data, $make_backup, $sudo)) exit();
    else {
        header("HTTP/1.0 403 Forbidden");
        error_log("ERROR! Safe_upload:" . $filename . " is not writable!");
        exit();
    }
}
/**
 * Write a file.
 *
 *
 * @param $filename    string 
 *                              The target files name and path.
 * @param $data        string 
 *                              data of the uploaded file.
 * @param $make_backup boolean
 *                              If we make backup or not.
 * @param $sudo        boolean
 *                              Give the root privilege or not
 * @return boolean      True if the file was written.
 */
function safe_write_file($pathfilename, $data, $make_backup = true, $sudo = true)
{
    // file_put_contents may also be use
    $uniqid = uniqid();
    // writable
    if (is_writable($pathfilename)) {
        if (is_writable($pathfilename) && $make_backup && file_exists($pathfilename)) {
            @copy($pathfilename, $pathfilename . ".bak");
            // error_Log ( "Safe_write_file:" . $pathfilename . "." . $uniqid .
            // " backup file was created!" );
            
        }
        // this is codeigniter file helper
        if (write_file($pathfilename, $data, 'w')) {
            //error_log ( "Safe_write_file:" . $pathfilename . " was written!" );
            return true;
        }
        // not writeable and sudo allowed
        
    } elseif ($sudo) {
        $tmp_path = safe_verify_tmp();
        $tmp_pathfilename = $tmp_path . '/' . pathinfo($pathfilename, PATHINFO_FILENAME) . '.' . uniqid();
        $done = (write_file($tmp_pathfilename, $data, 'w') && safe_sudo_copy($tmp_pathfilename, $pathfilename));
        @unlink($tmp_pathfilename);
        if ($done) {
            //error_log ( "Safe_write_file:" . $pathfilename . " was written!" );
            return true;
        }
    }
    //error_log ( "ERROR! Safe_write_file:" . $pathfilename . " was not written!" );
    return false;
}
/**
 * Make a copy of file in root privilege.
 * Normally to copy a temp file in root protected folder.
 *
 * @param $src_pathfilename string 
 *                                   Ther source path and filename
 * @param $dst_pathfilename string 
 *                                   The destination
 * @param $make_backup      boolean
 *                                   To make or not a destination backup
 * @return boolean           True if the file was copied
 *                           
 */
function safe_sudo_copy($src_pathfilename, $dst_pathfilename, $make_backup = true)
{
    // for /bin/cp here some important option for us
    // -f, --force
    // if an existing destination file cannot be opened, remove it and try again
    // -T, --no-target-directory
    // treat DEST as a normal file
    // -u, --update
    // copy only when the SOURCE file is newer than the destination
    // file or when the destination file is missing
    // --backup[=CONTROL]
    // make a backup of each existing destination file
    // The backup suffix is '~', unless set with --suffix or
    // SIMPLE_BACKUP_SUFFIX.
    // The version control method may be selected via the --backup option or
    // through the VERSION_CONTROL environment variable. Here are the values:
    // none, off : never make backups (even if --backup is given)
    // numbered, t : make numbered backups
    // existing, nil : numbered if numbered backups exist, simple otherwise
    // simple, never : always make simple backups
    // As a special case, cp makes a backup of SOURCE when the force and backup
    // options are given and SOURCE and DEST are the same name for an existing,
    // regular file.
    $uniqid = uniqid();
    // $r=0;
    if ($make_backup && file_exists($dst_pathfilename)) {
        $out = safe_sudo_exec(SAFE_CMD_COPY, '-f', $dst_pathfilename . ' ' . $dst_pathfilename . '.bak', $r);
        if ($r != 0) error_log("Safe_sudo_copy: backup $dst_pathfilename : $out :FAIL: $r ");
    }
    // even if the backup fail we will try the normal copy.
    $r = 0;
    $out = safe_sudo_exec(SAFE_CMD_COPY, '-f', array(
        $src_pathfilename,
        $dst_pathfilename
    ) , $r);
    if ($r != 0) {
        error_log("Safe_sudo_copy: copy $src_pathfilename to $dst_pathfilename : $out :FAIL: $r ");
        return false;
    }
    return true;
}
/**
 * Excute in a secure way a command with root privilege.
 *
 * @param $command      string      
 *                                    command to be execute
 * @param $line_options string      
 *                                    The line options of the command
 * @param $arguments    string|array
 *                                    Arguments, that will be secured
 * @param $return_var   int         
 *                                    return status of the executed command
 * @return array         Filled line by line with the output from the command.
 */
function safe_sudo_exec($command, $line_options = '', $arguments = '', &$return_var = null, $escapeshell = true)
{
    return safe_exec(SAFE_CMD_SUDO . ' ' . $command, $line_options, $arguments, $return_var, $escapeshell);
}
function safe_exec($command, $line_options = '', $arguments = '', &$return_var = null, $escapeshell = true)
{
    $command = $command . ' ' . $line_options . ' ';
    if ($arguments != '') {
        if (is_string($arguments)) $arguments = preg_split("/[\s,]+/", $arguments);
        array_map("escapeshellarg", $arguments);
        $command.= implode(' ', $arguments) . ' ';
    }
    if ($escapeshell) $command = escapeshellcmd($command);
    $comman = $command . SAFE_CMD_STDERR_REDIRECT;
    exec($command, $output, $return_var);
    // error_log ( "Safe_exec:" . $command ." ".implode(' ', $output));
    return $output;
}
/**
 * Verify and fix a specify tmp path or write folder path
 *
 * @param $path  string
 * @return string false fixed path without trailling / or false
 */
function safe_verify_tmp($path = '/tmp/SAFeUPLOADs')
{
    $path = realpath($path);
    $path = preg_replace('#/+$#', '', $path); // remove trailing /
    $path = preg_replace('#/+#', '/', $path); // replace non-single /
    if (!is_dir($path)) {
        if (file_exists($path)) @unlink($path);
        @mkdir($path, 0700, true);
    } else {
        if (!is_writable($path)) {
            @chmod($path, 0700);
        }
    }
    // Check
    if (is_dir($path) && is_writable($path)) return $path;
    else {
        // maybe put a default path!
        error_log("ERROR: Safe_verify_tmp('" . $path . "')");
        return false;
    }
}
function safe_var_dump($v)
{
    $trace = debug_backtrace();
?>
<br />
<pre
  style="display: block; text-align: left; color: black; background-color: yellow; font-size: x-small;">

<?php
    echo gettype($v) . ' called from: ';
    if (!empty($trace[1]['file'])) echo $trace[1]['file'] . '[' . $trace[1]['line'] . '] by function ' . $trace[1]['function'] . "\n";
    else echo "??? \n";
    print_r($v);
?>
</pre>
<br />
<?php
}
/**
 * Echo the debug backtrace
 */
function safe_debug_info()
{
    echo '<pre style="display: block; text-align: left; color: black; background-color: #D5D5D5; font-size: medium;">';
    foreach (debug_backtrace() as $k => $v) {
        if ($k) {
            $l = safe_debug_info_line($v, $k);
            echo htmlentities($l);
            error_log($l);
        }
    }
    echo "</pre>";
}
/**
 * Create a string from a backtrace line.
 * @param array  $v the backtrace line.
 * @param int    $k the backtrace index.
 * @return string
 */
function safe_debug_info_line($v, $k = 1)
{
    $backtracel = "";
    if ($v['function'] == "include" || $v['function'] == "include_once" || $v['function'] == "require_once" || $v['function'] == "require") {
        $backtracel.= "#" . ($k - 1) . " " . $v['function'] . "(" . $v['args'][0] . ") called at [" . $v['file'] . ":" . $v['line'] . "]\n";
    } else {
        $backtracel.= "#" . ($k - 1) . " " . $v['function'] . "() called at [" . ((!empty($v['file'])) ? $v['file'] : '') . ":";
        $backtracel.= ((!empty($v['line'])) ? $v['line'] : '') . "]\n";
    }
    return $backtracel;
}
/**
 * Add error with safe_errors_lib
 * @param string  $error            
 * @param boolean $apache_log       
 * @param boolean $include_backtrace
 * @param boolean $terminated       
 */
function safe_add_error($error, $apache_log = false, $include_backtrace = true, $terminated = false)
{
    $CI = & get_instance();
    $CI->safe_errors_lib->add_error($error, $apache_log, $include_backtrace, $terminated);
}
function safe_full_class_name($class)
{
    if (file_exists(APPPATH . 'libraries/' . $class . '.php')) return ucfirst($class);
    else if (file_exists(APPPATH . 'libraries/safe_' . $class . '_class.php')) return ucfirst($class);
    else {
        //error_log ("SAFE: ERROR: Do not found $class class.");
        return False;
    }
}
function safe_full_class_pathfilename($class)
{
    if (file_exists(APPPATH . 'libraries/' . $class . '.php')) return APPPATH . 'libraries/' . $class . '.php';
    else if (file_exists(APPPATH . 'libraries/safe_' . $class . '_class.php')) return APPPATH . 'libraries/safe_' . $class . '_class.php';
    else {
        //error_log ("SAFE: ERROR: Do not found $class class.");
        return $class . '.php';
    }
}
function safe_module_full_class_pathfilename($module_name, $class_name)
{
    $path_to_class = BASEPATH . '../../' . strtoupper($module_name) . '_modules/application/libraries/';
    if (file_exists($path_to_class . strtolower($module_name) . '_' . $class_name . '_class.php')) {
        return $path_to_class . strtolower($module_name) . '_' . $class_name . '_class.php';
    }
    //error_log ("SAFE: ERROR: Do not found ".$class_name." class for module ".$module_name);
    return false;
}
function safe_module_require_class($module_name, $class_name)
{
    if (safe_module_full_class_pathfilename($module_name, $class_name) !== FALSE) {
        require_once safe_module_full_class_pathfilename($module_name, $class_name);
        return TRUE;
    }
    return FALSE;
}
function safe_module_class_name($module_name, $class_name)
{
    return ucfirst($module_name) . '_' . $class_name . '_class';
}
function safe_new_module_class($module_name, $class_name)
{
    if (FALSE !== safe_module_require_class($module_name, $class_name)) {
        $full_class_name = ucfirst($module_name) . '_' . $class_name . '_class';
        return new $full_class_name();
    }
    return null;
}
function safe_require_controller($module_name, $controller_name)
{
    $path_to_module = BASEPATH . '../../' . strtoupper($module_name) . '_modules/';
    $controller = strtolower($module_name) . '_' . $controller_name;
    $file = $path_to_module . $controller . '/controllers/'.$controller.'.php';
    if (file_exists($file)) {
        require_once($file);
        return true;
    }
    error_log ("SAFE: ERROR: Do not found ".$controller_name." controller for module ".$module_name);
    return false;
}
/**
 * Do A require for a safe class libraries
 * @param string $class a safe class libraries short or full name
 */
function safe_require_class($class)
{
    // Look for the class first in the local application/libraries folder
    // then in the native system/libraries folder
    if (class_exists(safe_full_class_name($class)) === FALSE) require_once (safe_full_class_pathfilename($class));
}
/**
 * Load and invoke a safe class libraries
 * @param string $class
 * @return new    object of the safe class libraries or FALSE if error;
 */
function &safe_load_class($class)
{
    static $_classes = array();
    // Does the class exist? If so, we're done...
    if (isset($_classes[$class])) return $_classes[$class];
    $name = safe_full_class_name($class);
    // Did we find the class?
    if ($name === FALSE) exit('Unable to locate the specified class: ' . $class . '.php');
    // Is the request a class extension? If so we load it too
    safe_require_class($class);
    // Keep track of what we just loaded
    is_loaded($class);
    $_classes[$class] = new $name();
    return $_classes[$class];
}
function is_associative_array($arr)
{
    return (is_array($arr) && (!count($arr) || count(array_filter(array_keys($arr) , 'is_string')) == count($arr)));
}
function is_indexed_array($arr)
{
    return (is_array($arr) && (!count($arr) || count(array_filter(array_keys($arr) , 'is_int')) == count($arr)));
}
function &to_index_array(&$arr)
{
    if (!is_indexed_array($arr)) {
        $arr = array(
            $arr
        );
    }
    return $arr;
}
/**
 * Flush the ouput of code
 */
function safe_flush_ouput()
{
    $CI = & get_instance();
    $CI->output->_display();
    $CI->output->set_output('');
}
function Safe_xml_to_array($xml)
{
    if (is_array($xml)) $xml = implode($xml);
    $xml_parser = new SimpleXMLElement(trim($xml));
    $xml_array = json_decode(json_encode($xml_parser) , true);
    unset($xml_parser);
    return $xml_array;
}
function Safe_array_to_xml($root_element_name, $ar)
{
    $xml = new SimpleXMLElement("<?xml version=\"1.0\"?><{$root_element_name}></{$root_element_name}>");
    $f = create_function('$f,$c,$a', ' 
    foreach($a as $k=>$v) { 
      if(is_array($v)) { 
        if(is_associative_array($v)) {
          $ch=$c->addChild($k); 
          $f($f,$ch,$v); 
}else{
  foreach($v as $ak=>$av) {
    $ch=$c->addChild($k); 
    $f($f,$ch,$av); 
}
} 
} else { 
  $c->addChild($k,$v); 
} 
}');
    $f($f, $xml, $ar);
    return Safe_format_xml($xml->asXML());
}
/**
 * @brief Format xml string given in arguement and returns the formatted
 *            string. Originally taken here:
 *            
 *            http://recursive-design.com/blog/2007/04/05/format-xml-with-php/
 *            
 * @param[in] $xml raw xml string to be formatted.
 *            
 * @return formatted string
 */
function Safe_format_xml($xml)
{
    // add marker linefeeds to aid the pretty-tokeniser (adds a linefeed between
    // all tag-end boundaries)
    $xml = preg_replace('/(>)(<)(\/*)/', "$1\n$2$3", $xml);
    // now indent the tags
    $token = strtok($xml, "\n");
    $result = ''; // holds formatted version as it is built
    $pad = 0; // initial indent
    $matches = array(); // returns from preg_matches()
    // scan each line and adjust indent based on opening/closing tags
    while ($token !== false):
        // test for the various tag states
        // 1. open and closing tags on same line - no change
        if (preg_match('/.+<\/\w[^>]*>$/', $token, $matches)):
            $indent = 0;
            // 2. closing tag - outdent now
            elseif (preg_match('/^<\/\w/', $token, $matches)):
                $pad-= 2;
                $indent = 0;
                // 3. opening tag - don't pad this one, only subsequent tags
                elseif (preg_match('/^<\w[^>]*[^\/]>.*$/', $token, $matches)):
                    $indent = 2;
                    // 4. no indentation needed
                    else:
                        $indent = 0;
                    endif;
                    // pad the line with the required number of leading spaces
                    $line = str_pad($token, strlen($token) + $pad, ' ', STR_PAD_LEFT);
                    $result.= $line . "\n"; // add to the cumulative result, with linefeed
                    $token = strtok("\n"); // get the next token
                    $pad+= $indent; // update the pad size for subsequent lines    endwhile;
                    
                endwhile;
                return $result;
            }
            /**
             * @brief Handle PHP error to display pretty error screen
             *         
             * @return
             */
            $safe_error_buffer = array();
            $safe_unhandled_exception = FALSE;
            // Register error handler
            set_error_handler('safe_error_handler');
            register_shutdown_function('safe_shutdown_handler');
            set_exception_handler('safe_exception_handler');
            function safe_exception_handler($exception)
            {
                global $safe_error_buffer;
                global $safe_unhandled_exception;
                $safe_unhandled_exception = TRUE;
                $safe_error_buffer[] = array(
                    'severity' => 'UNHANDLED EXCEPTION',
                    'message' => $exception->getMessage() ,
                    'file' => $exception->getFile() ,
                    'line' => $exception->getLine() ,
                );
            }
            function safe_error_level_to_string($level)
            {
                $level_str = $level;
                switch ($level) {
                case E_ERROR:
                case E_CORE_ERROR:
                case E_COMPILE_ERROR:
                    $level_str = "ERROR";
                    break;

                case E_WARNING:
                    $level_str = "WARNING";
                    break;

                case E_NOTICE:
                    $level_str = "NOTICE";
                    break;

                case E_PARSE:
                    $level_str = "PARSE ERROR";
                    break;
                }
                return $level_str;
            }
            function safe_error_handler($errno, $errstr, $errfile, $errline, $errcontext = '')
            {
                global $safe_error_buffer;
                switch ($errno) {
                case E_ERROR:
                case E_CORE_ERROR:
                case E_COMPILE_ERROR:
                case E_WARNING:
                case E_PARSE:
                    $safe_error_buffer[] = array(
                        'severity' => safe_error_level_to_string($errno) ,
                        'message' => $errstr,
                        'file' => $errfile,
                        'line' => $errline,
                        // Too much info - 'context' => $errcontext,
                        
                    );
                    break;
                }
            }
            function safe_shutdown_handler()
            {
                global $safe_unhandled_exception;
                $error = error_get_last();
                if (NULL !== $error || $safe_unhandled_exception) {
                    safe_error_handler($error['type'], $error['message'], $error['file'], $error['line']);
                    global $safe_error_buffer;
                    header("HTTP/1.1 500 Internal Server Error", TRUE, 500);
                    echo "<link type='text/css' rel='stylesheet' href='/templates/sng/css/required.css'/>";
                    echo '<br/>';
                    echo '<br/>';
                    echo '<br/>';
                    echo '<div align="center" style="width:900px; margin:0 auto; text-align:center;">';
                    echo '<table class="mytable">';
                    echo '<tr>';
                    echo '<td class="mytableheader " colspan="2" style="text-align:center";>';
                    echo '<img src="/templates/sng/images/logo.png" style="float:none;"/>';
                    echo '</td>';
                    echo '</tr>';
                    echo '<tr>';
                    echo '<td class="mytableheader " colspan="2" style="text-align:center; color:red; font-size:large;";>';
                    echo '<img src="/templates/base/images/icons/16x16/dialog_icon_warning.png" style="vertical-align:middle; align:left;margin:5px;"/>';
                    echo 'System encountered the following errors';
                    echo '<img src="/templates/base/images/icons/16x16/dialog_icon_warning.png" style="vertical-align:middle; align:right; margin:5px;"/>';
                    echo '</td>';
                    echo '</tr>';
                    foreach ($safe_error_buffer as $error) {
                        foreach ($error as $k => $v) {
                            echo '<tr>';
                            echo '<td class="mytablealt">' . $k . '</td>';
                            if (is_array($v)) echo '<td><pre>' . print_r($v, TRUE) . '</pre></td>';
                            else echo '<td>' . $v . '</td>';
                            echo '</tr>';
                        }
                        echo '<tr>';
                        echo '<td colspan=2 class="mytablesubheader"/>';
                        echo '</tr>';
                    }
                    /*
                    echo '<tr>';
                    echo '<td colspan=2>';
                    safe_debug_info();
                    echo '</td>';
                    echo '</tr>';
                    */
                    echo '<tr>';
                    echo '<td class="mytableheader " colspan="2" style="text-align:center; color:red;";>';
                    echo '&nbsp';
                    echo '</td>';
                    echo '</tr>';
                    echo '</table>';
                    echo '</div>';
                }
            }
            function safe_back($offset = - 1)
            {
                echo '
      <script type="text/javascript">
  window.history.go(' . $offset . ');
  </script>';
            }
    /*
     * set default value in params
     */
    function safe_set_default($params,$key,$default_value){
        if(isset($params[$key]) && $params[$key]!==null){
            return $params[$key];
        }else{
            return $default_value;
        }
    }

    $file_lock = null;

    function safe_enter_critical_section() {
        global $file_lock;
        if(!$file_lock) {
            $file_lock = fopen(SAFE_FILE_LOCK, "w+");
        }
        if(!$file_lock)
            die('Fail to access ' . SAFE_FILE_LOCK);

        // Exclusive access
        if(!flock($file_lock, LOCK_EX))
            die('Fail to lock ' . SAFE_FILE_LOCK);

        fwrite($file_lock, date(DATE_RFC822).PHP_EOL);
        fwrite($file_lock, 'PID:'.getmypid().PHP_EOL);
        // Add callback in case we die after this point
        register_shutdown_function(safe_leave_critical_section);
    }

    function safe_leave_critical_section() {
        global $file_lock;
        if($file_lock) {
            $fd = $file_lock;
            $file_lock = null;
            flock($fd, LOCK_UN);
            fclose($fd);
        }
    }
    
    /**
     * Test if port_data and sp_port_data is conflict
     * @param array $port_data = ('port','ip','type')source port data
     * @param array $sp_port_data = ('port','ip','type')specific port data
     */
    function safe_check_port_conflict($port_data, $sp_port_data) {
        $port = $port_data['port'];
        $ip = $port_data['ip'];
        $type = $port_data['type'];
        $sp_port = $sp_port_data['port'];
        $sp_ip = $sp_port_data['ip'];
        $sp_type = $sp_port_data['type'];
        if (empty($type)) $type ='TCP';
        if (empty($sp_type)) $sp_type ='TCP';
    
        $type     = strtoupper(str_ireplace( array ('TLS','ALL'), array('TCP','TCPUDP'), $type));
        $sp_type  = strtoupper(str_ireplace( array ('TLS','ALL'), array('TCP','TCPUDP'), $sp_type));
        $ip       = strtoupper(trim($ip));
        $sp_ip    = strtoupper(trim($sp_ip));
        $tcp = false;
        $udp = false;
        if(strpos($type,'TCP')!==false && strpos($sp_type,'TCP')!==false) $tcp = true;
        if(strpos($type,'UDP')!==false && strpos($sp_type,'UDP')!==false) $udp = true;
        if($tcp || $udp){
            if($port == $sp_port){
                $port_used = true;
                if( $ip == 'ALL' || $sp_ip == 'ALL'){
                }else{
                    if($ip != $sp_ip){
                        $port_used = false;
                    }
                }
            }else{
                $port_used = false;
            }
        }else{
            $port_used = false;
        }
        return $port_used;
    }
    
    function safe_cidr_match($ipaddr, $cidr) {
        $ip = '';
        foreach (explode('.', $ipaddr) as $val) {
            $ip = $ip . str_pad(decbin($val), 8, '0', STR_PAD_LEFT);
        }
        list($subnet, $mask) = explode('/',$cidr);
        $s_ip = '';
        foreach (explode('.', $subnet) as  $val) {
            $s_ip = $s_ip . str_pad(decbin($val), 8, '0', STR_PAD_LEFT);
        }
        return (substr($ip,0,$mask) === substr($s_ip,0,$mask)) ;
    }

/* End of file safe_helper.php */
            
