<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * NSC Domain Profile Class
 * @author: Shaunt Libarian
 *          
 */
require_once ('application/helpers/safe_helper.php');
safe_require_class('object');
safe_require_class('hardware');
safe_module_require_class('nsc', 'application');
safe_module_require_class('nsc', 'domain_users');
safe_module_require_class('fs', 'domain');
class Nsc_domain_class extends Fs_domain_class
{
    /**
     * @brief
     *           
     * @param[in out] $node
     * @param[in out] $parent_name
     * @param[in out] $name
     *           
     * @return
     */
    public function __construct($node, $parent_name, $name)
    {
        // Parent constructor to invoke unserialize if needed
        parent::__construct($node, $parent_name, $name);
    }
    public function create_user($user_name)
    {
        return new Nsc_domain_users_class($this->_node, $this->object_name() . '/user', $user_name);
    }
    private function _sip_profiles()
    {
        $_the_app = $this->_node->software()->application();
        return $_the_app->sip_profiles();
    }
    /**
     * @brief
     *         
     * @return
     */
    public function configure()
    {
        $this->add_enum_field('forward-registration', 'Forward Registration / Authentication', 'dropdown', 'false', $this->enable_disable_enum());
        $this->set_field_help('forward-registration', 'Enable/Disable registration and authentication requests to a registrar server.');
        // SIP profile enum list
        $sip_profile_enum = array(
            'none' => '--- Same Profile ---'
        );
        $sip_profiles = $this->_sip_profiles();
        if (isset($sip_profiles)) {
            foreach ($sip_profiles as $sip_profile) {
                $sip_profile_enum[$sip_profile->name() ] = $sip_profile->name();
            }
        }
        $this->add_enum_field('registrar-profile', 'Forward SIP profile', 'dropdown', 'none', $sip_profile_enum);
        $this->set_field_help('registrar-profile', 'This SIP profile will be used to contact the registrar server and forward the REGISTER message');
        $this->add_field('registrar-server', 'Forward Registrar Server', 'string', '', 50);
        $this->set_field_rules('registrar-server', 'required[forward-registration]');
        $this->set_field_help('registrar-server', 'Registration server IP address or Domain Name.');
        $this->add_field('registrar-port', 'Forward Registrar Server Port', 'string', '5060', 10);
        $this->set_field_rules('registrar-port', 'required[forward-registration]');
        $this->set_field_help('registrar-port', 'Registration servers IP Port.');
        $this->add_enum_field('register-transport', 'Transport', 'dropdown', 'udp', array(
            'udp' => 'UDP',
            'tcp' => 'TCP',
            'tls' => 'TLS',
        ));
        $this->set_field_help('register-transport', 'Transport type being used for REGISTER.');

        $this->add_field('sip-force-expires', 'Force Expires', 'string', '', 10);
        $this->set_field_rules('sip-force-expires', 'integer|greater_than[4]');
        $this->set_field_help('sip-force-expires', 'If specified, it is the number of seconds to force registration expiration to. Minimum value is 5.');
        // Create conditional group
        $this->create_group('register', array(
            'registrar-profile',
            'registrar-server',
            'registrar-port',
            'register-transport',
            'sip-force-expires',
        ));
        // 2. tell the field 'register' which existing group it can control (register)
        $this->conditional_control('forward-registration', 'register');
        return parent::configure();
    }
    /**
     * Checks to see if object can be deleted
     * @see Safe_serializable_object_class::can_dispose()
     */
    public function can_dispose()
    {
        //Check if media profile used in any sip profiles
        $this->_the_app = $this->_node->software()->application();
        $this->_sip_profiles = $this->_the_app->sip_profiles();
        $return = "";
        foreach ($this->_sip_profiles as $profile) {
            if (isset($profile)) {
                if ($profile->domain_check($this->name())) {
                    return false;
                }
            }
        }
        return parent::can_dispose();
    }
    public function is_sip_profile_used($sip_profile)
    {
        $cfg = $this->get_data_values(false);
        if (isset($cfg['registrar-profile']) && $sip_profile == $cfg['registrar-profile']) return true;
        return false;
    }
    public function is_forward_enabled()
    {
        $forward = $this->get_data_value('forward-registration', false);
        return ('true' == $forward);
    }
}
?>
