<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * NTG Transcoder Statistics
 *
 * @author Shaunt Libarian
 * @version
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
require_once ('application/controllers/Safe_CI_Controller.php');
safe_require_class('product');
safe_require_class('service');
safe_require_class('table');
class Ntg_statistics extends Safe_CI_Controller
{
    public $_statistics;
    public $_status;
    public function __construct()
    {
        parent::__construct();
        //Override $this->_the_app so that we can use sngms
        $this->_the_app = $this->_the_product->local_node()->software()->application()->module('sngms');
        $this->_status = $this->_the_product->local_node()->software()->application()->status();
    }
    public function index()
    {
        // verify if logged
        //safe_authenticate ();
        if (Safe_service_class::STATUS_RUNNING != $this->_status) {
            //NTG not running, unrecognized or in error state
            // Set the basic data
            $data['page_title'] = $this->_the_product->name() . ' Statistics';
            $data['page_summary'] = 'This page displays statistics of all hardware installed on the system.';
            $data['page_large_icon'] = '/images/icons/32x32/icon-register.png';
            $data['page_small_icon'] = '/images/icons/16x16/icon-register.png';
            $data['errors'] = array();
            $table = new Safe_table_class();
            $data['notif_error'][] = $this->_the_app->description() . ' is currently stopped.'; 
            $data['notif_error'][] = safe_form_with_submit_button('Click here to ', '/SAFe/sng_control_panel', 'Start the Service', '');
            //Loads the HTML Data
            $this->load->view("safe_header", $data);
            $this->load->view("safe_error");
            //$this->load->view ("safe_expand_panel",$data);
            $this->load->view("safe_notifications", $data);
            $this->load->view("safe_footer", $data);
        } else {
            // Set the basic data
            $data['page_title'] = $this->_the_product->name() . ' Statistics';
            $data['page_summary'] = 'This page displays statistics of all hardware installed on the system.';
            $data['page_large_icon'] = '/images/icons/32x32/icon-register.png';
            $data['page_small_icon'] = '/images/icons/16x16/icon-register.png';
            $data['errors'] = array();
            // Display TRANSCODING media mode
            $transcoding_mode = new Sng_transcoding_config_class($this->_the_product->local_node());
            $transcoding_mode->configure();
            $transcoding_mode_data = $transcoding_mode->get_data_values(false);
            if ($transcoding_mode->is_enabled()) {
                //Open the library
                $this->load->library('ntg_statistics_lib');
                $stats = new Ntg_statistics_lib();
                $stats->_statistics = $this->_the_app;
                //$data ['notif_info'] = array();
                //Display output
                //Display Summary Table
                $data['summary_title'] = $stats->summary_table_title;
                $stats->summary_table();
                $data['summary'] = $stats->generate_vertical_table1();
                $data['summary_title2'] = $stats->summary_table_title2;
                //$stats->summary_table();
                $data['summary2'] = $stats->generate_vertical_table2();
                //Display Usage Table
                $data['table_title'] = $stats->table_title;
                $stats->information();
                $data['table'] = $stats->generate_table();
                //Get warnings from table
                $stats->warnings($data['notif_warn']);
                $stats->info($data['notif_info']);
                $show_table = true;
            } else {
                $data['notif_warn'][] =  $this->_the_app->description() ." is disabled.";
                $data['notif_warn'][] = safe_form_with_submit_button('To enable '. $this->_the_app->description() .' ', '/SAFe/ntg_media_server_interfaces/scan', 'Click Here', '');
                $show_table = false;
            }
            //Loads the HTML Data
            $this->load->view("safe_header", $data);
            $this->load->view("safe_confirm_dialog", $data);//load confirm dialog js and css
            $this->load->view("safe_error");
            //$this->load->view ("safe_expand_panel",$data);
            if ($show_table) $this->load->view("ntg_statistics", $data);
            elseif (!$show_table) $this->load->view('safe_notifications', $data);
            $this->load->view("safe_footer", $data);
        }
    }
    //Puts module in service
    public function IS($mac_replace)
    {
        // verify if logged
        //safe_authenticate ();
        $result = null;
        $table_info = array();
        //Open the library
        $this->load->library('ntg_statistics_lib');
        $stats = new Ntg_statistics_lib();
        // Set the basic data
        $data['page_title'] = $this->_the_product->name() . ' Statistics';
        $data['page_summary'] = 'This page displays statistics of all hardware installed on the system.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-register.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-register.png';
        $data['errors'] = array();
        $mac = str_replace('%3A', ':', $mac_replace);
        $data['table_title'] = 'Service Request';
        $this->_the_app->service_request($result, $mac, 'up');
        $stats->data = array(
            $result
        );
        $stats->footer_button[] = array(
            'url' => base_url('ntg_statistics') ,
            'name' => 'Return to Statistics'
        );
        $data['table'] = $stats->generate_table();
        //Loads the HTML Data
        $this->load->view("safe_header", $data);
        $this->load->view("safe_error");
        //$this->load->view ("safe_expand_panel",$data);
        $this->load->view("ntg_statistics_is_os_ds", $data);
        $this->load->view("safe_footer", $data);
    }
    //Puts module out os service
    public function OOS_confirm($mac_replace)
    {
        $data['page_title'] = 'Disable Module';
        $data['message'] = 'Are you sure you would like to Disable Module  <b>' . $mac_replace . '</b>?';
        $data['message_type'] = 'notice';
        $data['result'] = true;
        $data['action_url'] = base_url($this->router->fetch_class()). '/OOS/'.$mac_replace;
        echo json_encode($data);
    }
    //Puts module out os service
    public function OOS($mac_replace)
    {
        // verify if logged
        //safe_authenticate ();
        //Open the library
        $data['page_title'] = 'Disable Module';
        $mac = str_replace('%3A', ':', $mac_replace);
        $this->_the_app->service_request($result, $mac, 'down');
        $data['result'] = true;
        $data['redirect_url'] = base_url( $this->router->fetch_class());
        echo json_encode($data);
    }
    /*
     * confirm to drop sessions
     */
    public function drop_sessions_confirm()
    {
        $data['page_title'] = 'Drop Sessions';
        $data['message'] = 'Are you sure you would like to Drop ALL Sessions?';
        $data['message_type'] = 'notice';
        $data['result'] = true;
        $data['action_url'] = base_url($this->router->fetch_class()). '/drop_sessions/';
        echo json_encode($data);
    }
    public function drop_sessions()
    {
        // verify if logged
        //safe_authenticate ();
        $result = null;
        //Open the library
        $this->_the_app->term_sessions($result);
        $data['result'] = true;
        $data['redirect_url'] = base_url( $this->router->fetch_class());
        echo json_encode($data);
    }
}
