<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * CodeMirror test page
 *
 * @author William Adam
 * @version
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
require_once ('application/controllers/Safe_CI_Controller.php');
safe_require_class('product');
safe_require_class('table');
safe_require_class('form');
class Ntg_sip_profiles extends Safe_CI_Controller
{
    public $_sip_profiles;
    //public $_the_product;
    public $_the_app;
    public function __construct()
    {
        parent::__construct();
        //$this->_the_product = Safe_get_product();
        $this->_the_app = $this->_the_product->local_node()->software()->application();
        $this->_sip_profiles = $this->_the_app->sip_profiles();
    }
    public function index()
    {
        // verify if logged
        //safe_authenticate ();
        // Set the basic data
        $data['page_title'] = 'SIP Profiles';
        $data['page_summary'] = 'This page allows managing SIP profiles settings.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        // Prepare table structure
        $data['table_size'] = '100%';
        $table = new Safe_table_class();
        $data['table_title'] = 'SIP profiles';
        // Prepare heading
        $table->heading = array(
            'Name',
            'User Agent',
            'IP address',
            'Transport',
            'Port'
        );
        // Prepare rows
        $table->data = array();
        $table->line_button = array();
        foreach ($this->_sip_profiles as $profile) {
            $prof_data = $profile->get_data_values();
            $table->data[] = array(
                $profile->name() ,
                $prof_data['user-agent-string'],
                $prof_data['sip-ip'],
                $prof_data['transport'],
                $prof_data['sip-port'],
            );
            array_push($table->primary_key, $profile->name());
            array_push($table->line_button, array(
                array(
                    'url' => 'ntg_sip_profiles/edit',
                    'name' => 'Edit',
                    'label' => ''
                )
            ));
        }
        // Generate table HTML code
        $data['table'] = $table->generate();
        $this->load->view("safe_header", $data);
        $this->load->view("safe_table", $data);
        $this->load->view("safe_footer", $data);
    }
    public function edit($profile_name)
    {
        // verify if logged
        //safe_authenticate ();
        if (!isset($profile_name)) exit('Profile name required');
        $sip_profile = $this->_sip_profiles[$profile_name];
        $config = $sip_profile->get_data();
        // Check post request
        $post = $this->input->post();
        if (isset($post['cancel'])) {
            redirect('/ntg_sip_profiles/', 'refresh');
        } elseif (isset($post['save'])) {
            // Validate and save
            unset($post['save']);
            // run validation
            $validation_errors = array();
            $sip_profile->set_data_values($post);
            $this->load->library("safe_form_class", $sip_profile->get_data());
            if ($this->safe_form_class->run_validation($validation_errors)) {
                if (TRUE == $sip_profile->save()) redirect('/ntg_sip_profiles/', 'refresh');
            }
            // Add validations errors to notification box
            // TODO(WADAM) - Modify form generation to add error tooltip on  faulty
            // field
            $data['notif_error'] = $validation_errors;
        } else {
            // Prepare form for configuration
            $this->load->library("safe_form_class", $config);
        }
        // Set the basic data
        $data['page_title'] = $sip_profile->name() . ' SIP Profile';
        $data['page_summary'] = 'This page allows managing SIP profile settings.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        $data['form_title'] = 'SIP profile : ' . $sip_profile->name();
        $data['form'] = $this->safe_form_class->form_input_array();
        $data['label'] = $this->safe_form_class->form_label_array();
        $data['form_open'] = $this->safe_form_class->form_open();
        $data['buttons'] = array(
            array(
                'name' => 'save',
                'value' => 'Save',
                'type' => 'submit'
            ) ,
            array(
                'name' => 'cancel',
                'value' => 'Cancel',
                'type' => 'submit'
            ) ,
        );
        $this->load->view("safe_header", $data);
        $this->load->view("safe_notifications", $data);
        $this->load->view("safe_form", $data);
        $this->load->view("safe_footer", $data);
    }
    public function dump()
    {
        foreach ($this->_the_app->sip_profiles() as $profile) {
            echo '</br>';
            echo "Profile " . $profile->name() . '</br>';
            print_r($profile->get_data_values(false));
        }
        foreach ($this->_the_app->media_profiles() as $profile) {
            echo '</br>';
            echo "Profile " . $profile->name() . '</br>';
            print_r($profile->get_data_values(false));
        }
        foreach ($this->_the_app->proxy_profiles() as $profile) {
            echo '</br>';
            echo "Profile " . $profile->name() . '</br>';
            print_r($profile->get_data_values(false));
        }
    }
}
/* End of file safe_edito.php */
