<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/*
 * NTG Product class
*/
require_once ('application/helpers/safe_helper.php');
safe_require_class('safe_config_class');
safe_module_require_class('sng', 'adapter_detector');
safe_module_require_class('sng', 'transcoding_config');
safe_module_require_class('ntg', 'application');
class Ntg_hardware_class extends Safe_hardware_class
{
    // Overload configure
    public function configure()
    {
        if (false === parent::configure()) return false;
        // Register hardware detector
        $this->register_detector(new Sng_transcoding_detector_class());
        $this->register_detector(new Sng_management_detector_class());
        // We gonna need all Ethernet interfaces settings (just to figure out if
        // some configuration has changed)
        $this->detect_adapters();
        return true;
    }
    // Overload generate config
    public function generate_config(&$config)
    {
        $transcoding_mode = new Sng_transcoding_config_class($this->node());
        $transcoding_mode->configure();
        $transcoding_cfg = $transcoding_mode->get_data_values(false);
        if ('true' == $transcoding_cfg['enable_media_interface']) {
            // Just need to consider transcoding adapters
            $adapters2 = $this->adapters(Safe_hardware_adapter_class::TRANSCODING_ADAPTER);
            $adapters1 = $this->adapters(Safe_hardware_adapter_class::ETHERNET_ADAPTER);
            $adapters = array_merge($adapters1, $adapters2);
            $hw_config = array();
            // Add global config
            $hw_config['config'] = array(
                'watchdog_timeout_ms' => 1000,
                'reactor_timeout_ms' => 100,
                'cpu_usage_low_threshold' => 85,
                'cpu_usage_high_threshold' => 95,
            );
            foreach ($adapters as $adapter) {
                // Prepare device entry
                if (preg_match("'^[Ss]ng[Dd]sp'", $adapter->name())) $model = 'D500';
                else $model = 'D150';
                $device = array(
                    'ifname' => $adapter->name() ,
                    'hwaddr' => $adapter->mac() ,
                    'model' => $model, // No way to figure it out
                    'module' => array()
                );
                // Iterate on modules
                foreach ($adapter->modules() as $module) {
                    if ($module->enable()) {
                        $module_cfg = array(
                            'hwaddr' => $module->mac() ,
                            'ip' => $module->ip_address() ,
                            'mask' => $module->mask() ,
                            'eth_port' => $module->port() ,
                            'udp' => array(
                                'begin' => $module->udp_begin() ,
                                'end' => $module->udp_end() ,
                            ) ,
                            'max_sessions' => $module->max_sessions(),
                        );
                        if (strlen($module->gateway())) $module_cfg['gw'] = $module->gateway();
                        if (strlen($module->ext_ip_address())) $module_cfg['external-ip'] = $module->ext_ip_address();
                        //Checks if VLan's configured
                        //Will only place in the file when user is in Hidden
                        if (strlen($module->vlan_id()) && $transcoding_cfg['individual-ip'] == 'true') $module_cfg['vlan_id'] = $module->vlan_id();
                        elseif (strlen($transcoding_cfg['vlan_id']) && $transcoding_cfg['individual-ip'] == 'true') $module_cfg['vlan_id'] = $transcoding_cfg['vlan_id'];
                        $device['module'][] = $module_cfg;
                        unset($module_cfg);
                    }
                }
                // Check if some modules enabled for the device
                if (!empty($device['module'])) $hw_config['device'][] = $device;
            }
            if (isset($hw_config['device']) && !empty($hw_config['device'])) {
                $config->add_config(new Safe_configuration_class('mod_sangoma_media_server/vocallo.xml', Safe_array_to_xml('vocallo', $hw_config)));
            } else {
                $config->add_error('Validating', 'No Media Server Interfaces configured.', '/SAFe/ntg_media_server_interfaces', 'Configure');
                //return false;
                
            }
        } else {
            //Remove Vocallo.xml
            $config->add_config(new Safe_configuration_class('mod_sangoma_media_server/vocallo.xml', '', Safe_configuration_class::CFG_DELETE, Safe_configuration_class::CFG_FILE));
        }
        return parent::generate_config($config);
    }
    /**
     * @brief checklist
     *
    * Validate that transcoding adapter has IP address specified
    *
    * @param[in out] $list
    *
    * @return 
    */
    public function checklist(&$list){
        foreach($this->adapters(Safe_hardware_adapter_class::TRANSCODING_ADAPTER) as $adapter){
            // Check IP
            if(!$adapter->ip_address()){
                $list[] = array(
                    'module' => 'hardware',
                    'obj_type' => 'adapter',
                    'obj_name' => $adapter->name(),
                    'description' => 'IP address not set',
                );
            }
        }
    }
}
class Ntg_product_class extends Safe_product_class
{
    public function __construct($name = 'NTG')
    {
        parent::__construct($name);
    }
    /**
     * @brief Overloaded create application to create NTG specific application
     *         
     * @return
     */
    public function &create_application()
    {
        return new Ntg_application_class($this->local_node()->software());
    }
    /**
     * @brief Overloaded create hardware
     *           
     * @param[in out] $node
     *           
     * @return
     */
    public function create_hardware_class($node)
    {
        return new Ntg_hardware_class($node);
    }
}
/* End of file ntg_product_class.php */
