<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/*
 * NTG application class
*/
require_once ('application/helpers/safe_helper.php');
safe_require_class('object');
safe_require_class('hardware');
safe_module_require_class('fs', 'application');
safe_module_require_class('fs', 'sngms_module');
safe_module_require_class('nsc', 'sip_profiles');
class Ntg_sip_profile_class extends Safe_configurable_object_class
{
    private $_name;
    /**
     * @brief
     *           
     * @param[in out] $node
     * @param[in out] $parent_name
     * @param[in out] $name
     *           
     * @return
     */
    public function __construct($node, $parent_name, $name)
    {
        // Parent constructor to invoke unserialize if needed
        parent::__construct($parent_name . '/profile/sip', $name, $node);
        $this->_name = $name;
    }
    /**
     * @brief
     *         
     * @return
     */
    public function configure()
    {
        // Default interface name
        $def_if = '';
        // Populate IP enumeration with all management interface IP
        $mgmt_if = $this->_node->hardware()->adapters(Safe_hardware_adapter_class::ETHERNET_ADAPTER);
        $if_enum = array();
        foreach ($mgmt_if as $if_name => $if) {
            //if(sizeof($if->ip_address()))
            {
                if (!sizeof($def_if)) $def_if = $if_name;
                $if_enum[$if_name] = $if_name . ' - ' . $if->ip_address();
            }
        }
        // We must have at least one entry or we're in trouble
        if (!sizeof($if_enum)) {
            // TODO(wadam) - Do something
            
        }
        // Create object fields
        $this->add_field('user-agent-string', 'User Agent', 'string', 'NetBorder Transcoding Gateway', 50);
        $this->set_field_rules('user-agent-string', 'required');
        $this->add_enum_field('sip-ip', 'IP address', 'dropdown', $def_if, $if_enum);
        $this->set_field_rules('sip-ip', 'required');
        // Special case for sip port depending on profile name
        if ('external' == $this->_name) $this->add_field('sip-port', 'Port', 'string', '5080');
        else $this->add_field('sip-port', 'Port', 'string', '5060');
        $this->set_field_rules('sip-port', 'required|integer|greater_than[0]|less_than[65536]');
        $this->add_enum_field('transport', 'Transport', 'dropdown', 'udptcp', array(
            'udp' => 'UDP',
            'tcp' => 'TCP',
            'udptcp' => 'UDP+TCP',
            //'tls'     => 'TLS' // TLS not supported in RC1
            
        ));
        $this->add_enum_field('enable-100rel', '100 Reliability', 'dropdown', 'false', $this->enable_disable_enum());
        $this->add_enum_field('enable-timer', 'SIP Session Timer', 'dropdown', 'false', $this->enable_disable_enum());
        $this->add_field('session-timeout', 'Session Expires', 'string', 1800);
        $this->set_field_rules('session-timeout', 'required|integer|greater_than[89]');
        $this->add_field('minimum-session-expires', 'Minimum Session Expires', 'string', 1800);
        $this->set_field_rules('minimum-session-expires', 'required|integer|greater_than[89]');
        $this->add_enum_field('ignore-183nosdp', 'Ignore 183 without SDP', 'dropdown', 'false', $this->enable_disable_enum());
        return parent::configure();
    }
}
class Ntg_media_profile_class extends Safe_configurable_object_class
{
    /**
     * @brief
     *           
     * @param[in out] $parent_name
     * @param[in out] $name
     *           
     * @return
     */
    public function __construct($parent_name, $name)
    {
        // Constructor called at then end for serialization
        parent::__construct($parent_name . "/profile/media", $name);
    }
    public function configure()
    {
        $codec_enum = array(
            'none' => '',
            'PCMU@20i' => 'PCMU 20ms, PT=0',
            'PCMU@30i' => 'PCMU 30ms, PT=0',
            'PCMA@20i' => 'PCMA 20ms, PT=8',
            'PCMA@30i' => 'PCMA 30ms, PT=8',
            'G729@20i' => 'G.729 20ms, PT=18',
            'G729@30i' => 'G.729 30ms, PT=18',
            'AMR@4750@20i' => 'AMR 4.75Kbps 20ms, PT=96',
            'AMR@4750@40i' => 'AMR 4.75Kbps 40ms, PT=96',
            'AMR@12200@20i' => 'AMR 12.20Kbps 20ms, PT=96',
            'AMR@12200@40i' => 'AMR 12.20Kbps 40ms, PT=96',
            'iLBC@15200@20i' => 'iLBC 15.20Kbps 20ms, PT=97',
            'iLBC@13330@30i' => 'iLBC 13.33Kbps 30ms, PT=97',
            'GSM@20i' => 'GSM, PT=3',
            'G722@20i' => 'G.722 20ms, PT=9',
            'G722@30i' => 'G.722 30ms, PT=9',
            'G7221@32000h@20i' => 'G.722.1C 20ms, PT=115',
            'G7231@30i' => 'G.723.1 30ms, PT=4',
            'G726-16@20i' => 'G.726 16Kbps 20ms, PT=124',
            'G726-24@20i' => 'G.726 24Kbps 20ms, PT=123',
            'G726-32@20i' => 'G.726 32Kbps 20ms, PT=99',
            'G726-40@20i' => 'G.726 40Kbps 20ms, PT=121',
            'G726-16@30i' => 'G.726 16Kbps 30ms, PT=124',
            'G726-24@30i' => 'G.726 24Kbps 30ms, PT=123',
            'G726-32@30i' => 'G.726 32Kbps 30ms, PT=99',
            'G726-40@30i' => 'G.726 40Kbps 30ms, PT=121',
        );
        // Create object fields
        $this->add_enum_field('codec-1', 'Codec #1', 'dropdown', 'PCMU@20i', $codec_enum);
        //$this->set_field_rules('codec-1', 'not_matches[codec-2]|not_matches[codec-3]|not_matches[codec-4]|not_matches[codec-5]');
        $this->add_enum_field('codec-2', 'Codec #2', 'dropdown', 'PCMA@20i', $codec_enum);
        //$this->set_field_rules('codec-2', 'not_matches[codec-1]|not_matches[codec-3]|not_matches[codec-4]|not_matches[codec-5]');
        $this->add_enum_field('codec-3', 'Codec #3', 'dropdown', 'G729@30i', $codec_enum);
        //$this->set_field_rules('codec-3', 'not_matches[codec-1]|not_matches[codec-2]|not_matches[codec-4]|not_matches[codec-5]');
        $this->add_enum_field('codec-4', 'Codec #4', 'dropdown', 'iLBC@13330@30i', $codec_enum);
        //$this->set_field_rules('codec-4', 'not_matches[codec-1]|not_matches[codec-2]|not_matches[codec-3]|not_matches[codec-5]');
        $this->add_enum_field('codec-5', 'Codec #5', 'dropdown', 'AMR@12200@40i', $codec_enum);
        //$this->set_field_rules('codec-5', 'not_matches[codec-1]|not_matches[codec-2]|not_matches[codec-3]|not_matches[codec-4]');
        // For RC1, only 5 codecs will be available
        //$this->add_enum_field('codec-6', 'Codec #6', 'dropdown', 'none', $codec_enum);
        $this->add_enum_field('negotiation', 'Codec Negotiation Mode', 'dropdown', 'generous', array(
            'generous' => 'Prefer-Remote',
            'greedy' => 'Prefer-Local'
        ));
        $this->add_enum_field('silence-supp', 'Enable Silence Suppression', 'dropdown', 'false', $this->enable_disable_enum());
        /*
        * Removed as per Task#2563 description
        $this->add_field('cn-pt', 'Default Comfort Noise Payload Type', 'text', 13);
        $this->add_field('rfc2833-pt', 'RFC 2833 Payload Type', 'text', 101);
        $this->add_enum_field('enable-rtcp', 'RTCP', 'dropdown', 'true', $this->enable_disable_enum());
        */
        $this->add_enum_field('dtmf-type', 'DTMF Mode', 'dropdown', 'rfc2833', array(
            'none' => 'Inband',
            'rfc2833' => 'RFC 2833',
            //'info'  => 'SIP INFO' // SIP Info not supported in RC1
            
        ));
        return parent::configure();
    }
}
class Ntg_proxy_profile_class extends Safe_configurable_object_class
{
    /**
     * @brief
     *           
     * @param[in out] $parent_name
     * @param[in out] $name
     *           
     * @return
     */
    public function __construct($parent_name, $name)
    {
        // Constructor called at then end for serialization
        parent::__construct($parent_name . "/profile/proxy", $name);
    }
    public function configure()
    {
        // Create object fields
        $this->add_enum_field('enable-proxy', 'Enable Proxy Profile', 'dropdown', 'false', $this->enable_disable_enum());
        // !-! jpboily : for now, we will use the profile name as the proxy name
        //$this->add_field('proxy-name', 'Proxy Name', 'string', 'gateway', 50);
        $this->add_field('proxy', 'Proxy URI', 'string', '', 50);
        $this->add_field('from-domain', 'From Domain', 'string', php_uname('n') , 50);
        $this->add_field('username', 'User Name', 'string', 'guest');
        $this->add_field('password', 'Password', 'password', '');
        $this->add_field('realm', 'Domain/Realm', 'string', '', 50);
        $this->add_enum_field('register', 'Enable Registration', 'dropdown', 'false', $this->enable_disable_enum());
        $this->add_field('expire-seconds', 'Registration Expiration', 'string', '3600');
        $this->set_field_rules('expire-seconds', 'required|greater_than[0]');
        return parent::configure();
    }
}
class Ntg_application_class extends Fs_application_class
{
    private $_sip_profiles = null;
    private $_media_profiles = null;
    private $_proxy_profiles = null;
    private $_new_sip_profile = null;
    public function __construct($software)
    {
        // Parent constructor
        parent::__construct($software, 'ntg', 'freeswitch');
        // Fill profile objects name with default
        $this->_sip_profiles = array(
            "internal" => null,
            'external' => null
        );
        $this->_media_profiles = array(
            "inbound_internal" => null,
            "inbound_external" => null,
            "outbound_internal" => null,
            "outbound_external" => null,
        );
        $this->_proxy_profiles = array(
            "internal" => null,
            "external" => null
        );
        // Register Freeswitch modules
        $this->register_module(new Fs_sngms_module_class($this));
    }
    public function configure()
    {
        if (false === parent::configure()) return false;
        // Call all profiles methods
        $this->sip_profiles();
        $this->media_profiles();
        $this->proxy_profiles();
        return true;
    }
    public function sip_profiles()
    {
        foreach ($this->_sip_profiles as $k => $v) {
            if (null == $v) {
                $v = new Ntg_sip_profile_class($this->node() , parent::object_name() , $k);
                $v->configure();
                $v->synch();
            }
            $this->_sip_profiles[$k] = $v;
        }
        return $this->_sip_profiles;
    }
    public function media_profiles()
    {
        foreach ($this->_media_profiles as $k => $v) {
            if (null == $v) {
                $v = new Ntg_media_profile_class(parent::object_name() , $k);
                $v->configure();
                $v->synch();
            }
            $this->_media_profiles[$k] = $v;
        }
        return $this->_media_profiles;
    }
    public function proxy_profiles()
    {
        foreach ($this->_proxy_profiles as $k => $v) {
            if (null == $v) {
                $v = new Ntg_proxy_profile_class(parent::object_name() , $k);
                $v->configure();
                $v->synch();
            }
            $this->_proxy_profiles[$k] = $v;
        }
        return $this->_proxy_profiles;
    }
    public function generate_config(&$config_manager)
    {
        $dialplan_info = array();
        foreach ($this->sip_profiles() as $profile) {
            if (!$this->write_sip_profile($config_manager, $profile)) return false;
            $dialplan_info[$profile->name() ] = "";
        }
        foreach ($this->media_profiles() as $profile) {
            if (!$this->write_media_profile($config_manager, $profile)) return false;
        }
        foreach ($this->proxy_profiles() as $profile) {
            if (!$this->write_proxy_profile($config_manager, $profile)) return false;
            // !+! jpboily : Bug 3485 - For now, we assign internal proxy profile to
            // external sip profile, vice-versa.
            if ($profile->get_data_value("enable-proxy", false) == "true") {
                if ("internal" == $profile->name()) {
                    $dialplan_info["external"] = $profile->name();
                } else if ("external" == $profile->name()) {
                    $dialplan_info["internal"] = $profile->name();
                }
                //!-! jpboily: for now, we use the profile name as the proxy name
                //$dialplan_info[$profile->name()]=$profile->get_data_value("proxy-name");
                
            }
        }
        if (!$this->write_dialplan($config_manager, $dialplan_info)) return false;
        return parent::generate_config($config_manager);
    }
    private function write_sip_profile(&$cfg_mgr, $sip_profile)
    {
        $profile_name = $sip_profile->name();
        $xml_writer = new XMLWriter();
        $xml_writer->openMemory();
        $xml_writer->startDocument('1.0', 'UTF-8');
        $xml_writer->startElement("profile");
        $xml_writer->writeAttribute("name", $profile_name);
        $this->sip_profile_default_tags($xml_writer, $profile_name);
        foreach ($sip_profile->get_data_values(false) as $k => $v) {
            if ($k == "sip-ip") {
                // Get back ip from interface list
                $mgmt_if = $this->node()->hardware()->adapters(Safe_hardware_adapter_class::ETHERNET_ADAPTER);
                if (isset($mgmt_if) && isset($mgmt_if[$v]) && strlen($mgmt_if[$v]->ip_address())) {
                    $v = $mgmt_if[$v]->ip_address();
                } else {
                    // TODO(wadam) - We're in trouble...
                    $cfg_mgr->add_error('Validating', 'SIP profile ' . $profile_name . ' bind to interface ' . $v . ' without IP address.',
                    // TODO(wadam) - Redirect to Managment IF config page
                    //'/SAFe/ntg_sip_profiles/edit/'.$profile_name,
                    '/admin/network.php', 'Configure');
                    $v = '0.0.0.0';
                    //return false;
                    
                }
            }
            if ($k == "transport") {
                $this->write_transport_param($xml_writer, $v);
            } else {
                $xml_writer->startElement("param");
                $xml_writer->writeAttribute("name", $k);
                $xml_writer->writeAttribute("value", $v);
                $xml_writer->fullEndElement();
            }
        }
        // Include parameters common to all sip profile
        $xml_writer->startElement("X-PRE-PROCESS");
        $xml_writer->writeAttribute("cmd", "include");
        $xml_writer->writeAttribute("data", "common/common.xml");
        $xml_writer->fullEndElement();
        // Include profile partial definition files (media profile, proxy profile,
        // etc.) that are located in sip_profiles/profile_name/
        $xml_writer->startElement("X-PRE-PROCESS");
        $xml_writer->writeAttribute("cmd", "include");
        $xml_writer->writeAttribute("data", $profile_name . "/media*.xml");
        $xml_writer->fullEndElement();
        $xml_writer->fullEndElement(); //end settings tag
        $xml_writer->fullEndElement(); //end profile tag
        $xml_writer->endDocument();
        $xmlstr = Safe_format_xml($xml_writer->outputMemory(true));
        $file = "sip_profiles/" . $profile_name . ".xml";
        $cfg_mgr->add_config(new Safe_configuration_class($file, $xmlstr));
        return true;
    }
    private function sip_profile_default_tags(&$xml_writer, $profile_name)
    {
        // Include proxy information
        $xml_writer->startElement("gateways");
        $xml_writer->startElement("X-PRE-PROCESS");
        $xml_writer->writeAttribute("cmd", "include");
        $xml_writer->writeAttribute("data", $profile_name . "/gateways/*.xml");
        $xml_writer->fullEndElement();
        $xml_writer->fullEndElement();
        $xml_writer->startElement("domains");
        $xml_writer->startElement("domain");
        $xml_writer->writeAttribute("name", "all");
        $xml_writer->writeAttribute("alias", "false");
        $xml_writer->writeAttribute("parse", "true");
        $xml_writer->fullEndElement();
        $xml_writer->fullEndElement();
        // Open settings tag
        $xml_writer->startElement("settings");
        $xml_writer->startElement("param");
        $xml_writer->writeAttribute("name", "context");
        $xml_writer->writeAttribute("value", $profile_name);
        $xml_writer->fullEndElement();
        $xml_writer->startElement("param");
        $xml_writer->writeAttribute("name", "dialplan");
        $xml_writer->writeAttribute("value", "XML");
        $xml_writer->fullEndElement();
    }
    private function write_transport_param(&$xml_writer, $transport_value)
    {
        if ($transport_value != "udptcp") {
            $xml_writer->startElement("param");
            $xml_writer->writeAttribute("name", "bind-params");
            $xml_writer->writeAttribute("value", "transport=" . $transport_value);
            $xml_writer->fullEndElement();
        }
    }
    private function write_media_profile(&$cfg_mgr, $media_profile)
    {
        if (preg_match("/inbound/i", $media_profile->name())) {
            $direction = "inbound";
            $vad_dir = "in";
        } else {
            $direction = "outbound";
            $vad_dir = "out";
        }
        $xml_writer = new XMLWriter();
        $xml_writer->openMemory();
        $xml_writer->startDocument('1.0', 'UTF-8');
        $xml_writer->startElement("include");
        $this->write_codec_str($xml_writer, $media_profile, $direction);
        foreach ($media_profile->get_data_values(false) as $k => $v) {
            if (preg_match("/codec/i", $k)) {
                continue;
            } else if ($k == "negotiation") {
                $xml_writer->startElement("param");
                $xml_writer->writeAttribute("name", $direction . "-codec-" . $k);
                $xml_writer->writeAttribute("value", $v);
                $xml_writer->fullEndElement();
            } else if ($k == "silence-supp" && "true" == $v) {
                $xml_writer->startElement("param");
                $xml_writer->writeAttribute("name", "vad");
                $xml_writer->writeAttribute("value", $vad_dir);
                $xml_writer->fullEndElement();
            } else {
                // Other parameters are not supported for now. Skip them.
                /*
                $xml_writer->startElement("param");
                $xml_writer->writeAttribute("name", $k);
                $xml_writer->writeAttribute("value", $v);
                $xml_writer->fullEndElement();
                */
            }
        }
        $xml_writer->fullEndElement(); //end include tag
        $xml_writer->endDocument();
        if (strpos($media_profile->name() , "internal")) {
            $sip_prof_name = "internal";
        } else if (strpos($media_profile->name() , "external")) {
            $sip_prof_name = "external";
        } else {
            $sip_prof_name = "unknown";
        }
        $xmlstr = Safe_format_xml($xml_writer->outputMemory(true));
        $file = "sip_profiles/" . $sip_prof_name . "/media_" . $media_profile->name() . ".xml";
        $cfg_mgr->add_config(new Safe_configuration_class($file, $xmlstr));
        return true;
    }
    private function write_codec_str(&$xml_writer, $media_profile, $direction)
    {
        $codec_str = "";
        foreach ($media_profile->get_data_values(false) as $k => $v) {
            if (preg_match("/codec/i", $k)) {
                if ($v != "none") {
                    if ($codec_str == "") {
                        $codec_str = $v;
                    } else {
                        $codec_str = $codec_str . "," . $v;
                    }
                }
            }
        }
        $xml_writer->startElement("param");
        $xml_writer->writeAttribute("name", $direction . "-codec-prefs");
        $xml_writer->writeAttribute("value", $codec_str);
        $xml_writer->fullEndElement();
    }
    private function write_proxy_profile(&$cfg_mgr, $proxy_profile)
    {
        $name = $proxy_profile->name();
        $xml_writer = new XMLWriter();
        $xml_writer->openMemory();
        $xml_writer->startDocument('1.0', 'UTF-8');
        $xml_writer->startElement("include");
        if ("true" == $proxy_profile->get_data_value("enable-proxy", false)) {
            $xml_writer->startElement("gateway");
            $xml_writer->writeAttribute("name", $name);
            // !-! jpboily: for now, we will use the profile name as the proxy name
            //$xml_writer->writeAttribute("name", $proxy_profile->get_data_value("proxy-name"));
            foreach ($proxy_profile->get_data_values(false) as $k => $v) {
                if ($k == "enable-proxy" || $k == "proxy-name") {
                    continue;
                } else {
                    $xml_writer->startElement("param");
                    $xml_writer->writeAttribute("name", $k);
                    $xml_writer->writeAttribute("value", $v);
                    $xml_writer->fullEndElement();
                }
            }
            $xml_writer->startElement("param");
            $xml_writer->writeAttribute("name", "caller-id-in-from");
            $xml_writer->writeAttribute("value", "true");
            $xml_writer->fullEndElement();
            $xml_writer->fullEndElement();
        }
        $xml_writer->fullEndElement(); //end include tag
        $xml_writer->endDocument();
        // TODO - For now, the proxy profile name is assumed to be the same as the
        // sip profile it is associated to. When this behavior changes, we need to
        // modify this.
        $xmlstr = Safe_format_xml($xml_writer->outputMemory(true));
        $file = "sip_profiles/" . $name . "/gateways/" . $name . ".xml";
        $cfg_mgr->add_config(new Safe_configuration_class($file, $xmlstr));
        return true;
    }
    private function write_dialplan(&$cfg_mgr, $dialplan_info)
    {
        $xml_writer = new SimpleXMLElement("<?xml version=\"1.0\"?><include></include>");
        foreach ($dialplan_info as $sip_profile_name => $proxy_name) {
            $outbound_name = "unknown_profile";
            if ($sip_profile_name == "internal") $outbound_name = "external";
            elseif ($sip_profile_name == "external") $outbound_name = "internal";
            // Check if we have a proxy in this context
            if ($proxy_name != "") {
                $expr = "^(.*)@.*$";
                $bridge = "sofia/gateway/" . $outbound_name . "/$1";
            } else {
                $expr = "^(.*)$";
                $bridge = "sofia/" . $outbound_name . "/$1";
            }
            $this->write_dialplan_context($xml_writer, $sip_profile_name, $expr, $bridge);
        }
        $xmlstr = Safe_format_xml($xml_writer->asXML());
        $file = "dialplan/default.xml";
        $cfg_mgr->add_config(new Safe_configuration_class($file, $xmlstr));
        return true;
    }
    private function write_dialplan_context(&$xml_writer, $context, $expr, $bridge_value)
    {
        $ctx = $xml_writer->addChild("context");
        $ctx->addAttribute("name", $context);
        $ext = $ctx->addChild("extension");
        $ext->addAttribute("name", "sip_uri");
        $cond = $ext->addChild("condition");
        $cond->addAttribute("field", "\${sip_req_uri}");
        $cond->addAttribute("expression", $expr);
        $act1 = $cond->addChild("action");
        $act1->addAttribute("application", "set");
        $act1->addAttribute("data", "sdp_m_per_ptime=false");
        $act1 = $cond->addChild("action");
        $act1->addAttribute("application", "set");
        $act1->addAttribute("data", "media_server=true");
        // 2012-04-30 - Reverving fix for issue
        // 3718 - Don't propagate SIP-X-NTG headers from inbound to outbounda
        // Remove SNG/NTG X-headers
        //$act1 = $cond->addChild("action");
        //$act1->addAttribute("application","unset");
        //$act1->addAttribute("data","sip_h_X-SNG-Outbound-audio-codec-list");
        $act2 = $cond->addChild("action");
        $act2->addAttribute("application", "bridge");
        $act2->addAttribute("data", "[sdp_m_per_ptime=false]" . $bridge_value);
        $act3 = $cond->addChild("action");
        $act3->addAttribute("application", "answer");
    }
}
/* End of file ntg_application_class.php */
