<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * SNG Firewall Linux service wrapper
 *
 * @author William Adam
 * @version
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
safe_require_class('service');
class Sng_firewall_service_class extends Safe_service_class
{
    public function __construct($software, $name, $process_name = null)
    {
        parent::__construct($software, $name, $process_name);
    }
    public function can_restore(&$reason)
    {
        // Prevent calling parent as service status will be checked
        return true;
    }
    // Overloaded service status to check for running file created by
    // firewall.hooks
    public function status(&$stats = null)
    {
        if (!isset($stats)) $stats = array();
        $name = strtolower($this->node()->software()->application()->name());
        $stat_file = $this->node()->os()->stat_file('/var/run/' . $name . '.firewall.running');
        if ($stat_file) $status = Safe_service_class::STATUS_RUNNING;
        else $status = Safe_service_class::STATUS_STOPPED;
        if (isset($stats)) {
            $stats['process'] = 'N/A';
            if (isset($stat_file[9])) {
                $uptime = time() - $stat_file[9];
                $days = '';
                if ($uptime > 24 * 60 * 60) {
                    $days = (int)($uptime / (24 * 60 * 60));
                    $days = ((string)$days) . '-';
                    $uptime = $uptime - ($days * (24 * 60 * 60));
                }
                $uptime = date('H:i:s', $uptime);
                $stats['cputime'] = $days . $uptime;
            } else $stats['cputime'] = 'N/A';
            $stats['%cpu'] = 'N/A';
            $stats['%mem'] = 'N/A';
        }
        return $status;
    }
}
/* End of file sng_firewall_service_class.php */
