<?php

/**
 * FS Radius Configuration Class
 * @author: Shaunt Libarian
 */

require_once('application/helpers/safe_helper.php');
safe_require_class('object');
safe_require_class('hardware');
safe_module_require_class('nsc','application');
safe_module_require_class('fs','radius_vsas_config');
safe_module_require_class('fs','radius_module');
safe_module_require_class('sng','transcoding_config');

class Fs_radius_config_class extends Safe_configurable_object_class {
	
	
	public function __construct($node, $parent_name,$name) {
		// Parent constructor to invoke unserialize if needed
		parent::__construct($parent_name, "radius", $node);
	}
	
	public function configure() {
	    // Default interface name
	    $def_if = '';
	    // Populate IP enumeration with all management interface IP
	    $transcoding_mode = new Sng_transcoding_config_class($this->_node);
	    $adapter_type = $transcoding_mode->adapter_type();
	
	    $mgmt_if = $this->_node->hardware()->adapters($adapter_type);
	    $if_enum = array();
	    foreach($mgmt_if as $if_name=>$if) {
	      if(strlen($if->ip_address()))
	      {
	        if(!strlen($def_if))
	          $def_if = $if->name();
	
	        $if_enum[$if->name()] = $if->name() . ' - ' . $if->ip_address();
	      }
	    }
	    // We must have at least one entry or we're in trouble
	    if(!strlen($if_enum)){
	      // TODO(wadam) - Do something
	    }
		
		$this->add_field('authserver','Radius Server Address','string','localhost', 50);
		$this->set_field_rules('authserver','required|valid_ip_or_domain');
		$this->set_field_help('authserver','The domain name or IP address of the Radius Server.');
		
		$this->add_field('auth_port','Authentication Port','string','1812',10);
		$this->set_field_rules('auth_port','required|greater_than[1]|less_than[65535]');
		$this->set_field_help('auth_port','The authentication and authorization port of the Radius Server.');
		
		$this->add_field('shared-secret','Radius Shared Secret','string','testing123',60);
		$this->set_field_rules('shared-secret','required|alpha-dash');
		$this->set_field_help('shared-secret','Encryption password used by the Radius Server');
		
		$this->add_field('default_realm','Authentication Realm','string','',60);
		$this->set_field_rules('default_realm','valid_ip_or_domain');
		$this->set_field_help('default_realm','Default authentication realm to append all usernames. The realm identifies where the receiving Radius server should forward the AAA requests.');
		
		$this->add_field('radius_timeout','Radius Timeout','string','10',10);
		$this->set_field_help('radius_timeout','Time to wait for a reply from the Radius server');
		$this->set_field_rules('radius_timeout','required|greater_than[3]|less_than[180]');
		
		$this->add_field('radius_retries','Request Retries','string','3',10);
		$this->set_field_rules('radius_retries','required|greater_than[0]|less_than[20]');
		$this->set_field_help('radius_retries','Number of times to retry the Radius server in seconds.');
		
		$this->add_enum_field('bindaddr', 'Bind Local IP address', 'dropdown', $def_if, $if_enum);
		$this->set_field_help('bindaddr','IP Address from which Radius packets have been sent to..');
		
		$this->add_enum_field('enable-accounting', 'Radius Server Accounting','dropdown', 'false', $this->enable_disable_enum());
		$this->set_field_help('enable-accounting','Enable or Disable Radius accounting service.');
		
		/*$this->add_field('acctserver','Radius Accounting Server Address','string','localhost', 50);
		$this->set_field_rules('acctserver','required|valid_ip_or_domain');
		$this->set_field_help('acctserver','The domain name or IP address of the Radius Accounting Server.');*/
		
		$this->add_field('acct-port','Radius Accounting Port','string','1813',10);
		$this->set_field_rules('acct-port','required[accounting]|greater_than[1]|less_than[65535]');
		$this->set_field_help('acct-port','The port being used for Radius Server Accounting.');
		
		$this->create_group('accounting', array('acct-port'));
		$this->conditional_control('enable-accounting','accounting');
		
		return parent::configure();
	}
	
	/**
	 * Set the module description within the sng_config_manager
	 * @see Safe_object_class::description()
	 */
	public function description() {
		$cfg = $this->get_data_values(false);

		if("" != $cfg['authserver'] && "" != $cfg['bindaddr'])
			return 'Enable';
		else
			return 'Disable';
	}
	
}


?>
