<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/*
 * FS Media module class
*/
require_once ('application/helpers/safe_helper.php');
safe_require_class('safe_service_class');
safe_module_require_class('fs', 'application');

class Fs_media_module_class extends Fs_module_class
{
    protected $_obj_base_path = '';
    private $_profiles = array();
    /**
     * @brief
     *           
     * @param[in out] $fs_app
     *           
     * @return
     */
    public function __construct($fs_app)
    {
        parent::__construct($fs_app, "media");
        $this->_obj_base_path = $fs_app->object_name().'/profile/media';
    }
    public function allow_rest(){
        return true;
    }
    /**
     * @brief
     *         
     * @return
     */
    public function configure()
    {
        // Set the module description
        $this->set_description("Media");
        // Expose aggregate obj
        $this->register_aggregate_object('profile',
            array(
                'name' => 'Profile',
                'dynamic' => true,
                'base_path' => $this->_obj_base_path,
                'methods' => array(
                    'create' => array(
                        'name' => 'Create',
                        'description' => 'Create a Media Profile',
                        'request' => 'POST',
                        ),
                    'retrieve' => array(
                        'name' => 'Retrieve',
                        'description' => 'Retrieve a Media Profile',
                        'request' => 'GET',
                        ),
                    'update' => array(
                        'name' => 'Update',
                        'description' => 'Update a Media Profile',
                        'request' => 'POST',
                        ),
                    'delete' => array(
                        'name' => 'Delete',
                        'description' => 'Delete a Media Profile',
                        'request' => 'POST',
                        ),
                    ),
            )
        );

        return parent::configure();
    }
    public function profiles()
    {
        $this->_profiles = $this->get_aggregate_objects('profile');
        // Check if default is created
        if(!$this->_profiles) {
            $v = $this->create_profile('default');
            $v->configure();
            $v->synch();
            $this->_profiles[$v->name()] = $v;
        }
        return $this->_profiles;
    }
    /**
     * @brief Create a media profile
     * Can be overloaded by specialized class to create different type of media
     * object
     *
     * @param[in out] $name
     *
     * @return
     */
    public function create_profile($name){
        return $this->api_create_profile($name);
    }

    /**
     * @brief Create config jobs for dialplan module
     *
     * @param[in out] $config_manager
     *
     * @return
     */
    public function reload_generate_config(&$config_manager, $obj_type=null)
    {
        if(!$this->_generate_config($config_manager)) return false;
        return parent::reload_generate_config($config_manager, $obj_type);
    }

    /**
     * @brief
     *
     * @param[in out] $obj_type
     *
     * @return
     */
    public function reload_clear_modified($obj_type=null)
    {
        // the hard way :)
        Safe_object_serializer_class::get_serializer()->clear_modified($this->_obj_base_path, true);
    }

    /**
     * @brief
     *
     * @param[in out] $config_manager
     *
     * @return
     */
    public function generate_config(&$config_manager)
    {
        if(!$this->_generate_config($config_manager)) return false;
        return parent::generate_config($config_manager);
    }
    /**
     * @brief
     *
     * @param[in out] $config_manager
     *
     * @return
     */
    private function _generate_config(&$config_manager)
    {
        // Media profile configuration
        if (!$this->profiles()) {
            // At least one media profile is required
            $config_manager->add_error('Validating', 'No Media profile defined.');
        }
        // Cleanup
        // Handle deleted media profiles
        $deleted_media = Safe_object_serializer_class::get_serializer()->find_deleted_objects(
          $this->_obj_base_path);
        foreach ($deleted_media as $media => $value) {
            // Delete directory
            $directory = 'media_profiles/' . $media;
            $config_manager->add_config(
                new Safe_configuration_class(
                    $directory, '',
                    Safe_configuration_class::CFG_DELETE,
                    Safe_configuration_class::CFG_DIR));
        }
        // Write profiles
        foreach($this->profiles() as $profile) {
            if (!$this->_write_profile($config_manager, $profile, "inbound")
                || !$this->_write_profile($config_manager, $profile, "outbound")) {
                return false;
            }
        }

        return true;
    }
    /**
     * @brief Invoked after a successfull write_config
     *
     * @return
     */
    public function post_write_config()
    {
        // Reload configuration
        if(!$this->fs_app()->reloadxml()) return false;
        return parent::post_write_config();
    }
    /**
        * @brief
        *
        * @param[in out] $cfg_mgr
        * @param[in out] $media_profile
        * @param[in out] $direction
        *
        * @return
     */
    private function _write_profile(&$cfg_mgr, $media_profile, $direction)
    {
        if ($direction == "inbound") {
            $vad_dir = "in";
        } else {
            $vad_dir = "out";
        }
        $xml_writer = new XMLWriter();
        $xml_writer->openMemory();
        $xml_writer->startDocument('1.0', 'UTF-8');
        $xml_writer->startElement("include");
        $this->_write_codec_str($cfg_mgr, $xml_writer, $media_profile, $direction);
        foreach ($media_profile->get_data_values(false) as $k => $v) {
            if (preg_match("/codec/i", $k)) {
                continue;
            } else if ($k == "negotiation") {
                $xml_writer->startElement("param");
                $xml_writer->writeAttribute("name", $direction . "-codec-" . $k);
                $xml_writer->writeAttribute("value", $v);
                $xml_writer->EndElement();
            } else if ($k == "dtmf-type") {
                $xml_writer->startElement("variables");
                $xml_writer->startElement("variable");
                $xml_writer->writeAttribute("direction", $direction);
                $xml_writer->writeAttribute("name", "dtmf_type");
                $xml_writer->writeAttribute("value", $v);
                $xml_writer->EndElement();
                $xml_writer->fullEndElement();
            } else if ($k == "silence-supp" && "true" == $v) {
                $xml_writer->startElement("param");
                $xml_writer->writeAttribute("name", "vad");
                $xml_writer->writeAttribute("value", $vad_dir);
                $xml_writer->EndElement();
            } else {
                // Other parameters are not supported for now. Skip them.
                /*
                        $xml_writer->startElement("param");
                        $xml_writer->writeAttribute("name", $k);
                        $xml_writer->writeAttribute("value", $v);
                        $xml_writer->fullEndElement();
                */
            }
        }
        $xml_writer->fullEndElement(); //end include tag
        $xml_writer->endDocument();
        $xmlstr = Safe_format_xml($xml_writer->outputMemory(true));
        $file = "media_profiles/" . $media_profile->name() . "/" . $direction . ".xml";
        $cfg_mgr->add_config(new Safe_configuration_class($file, $xmlstr));
        return true;
    }
    /**
        * @brief
        *
        * @param[in out] $cfg_mgr
        * @param[in out] $xml_writer
        * @param[in out] $media_profile
        * @param[in out] $direction
        *
        * @return
     */
    private function _write_codec_str(&$cfg_mgr, &$xml_writer, $media_profile, $direction)
    {
        $codec_str = "";
        $transcoding_status = new Sng_transcoding_config_class($this->node());
        foreach ($media_profile->get_data_values(false) as $k => $v) {
            if (preg_match("/codec/i", $k)) {
                if ($v != "none") {
                    //Check if codec allowed. If not allowd, throw error
                    if (!$transcoding_status->transcoder_media_check($v, $media_profile)) {
                        //add error and exit configuration
                        $cfg_mgr->add_error('Validating', 'Media Codec ' . $v . ' is not currently available.', '/SAFe/nsc_media_profiles/' . $media_profile, 'Adjust Media Profile');
                    }
                    if ($codec_str == "") {
                        $codec_str = $v;
                    } else {
                        $codec_str = $codec_str . "," . $v;
                    }
                }
            }
        }
        $xml_writer->startElement("param");
        $xml_writer->writeAttribute("name", $direction . "-codec-prefs");
        $xml_writer->writeAttribute("value", $codec_str);
        $xml_writer->EndElement();
    }
    /**
     * @brief get the profile obj by name
     *
     * @param string $profile_name (profile name)
     *
     * @return
     */
    public function get_profile($profile_name){
        $profiles = $this->profiles();
        if (isset( $profiles[$profile_name])){
            return $profiles[$profile_name];
        }else{
            $media_profile = $this->create_profile($profile_name);
            $media_profile->configure();
            return $media_profile;
        }
    }
    /**
     * @brief 
     *
     * @param[in out] $name
     * @param[in out] $data
     * @param[in out] $output
     *
     * @return 
     */
    public function api_create_profile($name, $data=null, &$output = null) {
        $profile = new Fs_media_class($this->node(), $this->_obj_base_path, $name);
        $profile->configure();
        if($data) {
            $profile->set_data_values($data);
        }
        return $profile;
    }
    /**
     * @brief 
     *
     * @param[in out] $name
     * @param[in out] $data
     * @param[in out] $output
     *
     * @return 
     */
    public function api_retrieve_profile($name, $data=null, &$output = null) {
        $profiles = $this->profiles();
        return $profiles[$name];
    }
    /**
     * @brief 
     *
     * @param[in out] $name
     * @param[in out] $data
     * @param[in out] $output
     *
     * @return 
     */
    public function api_update_profile($name, $data = null, &$output = null){
        $profile = $this->api_retrieve_profile($name);
        if($profile) {
            if ($profile->validate($data,$output)) {
                if (true == $profile->save()) {
                    return true;
                }
            }
        }
        return false;
    }
    /**
     * @brief 
     *
     * @param[in out] $name
     * @param[in out] $data
     * @param[in out] $output
     *
     * @return 
     */
    public function api_delete_profile($name, $data=null, &$output = null) {
        $profile = $this->api_retrieve_profile($name);
        if($profile) {
            if($profile->can_dispose($output)) {
                return $profile->dispose();
            }
        }
        return false;
    }

}
/* End of file fs_sip_profile_module_class.php */

