<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
 */
/**
 * FS LCR Module Class
 * @author William Adam
 */

require_once('application/helpers/safe_helper.php');
safe_require_class('safe_service_class');
safe_module_require_class('fs','application');
safe_module_require_class('fs','lcr_carrier');

/**
 * @brief FS LCR module class
 */
class Fs_lcr_module_class extends Fs_module_class {

    protected $_obj_base_path = '';

    /**
     * @brief Array of configured domains
     */
    private $_carriers = array();

    /**
     * @brief Constructor
     *
     * @param[in out] $fs_app
     *
     * @return 
     */
    public function __construct($fs_app) {
        parent::__construct($fs_app, "lcr");
        $this->_obj_base_path = $fs_app->object_name().'/profile/carrier';
    }

    /**
     * @brief Directory module configuration
     *
     * @return 
     */
    public function configure() {
        // Set the module description
        $this->set_description("Least Cost Routing");

        // Register objects
        $this->register_aggregate_object('carrier',
            array(
                'name' => 'Carrier',
                'dynamic' => true,
                'base_path' => $this->_obj_base_path,
                'has_child' => true,
            )
        );

        return parent::configure();
    }

    /**
     * @brief Return existing carrier
     *
     * @return 
     */
    public function carriers(){
        $this->_carriers = $this->get_aggregate_objects('carrier');
        return $this->_carriers;
    }
    /**
     * @brief Invoked after a successfull write_config
     *
     * @return 
     */
    public function post_write_config()
    {
        // Reload configuration
        if(!$this->fs_app()->reloadxml()) return false;
        return parent::post_write_config();
    }

    /**
     * @brief Create config jobs for dialplan module
     *           
     * @param[in out] $config_manager
     *           
     * @return
     */
    public function reload_generate_config(&$config_manager, $obj_type=null)
    {
        if(!$this->_generate_config($config_manager)) return false;
        return parent::reload_generate_config($config_manager, $obj_type);
    }

    /**
     * @brief 
     *
     * @param[in out] $obj_type
     *
     * @return 
     */
    public function reload_clear_modified($obj_type=null)
    {
        // the hard way :)
        Safe_object_serializer_class::get_serializer()->clear_modified($this->_obj_base_path, true);
    }

    /**
     * @brief 
     *
     * @param[in out] $config_manager
     *
     * @return 
     */
    public function generate_config(&$config_manager)
    {
        if(!$this->_generate_config($config_manager)) return false;
        return parent::generate_config($config_manager);
    }
    /**
     * @brief 
     *
     * @param[in out] $config_manager
     *
     * @return 
     */
    private function _generate_config(&$config_manager)
    {
        // Cleanup
        //Handle LCR Rate Profiles
        $carriers = $this->carriers();
        foreach ($carriers as $profile) {
            $deleted_lcr_rate = Safe_object_serializer_class::get_serializer()->find_deleted_objects(
                $this->_obj_base_path. $profile->name() . '/rate');
            foreach ($deleted_lcr_rate as $lcr_rate => $value) {
                unset($data);
                $data['data'] = $value['data'];
                $data['db_class'] = $this->db($value['data']);
                $data['data']['lcr_profile'] = $lcr_rate;
                $data['primary_key'] = array(
                    'lcr_profile'
                );
                $config_manager->add_config(
                    new Safe_configuration_class(
                        'lcr', 
                        $data, 
                        Safe_configuration_class::CFG_DELETE, 
                        Safe_configuration_class::CFG_SQL));
            }
        }
        //Handle deleted Carrier Profile
        $deleted_carrier = Safe_object_serializer_class::get_serializer()->find_deleted_objects(
            $this->_obj_base_path);
        foreach ($deleted_carrier as $carrier_profile => $value) {
            unset($data);
            $data['data'] = $value['data'];
            $data['db_class'] = $this->db($value['data']);
            $data['data']['carrier_name'] = $carrier_profile;
            $data['primary_key'] = array(
                'carrier_name'
            );
            $config_manager->add_config(
                new Safe_configuration_class(
                    'carriers', 
                    $data, 
                    Safe_configuration_class::CFG_DELETE, 
                    Safe_configuration_class::CFG_SQL));
        }
        // Write carriers
        foreach($this->carriers() as $profile) {
            if (!$this->_write_carrier($config_manager, $profile)) { 
                return false;
            }
        }

        return true;
    }
    private function _write_carrier(&$config_manager, $profile)
    {
        //build data array
        unset($data);
        $db = $this->db($profile);
        $data['db_class'] = $db;
        $data['data'] = $profile->get_data_values(false);
        $data['data']['carrier_name'] = $profile->name();
        $data['data']['id'] = $profile->id();
        foreach ($data['data'] as $k => $v) {
            if (preg_match('"\bdb-cfg\b"', $k)) {
                unset($data['data'][$k]);
            }
        }
        //Determine whether to update or insert a rule
        $status = $profile->status();
        if ($status == Safe_object_serializer_class::OBJ_STATUS_MODIFIED) {
            $data['primary_key'] = array(
                'id'
            );
            $config_manager->add_config(new Safe_configuration_class('carriers', $data, Safe_configuration_class::CFG_UPDATE, Safe_configuration_class::CFG_SQL));
        } elseif ($status == Safe_object_serializer_class::OBJ_STATUS_NEW) {
            $config_manager->add_config(new Safe_configuration_class('carriers', $data, Safe_configuration_class::CFG_CREATE, Safe_configuration_class::CFG_SQL));
        }
        //Serialize Carrier Rates
        $rates = $profile->carrier_rate();
        if (isset($rates)) {
            foreach ($rates as $rate) {
                $status = $rate->status();
                $data['data'] = $rate->get_data_values(false);
                foreach ($data['data'] as $k => $v) {
                    if (preg_match('"\bdb-cfg\b"', $k)) {
                        unset($data['data'][$k]);
                    }
                    switch ($k) {
                    case 'date_start':
                        if (!strlen(trim($v))) $data['data'][$k] = '1970-01-01 00:00:00';
                        break;

                    case 'date_end':
                        if (!strlen(trim($v))) $data['data'][$k] = '2030-12-31 00:00:00';
                        break;
                    }
                }
                $data['data']['lcr_profile'] = $rate->name();
                $data['data']['id'] = $rate->id();
                $data['data']['carrier_id'] = $profile->id();
                //Determine whether to update or insert a rule
                if ($status == Safe_object_serializer_class::OBJ_STATUS_MODIFIED) {
                    $data['primary_key'] = array(
                        'id'
                    );
                    $config_manager->add_config(new Safe_configuration_class('lcr', $data, Safe_configuration_class::CFG_UPDATE, Safe_configuration_class::CFG_SQL));
                } elseif ($status == Safe_object_serializer_class::OBJ_STATUS_NEW) {
                    $config_manager->add_config(new Safe_configuration_class('lcr', $data, Safe_configuration_class::CFG_CREATE, Safe_configuration_class::CFG_SQL));
                }
            }
        }
        return true;
    }

}
?>
