<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * FS Dialplan Module Class
 * @author Shaunt Libarian
 */
require_once ('application/helpers/safe_helper.php');
safe_require_class('safe_service_class');
safe_module_require_class('fs', 'dialplan');
safe_module_require_class('fs', 'application');
safe_module_require_class('fs', 'advanced_dialplan');
class Fs_dialplan_module_class extends Fs_module_class
{
    private $_dialplans = array();
    public function __construct($fs_app)
    {
        parent::__construct($fs_app, "dialplan");
    }
    public function configure()
    {
        // Set the module description
        $this->set_description("Call Routing");
        // Register objects
        $this->register_aggregate_object('dialplan',
            array(
                'name' => 'Dialplan',
                'dynamic' => true,
                'base_path' => $this->object_name(),
            )
        );
        return parent::configure();
    }
    /**
     * @brief Create config jobs for dialplan module
     *           
     * @param[in out] $config_manager
     *           
     * @return
     */
    public function reload_generate_config(&$config_manager, $obj_type=null)
    {
        if(!$this->_generate_config($config_manager)) return false;
        return parent::reload_generate_config($config_manager, $obj_type);
    }

    public function reload_clear_modified($obj_type=null)
    {
        // the hard way :)
        Safe_object_serializer_class::get_serializer()->clear_modified($this->object_name() , true);
    }

    public function generate_config(&$config_manager)
    {
        if(!$this->_generate_config($config_manager)) return false;
        return parent::generate_config($config_manager);
    }
    private function _generate_config(&$config_manager)
    {
        // Delete all user dialplans
        $directory = "dialplan/user";
        $config_manager->add_config(new Safe_configuration_class($directory, '', Safe_configuration_class::CFG_DELETE, Safe_configuration_class::CFG_DIR));
        // Create user dialplans
        foreach ($this->dialplans() as $dialplan) {
            if (!$this->_write_user_dialplan($config_manager, $dialplan)) return false;
        }
        return true;
    }
    /**
     * @brief Invoked after a successfull write_config
     *         
     * @return
     */
    public function post_write_config()
    {
        // Reload configuration
        if(!$this->fs_app()->reloadxml()) return false;
        return parent::post_write_config();
    }
    /**
     * @brief Write user dialplan
     *           
     * @param[in out] $config_manager
     * @param[in out] $dialplan
     *           
     * @return
     */
    private function _write_user_dialplan(&$config_manager, $dialplan)
    {
        //Create core dialplan file for the sip profile
        $data = $dialplan->get_data_values(false);
        if ("advanced" == $dialplan->type()) {
            $xml_str = '<include><context name="user-' . $dialplan->name() . '">';
            $xml_str.= $data['data'];
            $xml_str.= '</context></include>';
            $xml_obj = simplexml_load_string($xml_str);
            $xmlstr = Safe_format_xml($xml_obj->asXml());
            $file = "dialplan/user/user-" . $dialplan->name() . ".xml";
            $config_manager->add_config(new Safe_configuration_class($file, $xmlstr));
        }
        return true;
    }
    /**
     * Returns all the dialplans
     */
    public function dialplans()
    {
        $this->_dialplans = $this->get_aggregate_objects('dialplan');
        return $this->_dialplans;
    }
    /**
     * @brief Create a dialplan object
     *           
     * @param[in out] $name : dialplan name
     * @param[in out] $type : advanced or basic
     *           
     * @return true on success
     */
    public function create_dialplan($name, $type = "advanced",$save=true)
    {
        $obj = null;
        switch ($type) {
        case "advanced":
            $obj = new Fs_advanced_dialplan_class($this->node() , $this->object_name() , $name);
            break;

        case "basic":
            break;
        }
        // Succeed to create dialplan ?
        if ($obj) {
            if ($save)
            {
                $obj->configure();
                $obj->synch();
                return true;
            }else
            {
                return $obj;
            }
            
        }
        return false;
    }
}
?>
