<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/*
 * FS CDR module class
*/
require_once ('application/helpers/safe_helper.php');
safe_require_class('safe_service_class');
safe_module_require_class('fs', 'application');
class Fs_cdr_config_class extends Safe_configurable_object_class
{
    /**
     * @brief Constructor
     *           
     * @param[in out] $parent_name
     * @param[in out] $name
     *           
     * @return
     */
    public function __construct($node, $parent_name)
    {
        parent::__construct($parent_name, "cdr");
    }
    /**
     * @brief Configure the config class object
     *         
     * @return
     */
    public function configure()
    {
        // local storage
        $this->add_enum_field('global/local', 'Local Storage', 'dropdown', 'false', $this->enable_disable_enum());
        // local storage hidden fields
        $this->add_field('local/log-dir', 'log-dir', 'hidden', '');
        // HTTP storage
        $this->add_enum_field('global/http', 'HTTP Storage', 'dropdown', 'false', $this->enable_disable_enum());
        // Add Conditional Control for global/http
        // 1. create the group control 'http'
        $this->create_group('http', array(
            'http/url',
            'http/retries',
            'http/delay'
        ));
        // 2. tell the field 'global/http' which existing group it can control (http)
        $this->conditional_control('global/http', 'http');
        $this->add_field('http/url', 'HTTP URL', 'string', '', 64);
        // Optionnaly validate url if HTTP storage is activated
        $this->set_field_rules('http/url', 'required[global/http]|valid_url');
        $this->add_field('http/retries', 'Number of Retries', 'int', 2);
        $this->set_field_rules('http/retries', 'required[global/http]|greater_than[0]');
        // Add help support for the field http/retries
        //$this->set_field_help('http/retries', 'HELP for http/retries!');
        $this->add_field('http/delay', 'Retry Delay', 'int', 5);
        $this->set_field_rules('http/delay', 'required[global/http]|greater_than[0]');
        // HTTP storage hidden fields
        $this->add_field('http/encode', 'encode', 'hidden', 'textxml');
        $this->add_field('http/log-http-and-disk', 'log-http-and-disk', 'hidden', 'true');
        $this->add_field('http/auth-scheme', 'auth-scheme', 'hidden', 'any');
        // common stuff (hidden)
        $this->add_field('common/log-b-leg', 'log-b-leg', 'hidden', 'false');
        $this->add_field('common/prefix-a-leg', 'prefix-a-leg', 'hidden', 'false');
        return parent::configure();
    }
    /**
     * @brief Returns a config description string
     *         
     * @return string
     */
    public function description()
    {
        // Get the data values (not enum resolved)
        $cfg = $this->get_data_values(false);
        // Any storage enabled ?
        if ('true' == $cfg['global/local'] || 'true' == $cfg['global/http']) {
            // Yes, so create a string stating which one is on and off
            $desc = "Enable: ";
            if ('true' == $cfg['global/local']) $desc.= 'Local ';
            if ('true' == $cfg['global/http']) $desc.= 'HTTP ';
            return $desc;
        } else {
            // No storage enabled
            return 'Disable';
        }
    }
}
class Fs_cdr_module_class extends Fs_module_class
{
    /**
     * @brief
     *           
     * @param[in out] $fs_app
     *           
     * @return
     */
    public function __construct($fs_app)
    {
        parent::__construct($fs_app, "cdr");
    }
    /**
     * @brief
     *         
     * @return
     */
    public function configure()
    {
        // Set the module description
        $this->set_description("CDR");
        // Create the config object
        $cfg = new Fs_cdr_config_class($this->node() , $this->fs_app()->object_name() , $this->name());
        // Synch with DB
        $cfg->configure();
        $cfg->synch();
        // Attach config to module
        $this->set_config($cfg);
        return parent::configure();
    }
    public function is_enabled($mod_name = "")
    {
        $cfg = $this->config()->get_data_values(false);
        if (!empty($cfg)) {
            if ('true' == $cfg['global/local'] || 'true' == $cfg['global/http']) return true;
            else return false;
        } else return false;
    }
    /**
     * @brief Return FS module name
     *         Overloaded because of xml_ prefix
     *         
     * @return string
     */
    public function get_fs_module_name()
    {
        return 'mod_xml_' . $this->name() . '.so';
    }
    /**
     * @brief
     *           
     * @param[in out] $config_manager
     *           
     * @return
     */
    public function generate_config(&$config_manager)
    {
        // Get our configuration data (unresolved)
        $cfg = $this->config()->get_data_values_exploded(false);
        // Check if local enabled
        if ('true' != $cfg['global']['local']) {
            // Remove local parameters
            unset($cfg['local']);
        }
        if ('true' != $cfg['global']['http']) {
            // Remove http parameters
            unset($cfg['http']);
        }
        // Remove global config
        unset($cfg['global']);
        // Create xml document
        $xml_writer = new XMLWriter();
        $xml_writer->openMemory();
        $xml_writer->startDocument('1.0', 'UTF-8');
        // Document container
        $xml_writer->startElement('configuration');
        $xml_writer->writeAttribute('name', 'xml_cdr.conf');
        $xml_writer->writeAttribute('description', 'XML CDR CURL logger');
        // Add all parameters
        $xml_writer->startElement('settings');
        foreach ($cfg as $category => $cat_cfg) {
            foreach ($cat_cfg as $k => $v) {
                $xml_writer->startElement('param');
                $xml_writer->writeAttribute('name', $k);
                $xml_writer->writeAttribute('value', $v);
                $xml_writer->fullEndElement();
            }
        }
        // Close settings
        $xml_writer->fullEndElement();
        $xml_writer->endDocument();
        $xmlstr = Safe_format_xml($xml_writer->outputMemory(true));
        $file = 'autoload_configs/xml_cdr.conf.xml';
        $config_manager->add_config(new Safe_configuration_class($file, $xmlstr));
        return parent::generate_config($config_manager);
    }
    public function get_data_settings()
    {
        $cfg_manager = $this->node()->configuration_manager();
        $data = array(
            'cdr' => array(
                'description' => 'Call Data Records',
                'filesystem' => true,
                'pattern' => $cfg_manager->directory('log') . '/xml_cdr/*.xml',
                'global_capabilities' => array(
                    'download',
                    'delete'
                ) ,
                'capabilities' => array(
                    'download',
                    'delete',
                    'view'
                )
            )
        );
        return $data;
    }
    public function get_data_file_key($data_name, $file)
    {
        // Only CDR available for now so don't bother with data_name
        $base = basename($file);
        $regex_pattern = "/(?P<key>.*)\.cdr\.xml/";
        preg_match($regex_pattern, $base, $match);
        return $match['key'];
    }
    function get_data_file_content_by_key($data_name, $key)
    {
        $cfg_manager = $this->node()->configuration_manager();
        $content = file_get_contents($cfg_manager->directory('log') . '/xml_cdr/' . $key . '.cdr.xml');
        return $content;
    }
}
/* End of file fs_application_class.php */
