#ifndef __Q931_CAUSE__
#define __Q931_CAUSE__


#define Q931_CAUSE_UNALLOCATED                           1
#define Q931_CAUSE_NO_ROUTE_TRANSIT_NET                  2
#define Q931_CAUSE_NO_ROUTE_DESTINATION                  3
#define Q931_CAUSE_CHANNEL_UNACCEPTABLE                  6
#define Q931_CAUSE_CALL_AWARDED_DELIVERED                7
#define Q931_CAUSE_NORMAL_CLEARING                      16
#define Q931_CAUSE_USER_BUSY                            17
#define Q931_CAUSE_NO_USER_RESPONSE                     18
#define Q931_CAUSE_NO_ANSWER                            19
#define Q931_CAUSE_CALL_REJECTED                        21
#define Q931_CAUSE_NUMBER_CHANGED                       22
#define Q931_CAUSE_DESTINATION_OUT_OF_ORDER             27
#define Q931_CAUSE_INVALID_NUMBER_FORMAT                28
#define Q931_CAUSE_FACILITY_REJECTED                    29
#define Q931_CAUSE_RESPONSE_TO_STATUS_ENQUIRY    	30
#define Q931_CAUSE_NORMAL_UNSPECIFIED                   31
#define Q931_CAUSE_NORMAL_CIRCUIT_CONGESTION            34
#define Q931_CAUSE_NETWORK_OUT_OF_ORDER                 38
#define Q931_CAUSE_NORMAL_TEMPORARY_FAILURE             41
#define Q931_CAUSE_SWITCH_CONGESTION                    42
#define Q931_CAUSE_ACCESS_INFO_DISCARDED                43
#define Q931_CAUSE_REQUESTED_CHAN_UNAVAIL               44
#define Q931_CAUSE_PRE_EMPTED                           45
#define Q931_CAUSE_FACILITY_NOT_SUBSCRIBED              50
#define Q931_CAUSE_OUTGOING_CALL_BARRED                 52
#define Q931_CAUSE_INCOMING_CALL_BARRED                 54
#define Q931_CAUSE_BEARERCAPABILITY_NOTAUTH             57
#define Q931_CAUSE_BEARERCAPABILITY_NOTAVAIL     	58
#define Q931_CAUSE_BEARERCAPABILITY_NOTIMPL             65
#define Q931_CAUSE_CHAN_NOT_IMPLEMENTED                 66
#define Q931_CAUSE_FACILITY_NOT_IMPLEMENTED      	69
#define Q931_CAUSE_INVALID_CALL_REFERENCE               81
#define Q931_CAUSE_INCOMPATIBLE_DESTINATION             88
#define Q931_CAUSE_INVALID_MSG_UNSPECIFIED              95
#define Q931_CAUSE_MANDATORY_IE_MISSING                 96
#define Q931_CAUSE_MESSAGE_TYPE_NONEXIST                97
#define Q931_CAUSE_WRONG_MESSAGE                        98
#define Q931_CAUSE_IE_NONEXIST                          99
#define Q931_CAUSE_INVALID_IE_CONTENTS               	100
#define Q931_CAUSE_WRONG_CALL_STATE                     101
#define Q931_CAUSE_RECOVERY_ON_TIMER_EXPIRE             102
#define Q931_CAUSE_MANDATORY_IE_LENGTH_ERROR            103
#define Q931_CAUSE_PROTOCOL_ERROR                       111

#define Q931_SCAUSE_SZ 100
typedef struct q931_cause_to_str
{
	int cause;
	char scause[Q931_SCAUSE_SZ];	
}q931_cause_to_str_t;

typedef struct q931_cause_to_str_array
{
	char scause[Q931_SCAUSE_SZ];	
}q931_cause_to_str_array_t;


q931_cause_to_str_t q931_cause2str[] = {

{Q931_CAUSE_UNALLOCATED, "CAUSE_UNALLOCATED" },
{Q931_CAUSE_NO_ROUTE_TRANSIT_NET,"NO_ROUTE_TRANSIT_NET"},
{Q931_CAUSE_NO_ROUTE_DESTINATION,"NO_ROUTE_DESTINATION"},
{Q931_CAUSE_CHANNEL_UNACCEPTABLE,"CHANNEL_UNACCEPTABLE"},
{Q931_CAUSE_CALL_AWARDED_DELIVERED,"CALL_AWARDED_DELIVERED"},
{Q931_CAUSE_NORMAL_CLEARING,"NORMAL_CLEARING"},
{Q931_CAUSE_USER_BUSY,"USER_BUSY"},
{Q931_CAUSE_NO_USER_RESPONSE,"NO_USER_RESPONSE"},
{Q931_CAUSE_NO_ANSWER,"NO_ANSWER"},
{Q931_CAUSE_CALL_REJECTED,"CALL_REJECTED"},
{Q931_CAUSE_NUMBER_CHANGED,"NUMBER_CHANGED"},
{Q931_CAUSE_DESTINATION_OUT_OF_ORDER,"DESTINATION_OUT_OF_ORDER"},
{Q931_CAUSE_INVALID_NUMBER_FORMAT,"INVALID_NUMBER_FORMAT"},
{Q931_CAUSE_FACILITY_REJECTED,"FACILITY_REJECTED"},
{Q931_CAUSE_RESPONSE_TO_STATUS_ENQUIRY,"RESPONSE_TO_STATUS_ENQUIRY"},
{Q931_CAUSE_NORMAL_UNSPECIFIED,"NORMAL_UNSPECIFIED"},
{Q931_CAUSE_NORMAL_CIRCUIT_CONGESTION,"NORMAL_CIRCUIT_CONGESTION"},
{Q931_CAUSE_NETWORK_OUT_OF_ORDER,"NETWORK_OUT_OF_ORDER"},
{Q931_CAUSE_NORMAL_TEMPORARY_FAILURE,"NORMAL_TEMPORARY_FAILURE"},
{Q931_CAUSE_SWITCH_CONGESTION,"SWITCH_CONGESTION"},
{Q931_CAUSE_ACCESS_INFO_DISCARDED,"ACCESS_INFO_DISCARDED"},
{Q931_CAUSE_REQUESTED_CHAN_UNAVAIL,"REQUESTED_CHAN_UNAVAIL"},
{Q931_CAUSE_PRE_EMPTED,"PRE_EMPTED"},
{Q931_CAUSE_FACILITY_NOT_SUBSCRIBED,"FACILITY_NOT_SUBSCRIBED"},
{Q931_CAUSE_OUTGOING_CALL_BARRED,"OUTGOING_CALL_BARRED"},
{Q931_CAUSE_INCOMING_CALL_BARRED,"INCOMING_CALL_BARRED"},
{Q931_CAUSE_BEARERCAPABILITY_NOTAUTH,"BEARERCAPABILITY_NOTAUTH"},
{Q931_CAUSE_BEARERCAPABILITY_NOTAVAIL,"BEARERCAPABILITY_NOTAVAIL"},
{Q931_CAUSE_BEARERCAPABILITY_NOTIMPL,"BEARERCAPABILITY_NOTIMPL"},
{Q931_CAUSE_CHAN_NOT_IMPLEMENTED,"CHAN_NOT_IMPLEMENTED"},
{Q931_CAUSE_FACILITY_NOT_IMPLEMENTED,"FACILITY_NOT_IMPLEMENTED"},
{Q931_CAUSE_INVALID_CALL_REFERENCE,"INVALID_CALL_REFERENCE"},
{Q931_CAUSE_INCOMPATIBLE_DESTINATION,"INCOMPATIBLE_DESTINATION"},
{Q931_CAUSE_INVALID_MSG_UNSPECIFIED,"INVALID_MSG_UNSPECIFIED"},
{Q931_CAUSE_MANDATORY_IE_MISSING,"MANDATORY_IE_MISSING"},
{Q931_CAUSE_MESSAGE_TYPE_NONEXIST,"MESSAGE_TYPE_NONEXIST"},
{Q931_CAUSE_WRONG_MESSAGE,"WRONG_MESSAGE"},
{Q931_CAUSE_IE_NONEXIST,"IE_NONEXIST"},
{Q931_CAUSE_INVALID_IE_CONTENTS,"INVALID_IE_CONTENTS"},
{Q931_CAUSE_WRONG_CALL_STATE,"WRONG_CALL_STATE"},
{Q931_CAUSE_RECOVERY_ON_TIMER_EXPIRE,"RECOVERY_ON_TIMER_EXPIRE"},
{Q931_CAUSE_MANDATORY_IE_LENGTH_ERROR,"MANDATORY_IE_LENGTH_ERROR"},
{Q931_CAUSE_PROTOCOL_ERROR,"PROTOCOL_ERROR"},
{255,"UNKOWN"},

};

extern q931_cause_to_str_array_t q931_cause_to_str_array[];

static inline void q931_cause_setup(void)
{
	int i=0;
	
	for (i=0;i<255;i++) {
		strncpy(q931_cause_to_str_array[i].scause,"UNKNOWN", Q931_SCAUSE_SZ-1);
	}
	
	for (i=0;i<255;i++) {
		if (q931_cause2str[i].cause == 255) {
			break;
		}
		
		strncpy(q931_cause_to_str_array[q931_cause2str[i].cause].scause,
		        q931_cause2str[i].scause,
			Q931_SCAUSE_SZ-1);	
	}
#if 0
	for (i=0; i< 255;i++) {
		log_printf(0,server.log,"CAUSE=%i, SCAUSE=%s\n",
			i, q931_cause_to_str_array[i].scause);
	}
#endif
}
static inline char *q931_rel_to_str(int cause)
{
	if (cause < 0 || cause >= 255) {
		return "UNKNOWN";
	}

#if 0
	log_printf(0,server.log, "%s:%d: CAUSE = %i SCAUSE=%s\n",
			__FUNCTION__,__LINE__,cause,q931_cause_to_str_array[cause].scause);
#endif
	return q931_cause_to_str_array[cause].scause;
}




#endif
