/******************************************************************************
 * 
 * sdla_te3_reg.h	Sangoma T3/E3 registry definitions.
 * 	
 * 		Alex Feldman <al.feldman@sangoma.com>
 * 		
 * 	Copyright Sangoma Technologies Inc. 1999, 2000,2001, 2002, 2003, 2004
 *
 * 	This program is provided subject to the Software License included in 
 * 	this package in the file license.txt. By using this program you agree
 * 	to be bound bythe terms of this license. 
 *
 * 	Should you not have a copy of the file license.txt, or wish to obtain
 * 	a hard copy of the Software License, please contact Sangoma
 * 	technologies Corporation.
 *
 * 	Contact: Sangoma Technologies Inc. 905-474-1990, info@sangoma.com
 *
 *****************************************************************************/

#ifndef __SDLA_TE3_REG_H
# define __SDLA_TE3_REG_H


/* T3/E3 Line Interface Unit registers */
#define REG_APS				0x00

#define REG_INTR_ENABLE			0x01
#define BIT_INTR_ENABLE_CNT_SATIE	0x20
#define BIT_INTR_ENABLE_PRBSIE		0x10
#define BIT_INTR_ENABLE_FLIE		0x08
#define BIT_INTR_ENABLE_RLOLIE		0x04
#define BIT_INTR_ENABLE_RLOSIE		0x02
#define BIT_INTR_ENABLE_DMOIE		0x01

#define REG_INTR_STATUS			0x02
#define BIT_INTR_ENABLE_CNT_SATIS	0x20
#define BIT_INTR_ENABLE_PRBSIS		0x10
#define BIT_INTR_ENABLE_FLIS		0x08
#define BIT_INTR_ENABLE_RLOLIS		0x04
#define BIT_INTR_ENABLE_RLOSIS		0x02
#define BIT_INTR_ENABLE_DMOIS		0x01

#define REG_ALARM_STATUS		0x03
#define BIT_ALARM_STATUS_PRBSLS		0x40
#define BIT_ALARM_STATUS_DLOS		0x20
#define BIT_ALARM_STATUS_ALOS		0x10
#define BIT_ALARM_STATUS_FL		0x08
#define BIT_ALARM_STATUS_RLOL		0x04
#define BIT_ALARM_STATUS_RLOS		0x02
#define BIT_ALARM_STATUS_DMO		0x01

#define REG_TRANSMIT_CTRL		0x04
#define BIT_TRANSMIT_CTRL_TxMON		0x20
#define BIT_TRANSMIT_CTRL_INSPRBS	0x10
#define BIT_TRANSMIT_CTRL_TAOS		0x04
#define BIT_TRANSMIT_CTRL_TxClkINV	0x02
#define BIT_TRANSMIT_CTRL_TxLEV		0x01

#define REG_RECEIVE_CTRL		0x05
#define BIT_RECEIVE_CTRL_DLOSDIS	0x20 
#define BIT_RECEIVE_CTRL_ALOSDIS	0x10
#define BIT_RECEIVE_CTRL_RxClkINV	0x08
#define BIT_RECEIVE_CTRL_LOSMUT		0x04
#define BIT_RECEIVE_CTRL_RxMIN		0x02
#define BIT_RECEIVE_CTRL_REQEN		0x01

#define REG_BLOCK_CTRL			0x06
#define BIT_BLOCK_CTRL_PRBSEN		0x20
#define BIT_BLOCK_CTRL_RLB		0x10
#define BIT_BLOCK_CTRL_LLB		0x08
#define BIT_BLOCK_CTRL_E3		0x04
#define BIT_BLOCK_CTRL_STS1		0x02
#define BIT_BLOCK_CTRL_SR		0x01

#define REG_JITTER_ATTENUATOR		0x07
#define BIT_JITTER_ATTENUATOR_PNTRST	0x08
#define BIT_JITTER_ATTENUATOR_JA1	0x04
#define BIT_JITTER_ATTENUATOR_JAT	0x02
#define BIT_JITTER_ATTENUATOR_JA0	0x01

#define REG_GLOBAL_INTR_ENABLE		0x20
#define BIT_GLOBAL_INTR_ENABLE_INTEN	0x01

#define REG_GLOBAL_INTR_STATUS		0x21
#define BIT_GLOBAL_INTR_STATUS_INTST	0x01

#define REG_PRBS_ERROR_CNT_MSB		0x30
#define BIT_PRBS_ERROR_CNT_MSB_MSB	0x80
#define BIT_PRBS_ERROR_CNT_MSB_LSB	0x01

#define REG_PRBS_ERROR_CNT_LSB		0x31
#define BIT_PRBS_ERROR_CNT_LSB_MSB	0x80
#define BIT_PRBS_ERROR_CNT_LSB_LSB	0x01

#define REG_PRBS_HOLDING		0x38
#define BIT_PRBS_HOLDING_MSB		0x80
#define BIT_PRBS_HOLDING_LSB		0x01

#define REG_CHIP_ID			0x3E
#define REG_CHIP_VERSION		0x3F

/* T3/E3 Framer registers */
#define REG_OPMODE			0x00
#define BIT_OPMODE_LOCAL_LB		0x80
#define BIT_OPMODE_DS3			0x40
#define BIT_OPMODE_INTERNAL_LOS		0x20
#define BIT_OPMODE_RESET		0x10
#define BIT_OPMODE_INT_ENABLE_RESET	0x08
#define BIT_OPMODE_FRAME_FRMT		0x04
#define BIT_OPMODE_TIMREFSEL1		0x02
#define BIT_OPMODE_TIMREFSEL0		0x01

#define REG_IO_CONTROL			0x01
#define BIT_IO_CONTROL_DISABLE_TXLOC	0x80
#define BIT_IO_CONTROL_LOC_STATUS	0x40
#define BIT_IO_CONTROL_DISABLE_RXLOC	0x20
#define BIT_IO_CONTROL_AMI		0x10
#define BIT_IO_CONTROL_UNIPOLAR		0x08
#define BIT_IO_CONTROL_TxLINECLK	0x04
#define BIT_IO_CONTROL_RxLINECLK	0x02
#define BIT_IO_CONTROL_REFRAME		0x01

#define REG_PART_NUMBER			0x02

#define REG_VERSION_NUMBER		0x03

#define REG_BLOCK_INT_ENABLE		0x04
#define BIT_BLOCK_INT_ENABLE_RxDS3_E3	0x80
#define BIT_BLOCK_INT_ENABLE_TxDS3_E3	0x02
#define BIT_BLOCK_INT_ENABLE_1SEC_INT	0x01

#define REG_BLOCK_INT_STATUS		0x05
#define BIT_BLOCK_INT_STATUS_RxDS3_E3	0x80
#define BIT_BLOCK_INT_STATUS_TxDS3_E3	0x02
#define BIT_BLOCK_INT_STATUS_1SEC_INT	0x01

/* Receive DS3 */
#define REG_RxDS3_CFG_STATUS		0x10
#define BIT_RxDS3_CFG_STATUS_RxAIS	0x80
#define BIT_RxDS3_CFG_STATUS_RxLOS	0x40
#define BIT_RxDS3_CFG_STATUS_RxIDLE	0x20
#define BIT_RxDS3_CFG_STATUS_RxOOF	0x10
#define BIT_RxDS3_CFG_STATUS_FRAMING	0x04
#define BIT_RxDS3_CFG_STATUS_FSYNC_ALGO	0x02
#define BIT_RxDS3_CFG_STATUS_MSYNC_ALGO	0x01

#define REG_RxDS3_STATUS		0x11
#define BIT_RxDS3_STATUS_RxFERF		0x10
#define BIT_RxDS3_STATUS_RxAIC		0x08
#define BIT_RxDS3_STATUS_RxFEBE2	0x04
#define BIT_RxDS3_STATUS_RxFEBE1	0x02
#define BIT_RxDS3_STATUS_RxFEBE0	0x01

#define REG_RxDS3_INT_ENABLE		0x12
#define BIT_RxDS3_INT_ENABLE_CPBIT_ERR	0x80
#define BIT_RxDS3_INT_ENABLE_LOS	0x40
#define BIT_RxDS3_INT_ENABLE_AIS	0x20
#define BIT_RxDS3_INT_ENABLE_IDLE	0x10
#define BIT_RxDS3_INT_ENABLE_FERF	0x08
#define BIT_RxDS3_INT_ENABLE_AIC	0x04
#define BIT_RxDS3_INT_ENABLE_OOF	0x02
#define BIT_RxDS3_INT_ENABLE_PBIT_ERR	0x01

#define REG_RxDS3_INT_STATUS		0x13
#define BIT_RxDS3_INT_STATUS_CPBIT_ERR	0x80
#define BIT_RxDS3_INT_STATUS_LOS	0x40
#define BIT_RxDS3_INT_STATUS_AIS	0x20
#define BIT_RxDS3_INT_STATUS_IDLE	0x10
#define BIT_RxDS3_INT_STATUS_FERF	0x08
#define BIT_RxDS3_INT_STATUS_AIC	0x04
#define BIT_RxDS3_INT_STATUS_OOF	0x02
#define BIT_RxDS3_INT_STATUS_PBIT_ERR	0x01

/* Receive E3, ITU-T G.832 */
#define REG_RxE3_CFG_STATUS_1		0x10
#define BIT_RxE3_CFG_STATUS_RxPLDType2	0x80
#define BIT_RxE3_CFG_STATUS_RxPLDType1	0x40
#define BIT_RxE3_CFG_STATUS_RxPLDType0	0x20
#define BIT_RxE3_CFG_STATUS_RxFERF_ALGO	0x10
#define BIT_RxE3_CFG_STATUS_RxTMARK_ALGO	0x08
#define BIT_RxE3_CFG_STATUS_RxPLDExp2	0x80
#define BIT_RxE3_CFG_STATUS_RxPLDExp1	0x40
#define BIT_RxE3_CFG_STATUS_RxPLDExp0	0x20

#define REG_RxE3_CFG_STATUS_2		0x11
#define BIT_RxE3_CFG_STATUS_RxLOF_ALGO	0x80
#define BIT_RxE3_CFG_STATUS_RxLOF	0x40
#define BIT_RxE3_CFG_STATUS_RxOOF	0x20
#define BIT_RxE3_CFG_STATUS_RxLOS	0x10
#define BIT_RxE3_CFG_STATUS_RxAIS	0x08
#define BIT_RxE3_CFG_STATUS_RxPLD	0x04
#define BIT_RxE3_CFG_STATUS_RxTMARK	0x02
#define BIT_RxE3_CFG_STATUS_RxFERF	0x01

#define REG_RxE3_INT_ENABLE_1		0x12
#define BIT_RxE3_INT_ENABLE_SSM_MSG	0x40
#define BIT_RxE3_INT_ENABLE_SSM_OOS	0x20
#define BIT_RxE3_INT_ENABLE_COFA	0x10
#define BIT_RxE3_INT_ENABLE_OOF		0x08
#define BIT_RxE3_INT_ENABLE_LOF		0x04
#define BIT_RxE3_INT_ENABLE_LOS		0x02
#define BIT_RxE3_INT_ENABLE_AIS		0x01

#define REG_RxE3_INT_ENABLE_2		0x13
#define BIT_RxE3_INT_ENABLE_TTB_CHANGE	0x40
#define BIT_RxE3_INT_ENABLE_FEBE	0x10
#define BIT_RxE3_INT_ENABLE_FERF	0x08
#define BIT_RxE3_INT_ENABLE_BIP_8	0x04
#define BIT_RxE3_INT_ENABLE_FRAMING	0x02
#define BIT_RxE3_INT_ENABLE_RxPLD	0x01

#define REG_RxE3_INT_STATUS_1		0x14
#define BIT_RxE3_INT_STATUS_SSM_MSG	0x40
#define BIT_RxE3_INT_STATUS_SSM_OOS	0x20
#define BIT_RxE3_INT_STATUS_COFA	0x10
#define BIT_RxE3_INT_STATUS_OOF		0x08
#define BIT_RxE3_INT_STATUS_LOF		0x04
#define BIT_RxE3_INT_STATUS_LOS		0x02
#define BIT_RxE3_INT_STATUS_AIS		0x01

#define REG_RxE3_INT_STATUS_2		0x15
#define BIT_RxE3_INT_STATUS_TTB_CHANGE	0x40
#define BIT_RxE3_INT_STATUS_FEBE	0x10
#define BIT_RxE3_INT_STATUS_FERF	0x08
#define BIT_RxE3_INT_STATUS_BIP_8	0x04
#define BIT_RxE3_INT_STATUS_FRAMING	0x02
#define BIT_RxE3_INT_STATUS_RxPLD	0x01

/* Receive E3, ITU-T G.751 */
//#define REG_RxE3_CFG_STATUS_1			0x10
//#define BIT_RxE3_CFG_STATUS_RxFERF_ALGO	0x10

//#define REG_RxE3_CFG_STATUS_2			0x11
#define BIT_RxE3_CFG_STATUS_RxBIP4	0x01
//#define BIT_RxE3_CFG_STATUS_RxLOF_ALGO	0x80
//#define BIT_RxE3_CFG_STATUS_RxLOF		0x40
//#define BIT_RxE3_CFG_STATUS_RxOOF		0x20
//#define BIT_RxE3_CFG_STATUS_RxLOS		0x10
//#define BIT_RxE3_CFG_STATUS_RxAIS		0x08
//#define BIT_RxE3_CFG_STATUS_RxFERF		0x01

//#define REG_RxE3_INT_ENABLE_1			0x12
//#define BIT_RxE3_INT_ENABLE_COFA		0x10
//#define BIT_RxE3_INT_ENABLE_OOF		0x08
//#define BIT_RxE3_INT_ENABLE_LOF		0x04
//#define BIT_RxE3_INT_ENABLE_LOS		0x02
//#define BIT_RxE3_INT_ENABLE_AIS		0x01

//#define REG_RxE3_INT_ENABLE_2			0x13
//#define BIT_RxE3_INT_ENABLE_FERF		0x08
//#define BIT_RxE3_INT_ENABLE_BIP-8		0x04
//#define BIT_RxE3_INT_ENABLE_FRAMING		0x02

//#define REG_RxE3_INT_STATUS_1			0x14
//#define BIT_RxE3_INT_STATUS_COFA		0x10
//#define BIT_RxE3_INT_STATUS_OOF		0x08
//#define BIT_RxE3_INT_STATUS_LOF		0x04
//#define BIT_RxE3_INT_STATUS_LOS		0x02
//#define BIT_RxE3_INT_STATUS_AIS		0x01

//#define REG_RxE3_INT_STATUS_2			0x15
//#define BIT_RxE3_INT_STATUS_FERF		0x08
//#define BIT_RxE3_INT_STATUS_BIP-8		0x04
//#define BIT_RxE3_INT_STATUS_FRAMING		0x02

#define REG_RxDS3_FEAC				0x16
#define BIT_RxDS3_FEAC_5			0x40
#define BIT_RxDS3_FEAC_4			0x20
#define BIT_RxDS3_FEAC_3			0x10
#define BIT_RxDS3_FEAC_2			0x08
#define BIT_RxDS3_FEAC_1			0x04
#define BIT_RxDS3_FEAC_0			0x02

#define REG_RxDS3_FEAC_INT			0x17
#define BIT_RxDS3_FEAC_INT_FEAC_VALID		0x10
#define BIT_RxDS3_FEAC_REMOVE_INT_EN		0x08
#define BIT_RxDS3_FEAC_REMOVE_INT_STATUS	0x04
#define BIT_RxDS3_FEAC_VALID_INT_EN		0x02
#define BIT_RxDS3_FEAC_VALID_INT_STATUS		0x01

/* Transmit DS3 */
#define REG_TxDS3_CFG			0x30
#define BIT_TxDS3_CFG_YELLOW_ALARM	0x80
#define BIT_TxDS3_CFG_XBits		0x40
#define BIT_TxDS3_CFG_IDLE		0x20
#define BIT_TxDS3_CFG_AIS		0x10
#define BIT_TxDS3_CFG_LOS		0x08
#define BIT_TxDS3_CFG_FERF_on_LOS	0x04
#define BIT_TxDS3_CFG_FERF_on_OOF	0x02
#define BIT_TxDS3_CFG_FERF_on_AIS	0x01

#define REG_TxDS3_CFG_STATUS			0x31
#define BIT_TxDS3_CFG_STATUS_FEAC_INTE		0x10
#define BIT_TxDS3_CFG_STATUS_FEAC_INTS		0x08
#define BIT_TxDS3_CFG_STATUS_FEAC_ENABLE	0x04
#define BIT_TxDS3_CFG_STATUS_FEAC_GO		0x02
#define BIT_TxDS3_CFG_STATUS_FEAC_BUSY		0x01

#define REG_TxDS3_LAPD_STATUS			0x34
#define BIT_TxDS3_LAPD_STATUS_START		0x08
#define BIT_TxDS3_LAPD_STATUS_BUSY		0x04
#define BIT_TxDS3_LAPD_STATUS_INT_EN		0x02
#define BIT_TxDS3_LAPD_STATUS_INT		0x01

/* Transmit E3, ITU-T G.832 */
#define REG_TxE3_CFG			0x30
#define BIT_TxE3_CFG_DLinNR		0x10
#define BIT_TxE3_CFG_AIS_ENABLE		0x04
#define BIT_TxE3_CFG_LOS_ENABLE		0x02
#define BIT_TxE3_CFG_MARx		0x01

/* Transmit E3, ITU-T G.751 */
#define REG_TxE3_CFG			0x30
#define BIT_TxE3_CFG_BIP4_ENABLE	0x80
#define BIT_TxE3_CFG_ASRCSEL1		0x40
#define BIT_TxE3_CFG_ASRCSEL0		0x20
#define BIT_TxE3_CFG_NSRCSEL1		0x10
#define BIT_TxE3_CFG_NSRCSEL0		0x08
#define BIT_TxE3_CFG_AIS_ENABLE		0x04
#define BIT_TxE3_CFG_LOS_ENABLE		0x02
#define BIT_TxE3_CFG_FAS_SRC_SELECT	0x01

/* Performance Monitor Registers */
#define REG_PMON_LCV_MSB		0x50
#define REG_PMON_LCV_LSB		0x51
#define REG_PMON_FRAMING_ERR_CNT_MSB	0x52
#define REG_PMON_FRAMING_ERR_CNT_LSB	0x53
#define REG_PMON_PARITY_ERR_CNT_MSB	0x54
#define REG_PMON_PARITY_ERR_CNT_LSB	0x55
#define REG_PMON_FEBE_EVENT_CNT_MSB	0x56
#define REG_PMON_FEBE_EVENT_CNT_LSB	0x57
#define REG_PMON_CPBIT_ERROR_CNT_MSB	0x58
#define REG_PMON_CPBIT_ERROR_CNT_LSB	0x59
#define REG_PMON_HOLDING		0x6C

/* One-Second Error Status Register */
#define REG_ONESECOND_ERR_STATUS		0x6D
#define BIT_ONESECOND_ERR_STATUS_ERR		0x02
#define BIT_ONESECOND_ERR_STATUS_SEVERELY_ERR	0x01

#define REG_ONESECOND_LCV_MSB			0x6E
#define REG_ONESECOND_LCV_LSB			0x6F
#define REG_ONESECOND_FRAME_PARITY_ERR_MSB	0x70
#define REG_ONESECOND_FRAME_PARITY_ERR_LSB	0x71
#define REG_ONESECOND_FRAME_CPBIT_ERR_MSB	0x72
#define REG_ONESECOND_FRAME_CPBIT_ERR_LSB	0x73

#define REG_LINE_INTERFACE_DRIVE		0x80
#define BIT_LINE_INTERFACE_DRIVE_REQB		0x20
#define BIT_LINE_INTERFACE_DRIVE_TAOS		0x10
#define BIT_LINE_INTERFACE_DRIVE_ENCODIS	0x08
#define BIT_LINE_INTERFACE_DRIVE_TxLEV		0x04
#define BIT_LINE_INTERFACE_DRIVE_RLOOP		0x02
#define BIT_LINE_INTERFACE_DRIVE_LLOOP		0x01

#define REG_LINE_INTERFACE_SCAN			0x81
#define BIT_LINE_INTERFACE_SCAN_DMO		0x04
#define BIT_LINE_INTERFACE_SCAN_RLOL		0x02
#define BIT_LINE_INTERFACE_SCAN_RLOS		0x01

/* T3/E3 CPLD register */
#define REG_CPLD_CNTRL		0x00
#define BIT_CPLD_CNTRL_REQEN	0x20
#define BIT_CPLD_CNTRL_TxLEV	0x10
#define BIT_CPLD_CNTRL_RxMON	0x08
#define BIT_CPLD_CNTRL_LOSMUT	0x04
#define BIT_CPLD_CNTRL_STS_1	0x02
#define BIT_CPLD_CNTRL_E3	0x01

#define REG_CPLD_STATUS		0x01
#define BIT_CPLD_STATUS_TAOS	0x80
#define BIT_CPLD_STATUS_RLB	0x40
#define BIT_CPLD_STATUS_LLB	0x20
#define BIT_CPLD_STATUS_RLOL	0x04
#define BIT_CPLD_STATUS_RLOS	0x02
#define BIT_CPLD_STATUS_DMO	0x01

/* T3/E3 Exar Shark CPLD register */
#define REG_EXAR_CPLD_CNTRL		0x00
#define BIT_EXAR_CPLD_CNTRL_RxRED	0x100
#define BIT_EXAR_CPLD_CNTRL_RxAIS	0x080
#define BIT_EXAR_CPLD_CNTRL_RxOOF	0x040
#define BIT_EXAR_CPLD_CNTRL_RxLOS	0x020
#define BIT_EXAR_CPLD_CNTRL_TxAIS	0x010
#define BIT_EXAR_CPLD_CNTRL_RMON	0x008
#define BIT_EXAR_CPLD_CNTRL_LMUT	0x004
#define BIT_EXAR_CPLD_CNTRL_E3		0x002
#define BIT_EXAR_CPLD_CNTRL_DS3		0x001


#endif /* __SDLA_TE3_REG_H */
