/*****************************************************************************
* wanpipemon.c	Sangoma WANPIPE Monitor
*
* Author:       Alex Feldman <al.feldman@sangoma.com>	
* 		Nenad Corbic <ncorbic@sangoma.com>
*
* Copyright:	(c) 1995-2002 Sangoma Technologies Inc.
*
* ----------------------------------------------------------------------------
* Jan 11, 2005  David Rokhvarg  Added code to run above AFT card with protocol
* 				in the LIP layer. Fixed many not working options.
* Aug 02, 2002  Nenad Corbic	Updated all linux utilites and added 
*                               GUI features.
* May 30, 2002	Alex Feldman	Initial version based on ppipemon
*****************************************************************************/

/******************************************************************************
 * 			INCLUDE FILES					      *
 *****************************************************************************/
#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <time.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <net/if.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <string.h>
#include <stdlib.h>
#include <arpa/inet.h>
#if defined(__LINUX__)
# include <linux/version.h>
# include <linux/if_packet.h>
# include <linux/if_wanpipe.h>
# include <linux/if_ether.h>
# include <linux/wanpipe_defines.h>
# include <linux/wanpipe_cfg.h>
# include <linux/wanrouter.h>
# include <linux/wanpipe.h>
# include <linux/sdla_fr.h>
#else
# include <netinet/in_systm.h>
# include <netinet/in.h>
# include <netinet/ip.h>
# include <netinet/udp.h>  
# include <wanpipe_defines.h>
# include <wanpipe_cfg.h>
# include <wanpipe.h>
#endif
#include "fe_lib.h"
#include "wanpipemon.h"       

wan_udp_hdr_t	wan_udp;
unsigned char   if_name[100];


int DoCommand(int sock, wan_udp_hdr_t* wan_udp)
{
        static unsigned char id = 0;
        int err=0;

       	struct ifreq ifr;
       	wan_udp->wan_udphdr_request_reply = 0x01;
       	wan_udp->wan_udphdr_id = id;
       	strncpy(ifr.ifr_name, if_name, sizeof(ifr.ifr_name));
       	ifr.ifr_data = (caddr_t)wan_udp;

       	if ((err=ioctl(sock, SIOC_WANPIPE_PIPEMON , &ifr)) < 0){
       		if (errno != EBUSY){
       			perror("Ioctl: ");
       			exit (1);
       		}
       		return err;
       	}

        return err;

} /* DoCommand */   


int hw_get_fe_type(int sock,unsigned char* adapter_type)
{
	/* Read Adapter Type */
	wan_udp.wan_udphdr_command = WAN_GET_MEDIA_TYPE;
	wan_udp.wan_udphdr_data[0] = WAN_MEDIA_NONE;
	wan_udp.wan_udphdr_data_len = 0;
    	wan_udp.wan_udphdr_return_code = 0xaa;
	DoCommand(sock,&wan_udp);
	if (wan_udp.wan_udphdr_return_code != 0){
		printf("Failed to read Adapter Type.\n");
		return -1;
	}

	*adapter_type = wan_udp.wan_udphdr_data[2];
	return 0;
}        


int fe_get_te1_alarms(int sock)
{
	sdla_fe_stats_t	*fe_stats;
	unsigned char	adapter_type = 0x00;
	int force=0;

	/* Read Adapter Type */
	if (hw_get_fe_type(sock,&adapter_type)){
		return -1;
	}

	printf("Front end type %i\n",adapter_type);
	
	/* Read T1/E1/56K alarms and T1/E1 performance monitoring counters */
	wan_udp.wan_udphdr_command = WAN_FE_GET_STAT;
	wan_udp.wan_udphdr_data_len = 0;
    	wan_udp.wan_udphdr_return_code = 0xaa;
    	wan_udp.wan_udphdr_fe_force = force;
	
	DoCommand(sock,&wan_udp);
	if (wan_udp.wan_udphdr_return_code != 0){
		printf("Failed to read T1/E1/56K statistics.\n");
		return -1;
	}

	fe_stats = (sdla_fe_stats_t*)&wan_udp.wan_udphdr_data[2];  

	if (adapter_type == WAN_MEDIA_T1 || adapter_type == WAN_MEDIA_E1){
		printf("***** %s: %s Alarms (Framer) *****\n\n",
			if_name, (adapter_type == WAN_MEDIA_T1) ? "T1" : "E1");
		printf("ALOS:\t%s\t| LOS:\t%s\n", 
				WAN_TE_ALOS_ALARM(fe_stats->alarms), 
				WAN_TE_LOS_ALARM(fe_stats->alarms));
		printf("RED:\t%s\t| AIS:\t%s\n", 
				WAN_TE_RED_ALARM(fe_stats->alarms), 
				WAN_TE_AIS_ALARM(fe_stats->alarms));
		if (adapter_type == WAN_MEDIA_T1){ 
			printf("YEL:\t%s\t| OOF:\t%s\n", 
					WAN_TE_YEL_ALARM(fe_stats->alarms), 
					WAN_TE_OOF_ALARM(fe_stats->alarms));
		}else{
			printf("OOF:\t%s\n", 
					WAN_TE_OOF_ALARM(fe_stats->alarms));
		}

		if (fe_stats->liu_alarms & WAN_TE_BIT_LIU_ALARM){
			printf("\n***** %s: %s Alarms (LIU) *****\n\n",
				if_name, (adapter_type == WAN_MEDIA_T1) ? "T1" : "E1");
			printf("Short Circuit:\t%s\n", 
					WAN_TE_LIU_ALARM_SC(fe_stats->liu_alarms));
			printf("Open Circuit:\t%s\n", 
					WAN_TE_LIU_ALARM_OC(fe_stats->liu_alarms));
			printf("Loss of Signal:\t%s\n", 
					WAN_TE_LIU_ALARM_LOS(fe_stats->liu_alarms));
		}

	}else if  (adapter_type == WAN_MEDIA_DS3 || adapter_type == WAN_MEDIA_E3){
		printf("***** %s: %s Alarms *****\n\n",
			if_name, (adapter_type == WAN_MEDIA_DS3) ? "DS3" : "E3");

		if (adapter_type == WAN_MEDIA_DS3){
			printf("AIS:\t%s\t| LOS:\t%s\n",
					WAN_TE3_AIS_ALARM(fe_stats->alarms),
					WAN_TE3_LOS_ALARM(fe_stats->alarms));

			printf("OOF:\t%s\t| YEL:\t%s\n",
					WAN_TE3_OOF_ALARM(fe_stats->alarms),
					WAN_TE3_YEL_ALARM(fe_stats->alarms));
		}else{
			printf("AIS:\t%s\t| LOS:\t%s\n",
					WAN_TE3_AIS_ALARM(fe_stats->alarms),
					WAN_TE3_LOS_ALARM(fe_stats->alarms));

			printf("OOF:\t%s\t| YEL:\t%s\n",
					WAN_TE3_OOF_ALARM(fe_stats->alarms),
					WAN_TE3_YEL_ALARM(fe_stats->alarms));
			
			printf("LOF:\t%s\t\n",
					WAN_TE3_LOF_ALARM(fe_stats->alarms));
		}
		
	}else if (adapter_type == WAN_MEDIA_56K){
		printf("***** %s: 56K CSU/DSU Alarms *****\n\n\n", if_name);
	 	printf("In Service:\t\t%s\tData mode idle:\t\t%s\n",
			 	INS_ALARM_56K(fe_stats->alarms), 
			 	DMI_ALARM_56K(fe_stats->alarms));
	
	 	printf("Zero supp. code:\t%s\tCtrl mode idle:\t\t%s\n",
			 	ZCS_ALARM_56K(fe_stats->alarms), 
			 	CMI_ALARM_56K(fe_stats->alarms));

	 	printf("Out of service code:\t%s\tOut of frame code:\t%s\n",
			 	OOS_ALARM_56K(fe_stats->alarms), 
			 	OOF_ALARM_56K(fe_stats->alarms));
		
	 	printf("Valid DSU NL loopback:\t%s\tUnsigned mux code:\t%s\n",
			 	DLP_ALARM_56K(fe_stats->alarms), 
			 	UMC_ALARM_56K(fe_stats->alarms));

	 	printf("Rx loss of signal:\t%s\t\n",
			 	RLOS_ALARM_56K(fe_stats->alarms)); 
		
	}else{
		printf("***** %s: Unknown Front End 0x%X *****\n\n",
			if_name, adapter_type);
	}

	if (adapter_type == WAN_MEDIA_T1 || adapter_type == WAN_MEDIA_E1){
		sdla_te_pmon_t*	pmon = &fe_stats->te_pmon;

		printf("\n\n***** %s: %s Performance Monitoring Counters *****\n\n",
				if_name, (adapter_type == WAN_MEDIA_T1) ? "T1" : "E1");
		if (pmon->mask & WAN_TE_BIT_PMON_LCV){
			printf("Line Code Violation\t: %d\n",
						pmon->lcv_errors);
		}
		if (pmon->mask & WAN_TE_BIT_PMON_BEE){
			printf("Bit Errors (CRC6/Ft/Fs)\t: %d\n",
						pmon->bee_errors);
		}
		if (pmon->mask & WAN_TE_BIT_PMON_OOF){
			printf("Out of Frame Errors\t: %d\n",
						pmon->oof_errors);
		}
		if (pmon->mask & WAN_TE_BIT_PMON_FEB){
			printf("Far End Block Errors\t: %d\n",
						pmon->feb_errors);
		}
		if (pmon->mask & WAN_TE_BIT_PMON_CRC4){
			printf("CRC4 Errors\t\t: %d\n",
						pmon->crc4_errors);
		}
		if (pmon->mask & WAN_TE_BIT_PMON_FER){
			printf("Framing Bit Errors\t: %d\n",
						pmon->fer_errors);
		}
		if (pmon->mask & WAN_TE_BIT_PMON_FAS){
			printf("FAS Errors\t\t: %d\n",
						pmon->fas_errors);
		}
	}

	if (adapter_type == WAN_MEDIA_DS3 || adapter_type == WAN_MEDIA_E3){
		sdla_te3_pmon_t*	pmon = &fe_stats->u.te3_pmon;

		printf("\n\n***** %s: %s Performance Monitoring Counters *****\n\n",
				if_name, (adapter_type == WAN_MEDIA_DS3) ? "DS3" : "E3");

		printf("Framing Bit Error:\t%d\tLine Code Violation:\t%d\n", 
				pmon->pmon_framing,
				pmon->pmon_lcv);

		if (adapter_type == WAN_MEDIA_DS3){
			printf("Parity Error:\t\t%d\n",
					pmon->pmon_parity);
			printf("CP-Bit Error Event:\t%d\tFEBE Event:\t\t%d\n", 
					pmon->pmon_cpbit,
					pmon->pmon_febe);
		}else{
			printf("Parity Error:\t%d\tFEBE Event:\t\t%d\n",
					pmon->pmon_parity,
					pmon->pmon_febe);
		}
	}
	
	if (adapter_type == WAN_MEDIA_T1 || adapter_type == WAN_MEDIA_E1){
		if (strlen(fe_stats->u.te1_stats.rxlevel)){
			printf("\n\nRx Level\t: %s\n",
					fe_stats->u.te1_stats.rxlevel);		
		}
	}
	
	return 0;
}              


int MakeDevConnection(int *sock)                  
{
        *sock = socket(PF_INET, SOCK_STREAM, IPPROTO_IP);
	if (*sock < 0){
		perror("socket");
		return -1;
    	}

	return 0;
}             

void usage(void)
{
 	printf("Usage: ./fe_api <ifname>");
}

int main(int argc, char* argv[])
{
	int err = 0;
	int sock;

	memset(&wan_udp,0,sizeof(wan_udp));
	strcpy(wan_udp.wan_udphdr_signature, GLOBAL_UDP_SIGNATURE);

  	printf("Starting \n");
   	if (argc >= 2){

		strncpy(if_name, argv[1], sizeof(if_name));
    
		if (MakeDevConnection(&sock) != 0){ 
		       	err=-ENODEV;
		       	goto main_exit;
		}

		err=fe_get_te1_alarms(sock);	
		if (err) {
                 	printf("Failed to get te1 alarms!\n");
			perror("Te Alarms: \n");
		}
		
     		close(sock);

   	}else{
    		usage();
   	}
  
	printf("\n");

main_exit:

   	return err;
}                       
