/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*\

File:  oct6100_tlv_priv.h

    Copyright (c) 2001-2008 Octasic Inc.
    
Description: 

	File containing all private defines, macros, structures and prototypes 
	pertaining to the file oct6100_tlv.c.  All elements defined in 	this 
	file are for private usage of the API.

This file is part of the Octasic OCT6100 GPL API . The OCT6100 GPL API  is 
free software; you can redistribute it and/or modify it under the terms of 
the GNU General Public License as published by the Free Software Foundation; 
either version 2 of the License, or (at your option) any later version.

The OCT6100 GPL API is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License 
for more details. 

You should have received a copy of the GNU General Public License 
along with the OCT6100 GPL API; if not, write to the Free Software 
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.

$Octasic_Release: OCT612xAPI-01.01.01 $

$Octasic_Revision: 58 $

\*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/

#ifndef __OCT6100_TLV_PRIV_H__
#define __OCT6100_TLV_PRIV_H__

/*****************************  INCLUDE FILES  *******************************/


/*****************************  DEFINES  *************************************/

/* List of TLV types supported by this API. */
#define cOCT6100_TLV_TYPE_VERSION_NUMBER				0
#define cOCT6100_TLV_TYPE_CUSTOMER_PROJECT_ID			2

#define cOCT6100_TLV_TYPE_POUCH_BASE_ADDRESS			3
#define cOCT6100_TLV_TYPE_CH0_MAIN_BASE_ADDRESS			4
#define cOCT6100_TLV_TYPE_CH_MAIN_SIZE					5
#define cOCT6100_TLV_TYPE_CH_MAIN_IO_OFFSET				6
#define cOCT6100_TLV_TYPE_CH_MAIN_ZCB_OFFSET			7
#define cOCT6100_TLV_TYPE_CH_MAIN_ZCB_SIZE				8
#define cOCT6100_TLV_TYPE_CH_MAIN_XCB_OFFSET			9
#define cOCT6100_TLV_TYPE_CH_MAIN_XCB_SIZE				10
#define cOCT6100_TLV_TYPE_CH_MAIN_YCB_OFFSET			11
#define cOCT6100_TLV_TYPE_CH_MAIN_YCB_SIZE				12
#define cOCT6100_TLV_TYPE_FREE_MEM_BASE_ADDRESS			13
#define cOCT6100_TLV_TYPE_CH_ROOT_CONF_OFFSET			14

#define cOCT6100_TLV_TYPE_POA_CH_MAIN_ZPO_OFFSET		15
#define cOCT6100_TLV_TYPE_POA_CH_MAIN_ZPO_SIZE			16
#define cOCT6100_TLV_TYPE_POA_CH_MAIN_YPO_OFFSET		17
#define cOCT6100_TLV_TYPE_POA_CH_MAIN_YPO_SIZE			18
#define cOCT6100_TLV_TYPE_POA_BOFF_RW_ZWP				19
#define cOCT6100_TLV_TYPE_POA_BOFF_RW_ZIS				20
#define cOCT6100_TLV_TYPE_POA_BOFF_RW_ZSP				21
#define cOCT6100_TLV_TYPE_POA_BOFF_RW_YWP				22
#define cOCT6100_TLV_TYPE_POA_BOFF_RW_YIS				23
#define cOCT6100_TLV_TYPE_POA_BOFF_RW_YSP				24
#define cOCT6100_TLV_TYPE_POA_BOFF_RO_ZRP				25
#define cOCT6100_TLV_TYPE_POA_BOFF_RO_YRP				26

#define cOCT6100_TLV_TYPE_CNR_CONF_BOFF_RW_ENABLE		27
#define cOCT6100_TLV_TYPE_ANR_CONF_BOFF_RW_ENABLE		28

#define cOCT6100_TLV_TYPE_HZ_CONF_BOFF_RW_ENABLE		29
#define cOCT6100_TLV_TYPE_HX_CONF_BOFF_RW_ENABLE		30

#define cOCT6100_TLV_TYPE_LCA_Z_CONF_BOFF_RW_GAIN		31
#define cOCT6100_TLV_TYPE_LCA_Y_CONF_BOFF_RW_GAIN		32

#define cOCT6100_TLV_TYPE_CNA_CONF_BOFF_RW_ENABLE		33

#define cOCT6100_TLV_TYPE_NOA_CONF_BOFF_RW_ENABLE		34

#define cOCT6100_TLV_TYPE_VFA_CONF_BOFF_RW_ENABLE		35

#define cOCT6100_TLV_TYPE_TLA_MAIN_IO_BOFF_RW_TAIL_DISP		37

#define cOCT6100_TLV_TYPE_STATSA_MAIN_IO_BOFF_RO_EPC		38
#define cOCT6100_TLV_TYPE_BOOTA_POUCH_BOFF_RW_BOOT_INST		39
#define cOCT6100_TLV_TYPE_BOOTA_POUCH_BOFF_RW_BOOT_RESULT	40

#define cOCT6100_TLV_TYPE_DIS_CONF_BOFF_RW_ENABLE			41
#define cOCT6100_TLV_TYPE_TDM_CONF_BOFF_RW_ENABLE			42
#define cOCT6100_TLV_TYPE_NT_CONF_BOFF_RW_ENABLE			43
#define cOCT6100_TLV_TYPE_AEC_CONF_BOFF_RW_ENABLE			44

#define cOCT6100_TLV_TYPE_PCM_LEAK_CONF_BOFF_RW				45
#define cOCT6100_TLV_TYPE_DEFAULT_ERL_CONF_BOFF_RW			46
#define cOCT6100_TLV_TYPE_TONE_REM_CONF_BOFF_RW_ENABLE		47

#define cOCT6100_TLV_TYPE_TLA_MAIN_IO_BOFF_RW_MAX_ECHO_POINT	48

#define cOCT6100_TLV_TYPE_NLP_CONV_CAP_CONF_BOFF_RW				49
#define cOCT6100_TLV_TYPE_MATRIX_EVENT_SIZE						50
#define cOCT6100_TLV_TYPE_CNR_RW_ENABLE							51
#define cOCT6100_TLV_TYPE_MAX_TAIL_LENGTH_RW_ENABLE				52

#define cOCT6100_TLV_TYPE_PLAYOUT_ENABLE					53
#define cOCT6100_TLV_TYPE_DOMINANT_SPEAKER_BOFF_RW_ENABLE	54

#define cOCT6100_TLV_TYPE_ANR_RW_ENABLE						57
#define cOCT6100_TLV_TYPE_TONE_REMOVAL_ENABLE				58
#define cOCT6100_TLV_TYPE_MUSIC_PROTECTION_RW_ENABLE		59
#define cOCT6100_TLV_TYPE_TAIL_DISP_CONF_BOFF_RW_ENABLE		60
#define cOCT6100_TLV_TYPE_IDLE_CODE_DETECTION_ENABLE		62

#define cOCT6100_TLV_TYPE_AEC_DEFAULT_ERL_BOFF				64

#define cOCT6100_TLV_TYPE_Z_ALC_TARGET_BOFF					65
#define cOCT6100_TLV_TYPE_Y_ALC_TARGET_BOFF					66
#define cOCT6100_TLV_TYPE_Z_HLC_TARGET_BOFF					67
#define cOCT6100_TLV_TYPE_Y_HLC_TARGET_BOFF					68
#define cOCT6100_TLV_TYPE_ALC_HLC_STATUS_BOFF				69

#define cOCT6100_TLV_TYPE_Z_PLAYOUT_HARD_SKIP_BOFF			70
#define cOCT6100_TLV_TYPE_Y_PLAYOUT_HARD_SKIP_BOFF			71

#define cOCT6100_TLV_TYPE_AFT_FIELD_BOFF					72

#define cOCT6100_TLV_TYPE_VOICE_DETECTED_STAT_BOFF			73

#define cOCT6100_TLV_TYPE_GAIN_APPLIED_RIN_STAT_BOFF		74
#define cOCT6100_TLV_TYPE_GAIN_APPLIED_SOUT_STAT_BOFF		75

#define cOCT6100_TLV_TYPE_MAX_ADAPT_ALE_BOFF				77
#define cOCT6100_TLV_TYPE_RIN_ANR_BOFF						78

#define cOCT6100_TLV_TYPE_NUMBER_PLAYOUT_EVENTS				79

#define cOCT6100_TLV_TYPE_RIN_MUTE_BOFF						80
#define cOCT6100_TLV_TYPE_SIN_MUTE_BOFF						81

#define cOCT6100_TLV_TYPE_CHAN_TAIL_LENGTH_BOFF				82

#define cOCT6100_TLV_TYPE_CHAN_VQE_TONE_DISABLING_BOFF		83

#define cOCT6100_TLV_TYPE_ANR_SNR_IMPROVEMENT_BOFF			84
#define cOCT6100_TLV_TYPE_ANR_AGRESSIVITY_BOFF				85

#define cOCT6100_TLV_TYPE_RIN_TONE_REM_CONF_BOFF_RW_ENABLE	86
#define cOCT6100_TLV_TYPE_RIN_TONE_REM_COUNTER_BOFF			87

#define cOCT6100_TLV_TYPE_AF_TAIL_DISP_VALUE_BOFF			88

#define cOCT6100_TLV_TYPE_POUCH_COUNTER_BOFF				89

#define cOCT6100_TLV_TYPE_AEC_TAIL_LENGTH_BOFF				90

#define cOCT6100_TLV_TYPE_MATRIX_DWORD_BASE					91
#define cOCT6100_TLV_TYPE_DEBUG_CHAN_STATS_BYTE_SIZE		92
#define cOCT6100_TLV_TYPE_RECORDED_PCM_EVENT_BYTE_SIZE		93
#define cOCT6100_TLV_TYPE_HOT_CHANNEL_SELECT_DWORD_BASE		94
#define cOCT6100_TLV_TYPE_IS_ISR_CALLED_BOFF				95

#define cOCT6100_TLV_TYPE_MATRIX_TIMESTAMP_DWORD_BASE		96

#define cOCT6100_TLV_TYPE_CHAN_MAIN_IO_STATS_OFFSET			100
#define cOCT6100_TLV_TYPE_CHAN_MAIN_IO_STATS_SIZE			101

#define cOCT6100_TLV_TYPE_AF_WRITE_PTR_BYTE_OFFSET			104
#define cOCT6100_TLV_TYPE_MATRIX_WP_DWORD_BASE				105
#define cOCT6100_TLV_TYPE_DEBUG_CHAN_LITE_STATS_BYTE_SIZE	106

#define cOCT6100_TLV_TYPE_MUSIC_PROTECTION_ENABLE_BOFF		107

#define cOCT6100_TLV_TYPE_IMAGE_TYPE						108
#define cOCT6100_TLV_TYPE_MAX_WIRELINE_CHANNELS				111

#define cOCT6100_TLV_TYPE_AF_EVENT_CB_SIZE					112

#define cOCT6100_TLV_TYPE_ZZ_ENERGY_CHAN_STATS_BOFF			116
#define cOCT6100_TLV_TYPE_YY_ENERGY_CHAN_STATS_BOFF			117

#define cOCT6100_TLV_TYPE_BUFFER_PLAYOUT_SKIP_IN_EVENTS		119

#define cOCT6100_TLV_TYPE_SOUT_NOISE_BLEACHING				121

#define cOCT6100_TLV_TYPE_DOUBLE_TALK_BEH_MODE				124
#define cOCT6100_TLV_TYPE_DOUBLE_TALK_BEH_MODE_BOFF			125

#define cOCT6100_TLV_TYPE_IDLE_CODE_DETECTION_BOFF			136

#define cOCT6100_TLV_TYPE_NLP_STATISTICS					138

#define cOCT6100_TLV_TYPE_RIN_ANR_VALUE						147

#define cOCT6100_TLV_TYPE_ADPCM_ENABLE						150
#define cOCT6100_TLV_TYPE_NUM_TONE_DETECTOR					151
#define cOCT6100_TLV_TYPE_CONFERENCING_ENABLE				152
#define cOCT6100_TLV_TYPE_MAX_NUMBER_OF_CHANNELS			153
#define cOCT6100_TLV_TYPE_DEBUG_CHAN_INDEX_VALUE			154
#define cOCT6100_TLV_TYPE_TONE_DETECTOR_PROFILE				155
#define cOCT6100_TLV_TYPE_TEST_MODE_ENABLE					156
#define cOCT6100_TLV_TYPE_MAX_TAIL_DISPLACEMENT				157


/* TLV length defines. */		
#define cOCT6100_TLV_MIN_LENGTH_DEFAULT					4
#define cOCT6100_TLV_MAX_LENGTH_DEFAULT					0xFFFFFFFF

#define cOCT6100_TLV_MIN_LENGTH_VERSION_NUMBER			4
#define cOCT6100_TLV_MAX_LENGTH_VERSION_NUMBER			1016
#define cOCT6100_TLV_MIN_LENGTH_CUSTOMER_PROJECT_ID		4
#define cOCT6100_TLV_MAX_LENGTH_CUSTOMER_PROJECT_ID		4


#define cOCT6100_TLV_MIN_LENGTH_CH0_MAIN_BASE_ADDRESS	4
#define cOCT6100_TLV_MAX_LENGTH_CH0_MAIN_BASE_ADDRESS	4
#define cOCT6100_TLV_MIN_LENGTH_CH_MAIN_SIZE			4
#define cOCT6100_TLV_MAX_LENGTH_CH_MAIN_SIZE			4
#define cOCT6100_TLV_MIN_LENGTH_CH_MAIN_IO_OFFSET		4
#define cOCT6100_TLV_MAX_LENGTH_CH_MAIN_IO_OFFSET		4
#define cOCT6100_TLV_MIN_LENGTH_CH_MAIN_ZCB_OFFSET		4
#define cOCT6100_TLV_MAX_LENGTH_CH_MAIN_ZCB_OFFSET		4
#define cOCT6100_TLV_MIN_LENGTH_CH_MAIN_ZCB_SIZE		4
#define cOCT6100_TLV_MAX_LENGTH_CH_MAIN_ZCB_SIZE		4
#define cOCT6100_TLV_MIN_LENGTH_CH_MAIN_XCB_OFFSET		4
#define cOCT6100_TLV_MAX_LENGTH_CH_MAIN_XCB_OFFSET		4
#define cOCT6100_TLV_MIN_LENGTH_CH_MAIN_XCB_SIZE		4
#define cOCT6100_TLV_MAX_LENGTH_CH_MAIN_XCB_SIZE		4
#define cOCT6100_TLV_MIN_LENGTH_CH_MAIN_YCB_OFFSET		4
#define cOCT6100_TLV_MAX_LENGTH_CH_MAIN_YCB_OFFSET		4
#define cOCT6100_TLV_MIN_LENGTH_CH_MAIN_YCB_SIZE		4
#define cOCT6100_TLV_MAX_LENGTH_CH_MAIN_YCB_SIZE		4
#define cOCT6100_TLV_MIN_LENGTH_FREE_MEM_BASE_ADDRESS	4
#define cOCT6100_TLV_MAX_LENGTH_FREE_MEM_BASE_ADDRESS	4
#define cOCT6100_TLV_MIN_LENGTH_CH_ROOT_CONF_OFFSET		4
#define cOCT6100_TLV_MAX_LENGTH_CH_ROOT_CONF_OFFSET		4

#define cOCT6100_TLV_MIN_LENGTH_POA_CH_MAIN_ZPO_OFFSET	4
#define cOCT6100_TLV_MAX_LENGTH_POA_CH_MAIN_ZPO_OFFSET	4
#define cOCT6100_TLV_MIN_LENGTH_POA_CH_MAIN_ZPO_SIZE	4
#define cOCT6100_TLV_MAX_LENGTH_POA_CH_MAIN_ZPO_SIZE	4
#define cOCT6100_TLV_MIN_LENGTH_POA_CH_MAIN_YPO_OFFSET	4
#define cOCT6100_TLV_MAX_LENGTH_POA_CH_MAIN_YPO_OFFSET	4
#define cOCT6100_TLV_MIN_LENGTH_POA_CH_MAIN_YPO_SIZE	4
#define cOCT6100_TLV_MAX_LENGTH_POA_CH_MAIN_YPO_SIZE	4
#define cOCT6100_TLV_MIN_LENGTH_POA_BOFF_RW_ZWP			8
#define cOCT6100_TLV_MAX_LENGTH_POA_BOFF_RW_ZWP			8
#define cOCT6100_TLV_MIN_LENGTH_POA_BOFF_RW_ZIS			8
#define cOCT6100_TLV_MAX_LENGTH_POA_BOFF_RW_ZIS			8
#define cOCT6100_TLV_MIN_LENGTH_POA_BOFF_RW_ZSP			8
#define cOCT6100_TLV_MAX_LENGTH_POA_BOFF_RW_ZSP			8
#define cOCT6100_TLV_MIN_LENGTH_POA_BOFF_RW_YWP			8
#define cOCT6100_TLV_MAX_LENGTH_POA_BOFF_RW_YWP			8
#define cOCT6100_TLV_MIN_LENGTH_POA_BOFF_RW_YIS			8
#define cOCT6100_TLV_MAX_LENGTH_POA_BOFF_RW_YIS			8
#define cOCT6100_TLV_MIN_LENGTH_POA_BOFF_RW_YSP			8
#define cOCT6100_TLV_MAX_LENGTH_POA_BOFF_RW_YSP			8
#define cOCT6100_TLV_MIN_LENGTH_POA_BOFF_RO_ZRP			8
#define cOCT6100_TLV_MAX_LENGTH_POA_BOFF_RO_ZRP			8
#define cOCT6100_TLV_MIN_LENGTH_POA_BOFF_RO_YRP			8
#define cOCT6100_TLV_MAX_LENGTH_POA_BOFF_RO_YRP			8

#define cOCT6100_TLV_MIN_LENGTH_CNR_CONF_BOFF_RW_ENABLE	8
#define cOCT6100_TLV_MAX_LENGTH_CNR_CONF_BOFF_RW_ENABLE	8
#define cOCT6100_TLV_MIN_LENGTH_ANR_CONF_BOFF_RW_ENABLE	8
#define cOCT6100_TLV_MAX_LENGTH_ANR_CONF_BOFF_RW_ENABLE	8

#define cOCT6100_TLV_MIN_LENGTH_HZ_CONF_BOFF_RW_ENABLE		8	
#define cOCT6100_TLV_MAX_LENGTH_HZ_CONF_BOFF_RW_ENABLE		8
#define cOCT6100_TLV_MIN_LENGTH_HX_CONF_BOFF_RW_ENABLE		8
#define cOCT6100_TLV_MAX_LENGTH_HX_CONF_BOFF_RW_ENABLE		8

#define cOCT6100_TLV_MIN_LENGTH_LCA_Z_CONF_BOFF_RW_GAIN	8
#define cOCT6100_TLV_MAX_LENGTH_LCA_Z_CONF_BOFF_RW_GAIN	8
#define cOCT6100_TLV_MIN_LENGTH_LCA_Y_CONF_BOFF_RW_GAIN	8
#define cOCT6100_TLV_MAX_LENGTH_LCA_Y_CONF_BOFF_RW_GAIN	8

#define cOCT6100_TLV_MIN_LENGTH_CNA_CONF_BOFF_RW_ENABLE		8
#define cOCT6100_TLV_MAX_LENGTH_CNA_CONF_BOFF_RW_ENABLE		8

#define cOCT6100_TLV_MIN_LENGTH_NOA_CONF_BOFF_RW_ENABLE		8
#define cOCT6100_TLV_MAX_LENGTH_NOA_CONF_BOFF_RW_ENABLE		8

#define cOCT6100_TLV_MIN_LENGTH_VFA_CONF_BOFF_RW_ENABLE		8
#define cOCT6100_TLV_MAX_LENGTH_VFA_CONF_BOFF_RW_ENABLE		8

#define cOCT6100_TLV_MIN_LENGTH_TLA_MAIN_IO_BOFF_RW_TAIL_DISP		8
#define cOCT6100_TLV_MAX_LENGTH_TLA_MAIN_IO_BOFF_RW_TAIL_DISP		8

#define cOCT6100_TLV_MIN_LENGTH_STATSA_MAIN_IO_BOFF_RO_EPC			8
#define cOCT6100_TLV_MAX_LENGTH_STATSA_MAIN_IO_BOFF_RO_EPC			8

#define cOCT6100_TLV_MIN_LENGTH_BOOTA_POUCH_BOFF_RW_BOOT_INST		8
#define cOCT6100_TLV_MAX_LENGTH_BOOTA_POUCH_BOFF_RW_BOOT_INST		8
#define cOCT6100_TLV_MIN_LENGTH_BOOTA_POUCH_BOFF_RW_BOOT_RESULT		8
#define cOCT6100_TLV_MAX_LENGTH_BOOTA_POUCH_BOFF_RW_BOOT_RESULT		8

#define cOCT6100_TLV_MIN_LENGTH_CHAN_MAIN_IO_STATS_OFFSET		4
#define cOCT6100_TLV_MAX_LENGTH_CHAN_MAIN_IO_STATS_OFFSET		4
#define cOCT6100_TLV_MIN_LENGTH_CHAN_MAIN_IO_STATS_SIZE			4
#define cOCT6100_TLV_MAX_LENGTH_CHAN_MAIN_IO_STATS_SIZE			4

#define cOCT6100_TLV_MIN_LENGTH_CDA_CONF_BOFF_RW_ENABLE			8
#define cOCT6100_TLV_MAX_LENGTH_CDA_CONF_BOFF_RW_ENABLE			8
#define cOCT6100_TLV_MIN_LENGTH_TDM_CONF_BOFF_RW_ENABLE			8
#define cOCT6100_TLV_MAX_LENGTH_TDM_CONF_BOFF_RW_ENABLE			8
#define cOCT6100_TLV_MIN_LENGTH_DIS_CONF_BOFF_RW_ENABLE			8
#define cOCT6100_TLV_MAX_LENGTH_DIS_CONF_BOFF_RW_ENABLE			8
#define cOCT6100_TLV_MIN_LENGTH_NT_CONF_BOFF_RW_ENABLE			8
#define cOCT6100_TLV_MAX_LENGTH_NT_CONF_BOFF_RW_ENABLE			8
#define cOCT6100_TLV_MIN_LENGTH_AEC_CONF_BOFF_RW_ENABLE			8
#define cOCT6100_TLV_MAX_LENGTH_AEC_CONF_BOFF_RW_ENABLE			8

#define cOCT6100_TLV_MIN_LENGTH_PCM_LEAK_CONF_BOFF_RW			8
#define cOCT6100_TLV_MAX_LENGTH_PCM_LEAK_CONF_BOFF_RW			8
#define cOCT6100_TLV_MIN_LENGTH_DEFAULT_ERL_CONF_BOFF_RW		8
#define cOCT6100_TLV_MAX_LENGTH_DEFAULT_ERL_CONF_BOFF_RW		8
#define cOCT6100_TLV_MIN_LENGTH_TONE_REM_CONF_BOFF_RW_ENABLE	8
#define cOCT6100_TLV_MAX_LENGTH_TONE_REM_CONF_BOFF_RW_ENABLE	8
#define cOCT6100_TLV_MIN_LENGTH_NLP_CONV_CAP_CONF_BOFF_RW		8
#define cOCT6100_TLV_MAX_LENGTH_NLP_CONV_CAP_CONF_BOFF_RW		8

#define cOCT6100_TLV_MIN_LENGTH_TLA_MAIN_IO_BOFF_RW_MAX_ECHO_POINT	8
#define cOCT6100_TLV_MAX_LENGTH_TLA_MAIN_IO_BOFF_RW_MAX_ECHO_POINT	8

#define cOCT6100_TLV_MIN_LENGTH_DOMINANT_SPEAKER_BOFF_RW_ENABLE	8
#define cOCT6100_TLV_MAX_LENGTH_DOMINANT_SPEAKER_BOFF_RW_ENABLE	8

#define cOCT6100_TLV_MIN_LENGTH_TAIL_DISP_CONF_BOFF_RW_ENABLE	8
#define cOCT6100_TLV_MAX_LENGTH_TAIL_DISP_CONF_BOFF_RW_ENABLE	8

#define cOCT6100_TLV_MIN_LENGTH_AEC_DEFAULT_ERL_BOFF_RW_ENABLE	8
#define cOCT6100_TLV_MAX_LENGTH_AEC_DEFAULT_ERL_BOFF_RW_ENABLE	8

#define cOCT6100_TLV_MIN_LENGTH_Z_ALC_TARGET_BOFF_RW_ENABLE		8
#define cOCT6100_TLV_MAX_LENGTH_Z_ALC_TARGET_BOFF_RW_ENABLE		8
#define cOCT6100_TLV_MIN_LENGTH_Y_ALC_TARGET_BOFF_RW_ENABLE		8
#define cOCT6100_TLV_MAX_LENGTH_Y_ALC_TARGET_BOFF_RW_ENABLE		8
#define cOCT6100_TLV_MIN_LENGTH_Z_HLC_TARGET_BOFF_RW_ENABLE		8
#define cOCT6100_TLV_MAX_LENGTH_Z_HLC_TARGET_BOFF_RW_ENABLE		8
#define cOCT6100_TLV_MIN_LENGTH_Y_HLC_TARGET_BOFF_RW_ENABLE		8
#define cOCT6100_TLV_MAX_LENGTH_Y_HLC_TARGET_BOFF_RW_ENABLE		8
#define cOCT6100_TLV_MIN_LENGTH_ALC_HLC_STATUS_BOFF_RW_ENABLE	8
#define cOCT6100_TLV_MAX_LENGTH_ALC_HLC_STATUS_BOFF_RW_ENABLE	8

#define cOCT6100_TLV_MIN_LENGTH_Z_PLAYOUT_HARD_SKIP_BOFF_RW		8
#define cOCT6100_TLV_MAX_LENGTH_Z_PLAYOUT_HARD_SKIP_BOFF_RW		8
#define cOCT6100_TLV_MIN_LENGTH_Y_PLAYOUT_HARD_SKIP_BOFF_RW		8
#define cOCT6100_TLV_MAX_LENGTH_Y_PLAYOUT_HARD_SKIP_BOFF_RW		8

#define cOCT6100_TLV_MIN_LENGTH_AFT_FIELD_BOFF_RW				8
#define cOCT6100_TLV_MAX_LENGTH_AFT_FIELD_BOFF_RW				8

#define cOCT6100_TLV_MIN_LENGTH_VOICE_DETECTED_STAT_BOFF_RW		8
#define cOCT6100_TLV_MAX_LENGTH_VOICE_DETECTED_STAT_BOFF_RW		8

#define cOCT6100_TLV_MIN_LENGTH_GAIN_APPLIED_RIN_STAT_BOFF_RW	8
#define cOCT6100_TLV_MAX_LENGTH_GAIN_APPLIED_RIN_STAT_BOFF_RW	8
#define cOCT6100_TLV_MIN_LENGTH_GAIN_APPLIED_SOUT_STAT_BOFF_RW	8
#define cOCT6100_TLV_MAX_LENGTH_GAIN_APPLIED_SOUT_STAT_BOFF_RW	8

#define cOCT6100_TLV_MIN_LENGTH_MAX_ADAPT_ALE_BOFF_RW			8
#define cOCT6100_TLV_MAX_LENGTH_MAX_ADAPT_ALE_BOFF_RW			8

#define cOCT6100_TLV_MIN_LENGTH_RIN_ANR_BOFF_RW					8
#define cOCT6100_TLV_MAX_LENGTH_RIN_ANR_BOFF_RW					8

#define cOCT6100_TLV_MIN_LENGTH_RIN_ANR_VALUE_RW				8
#define cOCT6100_TLV_MAX_LENGTH_RIN_ANR_VALUE_RW				8

#define cOCT6100_TLV_MIN_LENGTH_RIN_MUTE_BOFF_RW				8
#define cOCT6100_TLV_MAX_LENGTH_RIN_MUTE_BOFF_RW				8
#define cOCT6100_TLV_MIN_LENGTH_SIN_MUTE_BOFF_RW				8
#define cOCT6100_TLV_MAX_LENGTH_SIN_MUTE_BOFF_RW				8

#define cOCT6100_TLV_MIN_LENGTH_ANR_SNR_IMPROVEMENT_BOFF_RW		8
#define cOCT6100_TLV_MAX_LENGTH_ANR_SNR_IMPROVEMENT_BOFF_RW		8
#define cOCT6100_TLV_MIN_LENGTH_ANR_AGRESSIVITY_BOFF_RW			8
#define cOCT6100_TLV_MAX_LENGTH_ANR_AGRESSIVITY_BOFF_RW			8

#define cOCT6100_TLV_MIN_LENGTH_CHAN_TAIL_LENGTH_BOFF			8
#define cOCT6100_TLV_MAX_LENGTH_CHAN_TAIL_LENGTH_BOFF			8

#define cOCT6100_TLV_MIN_LENGTH_CHAN_VQE_TONE_DIS_BOFF			8
#define cOCT6100_TLV_MAX_LENGTH_CHAN_VQE_TONE_DIS_BOFF			8

#define cOCT6100_TLV_MIN_LENGTH_RIN_TONE_REM_CONF_BOFF_RW_ENABLE	8
#define cOCT6100_TLV_MAX_LENGTH_RIN_TONE_REM_CONF_BOFF_RW_ENABLE	8

#define cOCT6100_TLV_MIN_LENGTH_RIN_TONE_REM_COUNTER_BOFF_RW	8
#define cOCT6100_TLV_MAX_LENGTH_RIN_TONE_REM_COUNTER_BOFF_RW	8

#define cOCT6100_TLV_MIN_LENGTH_AF_TAIL_DISP_VALUE_BOFF			8
#define cOCT6100_TLV_MAX_LENGTH_AF_TAIL_DISP_VALUE_BOFF			8

#define cOCT6100_TLV_MIN_LENGTH_POUCH_COUNTER_BOFF				8
#define cOCT6100_TLV_MAX_LENGTH_POUCH_COUNTER_BOFF				8

#define cOCT6100_TLV_MIN_LENGTH_AEC_TAIL_BOFF					8
#define cOCT6100_TLV_MAX_LENGTH_AEC_TAIL_BOFF					8

#define cOCT6100_TLV_MIN_LENGTH_IS_ISR_CALLED_BOFF				8
#define cOCT6100_TLV_MAX_LENGTH_IS_ISR_CALLED_BOFF				8

#define cOCT6100_TLV_MIN_LENGTH_MUSIC_PROTECTION_ENABLE_BOFF	8
#define cOCT6100_TLV_MAX_LENGTH_MUSIC_PROTECTION_ENABLE_BOFF	8

#define cOCT6100_TLV_MIN_LENGTH_ZZ_ENERGY_CHAN_STATS_BOFF		8
#define cOCT6100_TLV_MAX_LENGTH_ZZ_ENERGY_CHAN_STATS_BOFF		8
#define cOCT6100_TLV_MIN_LENGTH_YY_ENERGY_CHAN_STATS_BOFF		8
#define cOCT6100_TLV_MAX_LENGTH_YY_ENERGY_CHAN_STATS_BOFF		8

#define cOCT6100_TLV_MIN_LENGTH_DOUBLE_TALK_BEH_MODE_BOFF		8
#define cOCT6100_TLV_MAX_LENGTH_DOUBLE_TALK_BEH_MODE_BOFF		8

#define cOCT6100_TLV_MIN_LENGTH_IDLE_CODE_DETECTION_BOFF		8
#define cOCT6100_TLV_MAX_LENGTH_IDLE_CODE_DETECTION_BOFF		8

#define cOCT6100_TLV_MIN_LENGTH_DEBUG_CHAN_INDEX_VALUE			4
#define cOCT6100_TLV_MAX_LENGTH_DEBUG_CHAN_INDEX_VALUE			4
#define cOCT6100_TLV_MIN_LENGTH_ADPCM_ENABLE					4
#define cOCT6100_TLV_MAX_LENGTH_ADPCM_ENABLE					4
#define cOCT6100_TLV_MIN_LENGTH_NUM_TONE_DETECTOR				4
#define cOCT6100_TLV_MAX_LENGTH_NUM_TONE_DETECTOR				4
#define cOCT6100_TLV_MIN_LENGTH_CONFERENCING_ENABLE				4
#define cOCT6100_TLV_MAX_LENGTH_CONFERENCING_ENABLE				4
#define cOCT6100_TLV_MIN_LENGTH_MAX_NUMBER_OF_CHANNELS			4
#define cOCT6100_TLV_MAX_LENGTH_MAX_NUMBER_OF_CHANNELS			4
#define cOCT6100_TLV_MIN_LENGTH_TONE_DETECTOR_PROFILE			4
#define cOCT6100_TLV_MAX_LENGTH_TONE_DETECTOR_PROFILE			4
#define cOCT6100_TLV_MIN_LENGTH_TEST_MODE_ENABLE				4
#define cOCT6100_TLV_MAX_LENGTH_TEST_MODE_ENABLE				4
#define cOCT6100_TLV_MIN_LENGTH_MAX_TAIL_DISPLACEMENT			4
#define cOCT6100_TLV_MAX_LENGTH_MAX_TAIL_DISPLACEMENT			4 
#define cOCT6100_TLV_MIN_LENGTH_MATRIX_EVENT_SIZE				4
#define cOCT6100_TLV_MAX_LENGTH_MATRIX_EVENT_SIZE				4
#define cOCT6100_TLV_MIN_LENGTH_CNR_RW_ENABLE					4
#define cOCT6100_TLV_MAX_LENGTH_CNR_RW_ENABLE					4
#define cOCT6100_TLV_MIN_LENGTH_ANR_RW_ENABLE					4
#define cOCT6100_TLV_MAX_LENGTH_ANR_RW_ENABLE					4
#define cOCT6100_TLV_MIN_LENGTH_MAX_TAIL_LENGTH_RW_ENABLE		4
#define cOCT6100_TLV_MAX_LENGTH_MAX_TAIL_LENGTH_RW_ENABLE		4
#define cOCT6100_TLV_MIN_LENGTH_PLAYOUT_ENABLE					4
#define cOCT6100_TLV_MAX_LENGTH_PLAYOUT_ENABLE					4
#define cOCT6100_TLV_MIN_LENGTH_MUSIC_PROTECTION_RW_ENABLE		4
#define cOCT6100_TLV_MAX_LENGTH_MUSIC_PROTECTION_RW_ENABLE		4
#define cOCT6100_TLV_MIN_LENGTH_TONE_REMOVAL_ENABLE				4
#define cOCT6100_TLV_MAX_LENGTH_TONE_REMOVAL_ENABLE				4
#define cOCT6100_TLV_MIN_LENGTH_NUMBER_PLAYOUT_EVENTS			4
#define cOCT6100_TLV_MAX_LENGTH_NUMBER_PLAYOUT_EVENTS			4
#define cOCT6100_TLV_MIN_LENGTH_MATRIX_DWORD_BASE				4
#define cOCT6100_TLV_MAX_LENGTH_MATRIX_DWORD_BASE				4
#define cOCT6100_TLV_MIN_LENGTH_DEBUG_CHAN_STATS_BYTE_SIZE		4
#define cOCT6100_TLV_MAX_LENGTH_DEBUG_CHAN_STATS_BYTE_SIZE		4
#define cOCT6100_TLV_MIN_LENGTH_HOT_CHANNEL_SELECT_DWORD_BASE	4
#define cOCT6100_TLV_MAX_LENGTH_HOT_CHANNEL_SELECT_DWORD_BASE	4
#define cOCT6100_TLV_MIN_LENGTH_TIMESTAMP_DWORD_BASE			4
#define cOCT6100_TLV_MAX_LENGTH_TIMESTAMP_DWORD_BASE			4
#define cOCT6100_TLV_MIN_LENGTH_AF_WRITE_PTR_BYTE_OFFSET		4
#define cOCT6100_TLV_MAX_LENGTH_AF_WRITE_PTR_BYTE_OFFSET		4
#define cOCT6100_TLV_MIN_LENGTH_RECORDED_PCM_EVENT_BYTE_SIZE	4
#define cOCT6100_TLV_MAX_LENGTH_RECORDED_PCM_EVENT_BYTE_SIZE	4
#define cOCT6100_TLV_MIN_LENGTH_MATRIX_WP_DWORD_BASE			4
#define cOCT6100_TLV_MAX_LENGTH_MATRIX_WP_DWORD_BASE			4
#define cOCT6100_TLV_MIN_LENGTH_DEBUG_CHAN_LITE_STATS_BYTE_SIZE	4
#define cOCT6100_TLV_MAX_LENGTH_DEBUG_CHAN_LITE_STATS_BYTE_SIZE	4
#define cOCT6100_TLV_MIN_LENGTH_IMAGE_TYPE						4
#define cOCT6100_TLV_MAX_LENGTH_IMAGE_TYPE						4
#define cOCT6100_TLV_MIN_LENGTH_MAX_WIRELINE_CHANNELS			4
#define cOCT6100_TLV_MAX_LENGTH_MAX_WIRELINE_CHANNELS			4
#define cOCT6100_TLV_MIN_LENGTH_AF_EVENT_CB_BYTE_SIZE			4
#define cOCT6100_TLV_MAX_LENGTH_AF_EVENT_CB_BYTE_SIZE			4
#define cOCT6100_TLV_MIN_LENGTH_BUFFER_PLAYOUT_SKIP_IN_EVENTS	4
#define cOCT6100_TLV_MAX_LENGTH_BUFFER_PLAYOUT_SKIP_IN_EVENTS	4
#define cOCT6100_TLV_MIN_LENGTH_DOUBLE_TALK_BEH_MODE			4
#define cOCT6100_TLV_MAX_LENGTH_DOUBLE_TALK_BEH_MODE			4
#define cOCT6100_TLV_MIN_LENGTH_SOUT_NOISE_BLEACHING			4
#define cOCT6100_TLV_MAX_LENGTH_SOUT_NOISE_BLEACHING			4
#define cOCT6100_TLV_MIN_LENGTH_IDLE_CODE_DETECTION				4
#define cOCT6100_TLV_MAX_LENGTH_IDLE_CODE_DETECTION				4
#define cOCT6100_TLV_MIN_LENGTH_NLP_STATISTICS					4
#define cOCT6100_TLV_MAX_LENGTH_NLP_STATISTICS					4


/*****************************  TYPES  ***************************************/

/************************** FUNCTION PROTOTYPES  *****************************/

UINT32 Oct6100ApiProcessTlvRegion(
				IN OUT	tPOCT6100_INSTANCE_API		f_pApiInstance );

UINT32 Oct6100ApiInterpretTlvEntry(
				IN OUT	tPOCT6100_INSTANCE_API		f_pApiInstance,
				IN		UINT32						f_ulTlvFieldType,
				IN		UINT32						f_ulTlvFieldLength,
				IN		UINT32						f_ulTlvValueAddress );

UINT32 Oct6100ApiTlvCheckLengthField( 
				IN OUT	UINT32						f_ulTlvFieldLength,
				IN		UINT32						f_ulMinLengthValue,
				IN		UINT32						f_ulMaxLengthValue );

UINT32 Oct6100ApiTlvReadDword( 
				IN OUT	tPOCT6100_INSTANCE_API		f_pApiInstance,
				IN		UINT32						f_ulAddress,
				OUT		PUINT32						f_pulReadData );

UINT32 Oct6100ApiTlvReadBitOffsetStruct( 
				IN OUT	tPOCT6100_INSTANCE_API		f_pApiInstance,
				IN		UINT32						f_ulAddress,
				OUT		tPOCT6100_TLV_OFFSET		f_pBitOffsetStruct );

#endif /* __OCT6100_TLV_PRIV_H__ */
