#ifndef __WANPIPEMON_API__
#define __WANPIPEMON_API__ 

#define MAX_CMD_ARG 10
#define MAX_CMD_LENGTH 15
#define DEFAULT_TRACE_LEN 39
#define DO_COMMAND(packet)	DoCommand((wan_udp_hdr_t*)&packet)

#define UDP_CHDLC_SIGNATURE	"CTPIPEAB"
#define UDP_PPP_SIGNATURE 	"PTPIPEAB"
#define UDP_FR_SIGNATURE        "FPIPE8ND"
#define UDP_X25_SIGNATURE       "XLINK8ND"

/* Trace delay value in micro seconds */
#define WAN_TRACE_DELAY		20000  

struct cmd_menu_lookup_t
{
	unsigned char *cmd_menu_name;
	char **cmd_menu_ptr;
};

typedef int	config_t(void);
typedef int 	usage_t(void);
typedef int 	main_t(char*,int,char**);
typedef int 	dis_trace_t(void);
typedef char **	main_menu_t(int *len);
typedef char ** cmd_menu_t(char *cmd_name,int *len);	
typedef void	ft1_cfg_t(void);

struct fun_protocol {
	int		protocol_id;
	unsigned char   prot_name[10];
	config_t*	config;
	usage_t*	usage;
	main_t*		main;
	dis_trace_t*	disable_trace;
	main_menu_t*	get_main_menu;
	cmd_menu_t*	get_cmd_menu;
	ft1_cfg_t*	read_FT1_status;
	ft1_cfg_t*	set_FT1_mode;
	unsigned char	mbox_offset;
};

#define DECODE_PROT(prot)((prot==WANCONFIG_FR)?"Frame Relay": \
			  (prot==WANCONFIG_MFR)?"Frame Relay": \
		          (prot==WANCONFIG_PPP)?"PPP Point-to-Point":\
		          (prot==WANCONFIG_CHDLC)?"Cisco HDLC": \
		          (prot==WANCONFIG_X25)?"X25": \
		          (prot==WANCONFIG_ADSL)?"ADSL: Eth,IP,PPP/ATM":\
			  (prot==WANCONFIG_ATM)?"ATM":\
			  (prot==WANCONFIG_AFT)?"AFT":\
			  (prot==WANCONFIG_AFT_TE1)?"AFT_TE1":\
			  (prot==WANCONFIG_AFT_TE3)?"AFT_TE3":\
			  (prot==WANCONFIG_AFT_ANALOG)?"AFT_ANALOG":\
			  (prot==WANCONFIG_ZAP)?"Zaptel":\
							"Unknown")

#define EXEC_PROT_FUNC(func,prot,err,arg) {\
	int i=0; \
	err=WAN_FALSE; \
	for(;;){ \
		if (function_lookup[i].protocol_id == 0){\
			printf("\nProtocol: %s support not compiled in!\n\n", \
					DECODE_PROT(prot)); \
			break;\
		}\
		\
		if (function_lookup[i].protocol_id == prot){\
			if (function_lookup[i].func){\
				err=function_lookup[i].func arg;\
				break; \
			}\
			printf("\nProtocol: %s support not compiled in!\n\n", \
					DECODE_PROT(prot)); \
			break;\
		}\
		i++;\
	}\
}

#define EXEC_PROT_VOID_FUNC(func,prot,arg) {\
	int i=0; \
	for(;;){ \
		if (function_lookup[i].protocol_id == 0){\
			printf("\nProtocol: %s support not compiled in!\n\n", \
					DECODE_PROT(prot)); \
			break;\
		}\
		\
		if (function_lookup[i].protocol_id == prot){\
			if (function_lookup[i].func){\
				function_lookup[i].func arg;\
				break; \
			}\
			printf("\nProtocol: %s support not compiled in!\n\n", \
					DECODE_PROT(prot)); \
			break;\
		}\
		i++;\
	}\
}

#define EXEC_NAME_FUNC(func,name,arg) {\
	int i=0; \
	for(;;){ \
		if (function_lookup[i].protocol_id == 0){\
			printf("\nProtocol: '%s' support not compiled in!\n\n", \
					name); \
			break;\
		}\
		\
		if (strcmp(function_lookup[i].prot_name,name)==0){\
			if (function_lookup[i].func){\
				function_lookup[i].func arg;\
				break;\
			}\
			printf("\nProtocol: '%s' support not compiled in!\n\n", \
					name); \
			break;\
		}\
		i++;\
	}\
}


#define FRAME 0x01
#define LAPB  0x02
#define X25   0x04
#define PPP   0x08
#define CHDLC 0x10
#define ETH   0x20
#define IP    0x40
#define ALL_PROT (FRAME|LAPB|X25|PPP|CHDLC);

#define DATA 0x1
#define PROT 0x2
#define ALL_X25 (DATA|PROT)

typedef struct {
	unsigned char prot_name[15];
	signed char prot_index;
	unsigned int  pcap_prot;
} trace_prot_t;


/* "libpcap" file header (minus magic number). */
struct pcap_hdr {
    u_int32_t    	magic;          /* magic */
    unsigned short	version_major;	/* major version number */
    unsigned short	version_minor;	/* minor version number */
    u_int32_t	thiszone;	/* GMT to local correction */
    u_int32_t	sigfigs;	/* accuracy of timestamps */
    u_int32_t	snaplen;	/* max length of captured packets, in octets */
    u_int32_t	network;	/* data link type */
};

/* "libpcap" record header. */
struct pcaprec_hdr {
    u_int32_t	ts_sec;		/* timestamp seconds */
    u_int32_t	ts_usec;	/* timestamp microseconds */
    u_int32_t	incl_len;	/* number of octets of packet saved in file */
    u_int32_t	orig_len;	/* actual length of packet */
};



enum {
	WP_OUT_TRACE_RAW,
	WP_OUT_TRACE_INTERP,
	WP_OUT_TRACE_PCAP,
	WP_OUT_TRACE_INTERP_IPV4,
	WP_OUT_TRACE_ATM_RAW_PHY,
	WP_OUT_TRACE_ATM_INTERPRETED_PHY,
	WP_OUT_TRACE_HDLC
};

#define WP_TRACE_OUTGOING 0x01
#define WP_TRACE_INCOMING 0x02
#define WP_TRACE_ABORT    0x04
#define WP_TRACE_CRC	  0x08
#define WP_TRACE_OVERRUN  0x10


typedef struct {
	unsigned char *data;
	unsigned int len;
	unsigned int status;
	unsigned short timestamp;
	unsigned long  systimestamp;
	unsigned int type;
	unsigned int link_type;
	unsigned int prot_criteria;
	unsigned char trace_all_data;
	unsigned int pkts_written;
	unsigned char init;
	time_t	 sec,usec;
	FILE *output_file;
	unsigned int sub_type;
} wp_trace_output_iface_t;



#pragma pack(1)
typedef struct {
        unsigned char link_address;     /* Broadcast or Unicast */
        unsigned char control;
        unsigned short packet_type;     /* IP/SLARP/CDP */
} cisco_header_t;

typedef struct {
        u_int32_t code;     /* Slarp Control Packet Code */
        union {
                struct {
                        u_int32_t address;  /* IP address */
                        u_int32_t mask;     /* IP mask    */
                        unsigned short reserved[3];
                } address;
                struct {
                        u_int32_t my_sequence;
                        u_int32_t your_sequence;
                        unsigned short reliability;
                        unsigned short t1;      /* time alive (upper) */
                        unsigned short t2;      /* time alive (lower) */
                } keepalive;
        } un;
} cisco_slarp_t;
#pragma pack()

/* Link addresses */
#define CISCO_ADDR_UNICAST      0x0F
#define CISCO_ADDR_BCAST        0x8F

/* Packet Types */
#define CISCO_PACKET_IP         0x0800
#define CISCO_PACKET_SLARP      0x8035
#define CISCO_PACKET_CDP        0x2000

/* Packet Codes */
#define SLARP_REQUEST   0
#define SLARP_REPLY     1
#define SLARP_KEEPALIVE 2

#endif
