/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*\

File:  oct6100_errors.h

    Copyright (c) 2001-2008 Octasic Inc.
    
Description: 

	Header file containing all defines used for error codes.

This file is part of the Octasic OCT6100 GPL API . The OCT6100 GPL API  is 
free software; you can redistribute it and/or modify it under the terms of 
the GNU General Public License as published by the Free Software Foundation; 
either version 2 of the License, or (at your option) any later version.

The OCT6100 GPL API is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License 
for more details. 

You should have received a copy of the GNU General Public License 
along with the OCT6100 GPL API; if not, write to the Free Software 
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.

$Octasic_Release: OCT612xAPI-01.01.01 $

$Octasic_Revision: 208 $

\*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/

#ifndef __OCT6100_ERRORS_H__
#define __OCT6100_ERRORS_H__

/*****************************  INCLUDE FILES  *******************************/

#include "octdef.h"

/*****************************  DEFINES  *************************************/

#define cOCT6100_ERR_OK		0x00000000
#define cOCT6100_ERR_BASE	0x00100000

#define	cOCT6100_NOT_SUPPORTED_BASE											(0xFF000 + cOCT6100_ERR_BASE)

/* Not supported defines. */
#define cOCT6100_ERR_NOT_SUPPORTED_OPEN_DEBUG_RECORD						(0x00000 + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_NLP_CONTROL						(0x00001 + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_BKG_NOISE_FREEZE					(0x00002 + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_SIN_DC_OFFSET_REM				(0x00003 + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_RIN_DC_OFFSET_REM				(0x00004 + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_RIN_AUTO_LC						(0x00005 + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_SOUT_AUTO_LC						(0x00006 + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_ANR								(0x00007 + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_TAIL_DISPLACEMENT				(0x00008 + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_ENCODING							(0x00009 + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_DECODING							(0x0000A + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_LAW_TRANSLATION					(0x0000B + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_ACOUSTIC_ECHO					(0x0000C + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_DEFAULT_ERL						(0x0000D + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_DOUBLE_TALK						(0x0000E + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_NON_LINEARITY_B					(0x0000F + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_AEC_DEFAULT_ERL					(0x00010 + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_RIN_HIGH_LEVEL_COMP				(0x00011 + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_PER_CHAN_TAIL					(0x00012 + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_SIL_SUP							(0x00013 + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_OPEN_ACOUSTIC_ECHO						(0x00014 + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_OPEN_TAIL_DISPLACEMENT_VALUE				(0x00015 + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_OPEN_MAX_ECHO_CHANNELS_VALUE				(0x00016 + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_ALE								(0x00017 + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_NLE								(0x00018 + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_ROUT_NR							(0x00019 + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_SIN_MUTE_FEATURES				(0x0001A + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_ANR_SNR_ENHANCEMENT				(0x0001B + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_ANR_SEGREGATION					(0x0001C + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_OPEN_USE_SYNCH_TIMESTAMP					(0x0001D + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_TAIL_LENGTH						(0x0001E + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_TONE_DISABLER_ACTIVATION_DELAY	(0x0001F + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_ACOUSTIC_ECHO_TAIL_LENGTH		(0x00020 + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_MUSIC_PROTECTION					(0x00021 + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_DEBUG_DATA_MODE_120S						(0x00022 + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_TONE_NOT_PRESENT_IN_FIRMWARE				(0x00023 + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_DOUBLE_TALK_BEHAVIOR_MODE				(0x00024 + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_IDLE_CODE_DETECTION						(0x00025 + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_IDLE_CODE_DETECTION_CONFIG				(0x00026 + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_PRODUCTION_BIST_SHORT					(0x00027 + cOCT6100_NOT_SUPPORTED_BASE)


#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_ROUT_NOISE_REDUCTION_GAIN		(0x0002B + cOCT6100_NOT_SUPPORTED_BASE)

#define cOCT6100_ERR_NOT_SUPPORTED_BUFFER_PLAYOUT				(0x00100 + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_CNR					(0x00101 + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CONF_BRIDGE					(0x00102 + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CALLER_ID					(0x00104 + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_NOISE_BLEACHING		(0x00105 + cOCT6100_NOT_SUPPORTED_BASE)

#define cOCT6100_ERR_NOT_SUPPORTED_CHANNEL_TONE_REMOVAL			(0x00300 + cOCT6100_NOT_SUPPORTED_BASE)
#define cOCT6100_ERR_NOT_SUPPORTED_DOMINANT_SPEAKER				(0x00301 + cOCT6100_NOT_SUPPORTED_BASE)



#define cOCT6100_ERR_OPEN_INVALID_DEVICE						(0x03000 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_INSUFFICIENT_EXTERNAL_MEMORY			(0x03001 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_MEMORY_CHIP_SIZE						(0x03002 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_UP_CLK_FREQ							(0x03003 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_USER_CHIP_ID							(0x03004 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_MULTI_PROCESS_SYSTEM					(0x03005 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_MAX_RW_ACCESSES						(0x03006 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_IMAGE_SIZE							(0x03007 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_IMAGE_FILE							(0x03008 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_MEM_CLK_FREQ							(0x03009 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_MEMORY_CHIPS_NUMBER					(0x0300A + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_TOTAL_MEMORY_SIZE						(0x0300B + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_USE_SYNCH_TIMESTAMP					(0x0300C + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_TIMESTAMP_STREAM						(0x0300D + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_TIMESTAMP_TIMESLOT					(0x0300E + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_TIMESTAMP_TSSTS						(0x0300F + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_TDM_STREAM_FREQS						(0x03010 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_TDM_SAMPLING							(0x03011 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_FAST_H100_MODE						(0x03012 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_MAX_ECHO_CHANNELS						(0x03013 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_MAX_PLAYOUT_BUFFERS					(0x03014 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_MAX_TSI_CNCTS							(0x03015 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_MAX_PHASING_TSSTS						(0x03016 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_EXTERNAL_MEM_BIST_FAILED				(0x03017 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_EXTERNAL_MEM_BIST_TIMEOUT				(0x03018 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_SDRAM_BIST_FAILED						(0x03019 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_CORRUPTED_IMAGE						(0x0301A + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_CPU_REG_BIST_ERROR					(0x0301B + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_SOFT_TONE_EVENT_SIZE					(0x0301C + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_INTERRUPT_POLARITY					(0x0301D + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_FATAL_GENERAL_CONFIG					(0x0301E + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_MAX_REMOTE_DEBUG_SESSIONS				(0x0301F + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_ENABLE_MEM_CLK_OUT					(0x03020 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_MAX_TDM_STREAM						(0x03021 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_MAX_CONF_BRIDGES						(0x03022 + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_OPEN_AF_CPU_TIMEOUT						(0x03024 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_MEMORY_TYPE							(0x03025 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_FATAL_MEMORY_CONFIG					(0x03026 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_ERROR_MEMORY_CONFIG					(0x03027 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_ERROR_OVERFLOW_TONE_EVENTS_CONFIG		(0x03028 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_ERROR_H100_CONFIG						(0x03029 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_FATAL_MEMORY_TIMEOUT					(0x0302A + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_ERROR_MEMORY_TIMEOUT					(0x0302B + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_ERROR_OVERFLOW_TONE_EVENTS_TIMEOUT	(0x0302C + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_ERROR_H100_TIMEOUT					(0x0302D + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_IMAGE_WRITE_FAILED					(0x0302E + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_CRC_ERROR								(0x0302F + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_EGO_TIMEOUT							(0x03030 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_SOFT_DEBUG_EVENT_BUF_SIZE				(0x03031 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_TONE_INFO_START_TAG_NOT_FOUND			(0x03032 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_TONE_INFO_STOP_TAG_NOT_FOUND			(0x03033 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_INVALID_TONE_EVENT					(0x03034 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_INVALID_TONE_NAME						(0x03035 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_INVALID_EVENT_NUMBER_SIZE				(0x03036 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_INTERNAL_MEMORY_BIST					(0x03037 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_TAIL_DISPLACEMENT						(0x03038 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_DEBUG_CHANNEL_RECORDING				(0x03039 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_MAX_BIDIR_CHANNELS					(0x0303A + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_FUNCTIONAL_BIST_FAILED				(0x0303C + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_OPEN_MAX_ADPCM_CHANNELS					(0x0303E + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_OPEN_ENABLE_EXT_TONE_DETECTION				(0x03040 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_SOFT_PLAYOUT_STOP_EVENT_SIZE			(0x03041 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_INVALID_FIRMWARE_OR_CAPACITY_PINS		(0x03042 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_ENABLE_ACOUSTIC_ECHO					(0x03043 + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_OPEN_USER_WRITE_BURST_FAILED				(0x03045 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_USER_WRITE_SMEAR_FAILED				(0x03046 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_USER_READ_BURST_FAILED				(0x03047 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_MAX_FLEXIBLE_CONF_PARTICIPANTS		(0x03048 + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_OPEN_DEBUG_MEM_INDEX						(0x03051 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_ENABLE_CALLER_ID						(0x03052 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_CALLER_ID_PLAYOUT_BUFFERS				(0x03053 + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_OPEN_ENABLE_PRODUCTION_BIST				(0x03055 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_PRODUCTION_BIST_ACTIVATED				(0x03056 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_NUM_PRODUCTION_BIST_LOOPS				(0x03057 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_PRODUCTION_BOOT_FAILED				(0x03058 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_PRODUCTION_BIST_CONF_FAILED			(0x03059 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_PRODUCTION_BIST_POUCH_ERROR			(0x0305A + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_INVALID_TLV_LENGTH					(0x0305B + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_PRODUCTION_BIST_MODE					(0x0305C + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_OPEN_INVALID_IMAGE_FILE					(0x0305D + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_OPEN_ENABLE_2100_STOP_EVENT				(0x03060 + cOCT6100_ERR_BASE)


#define cOCT6100_ERR_CAP_PINS_INVALID_CHIP_STATE				(0x03081 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CAP_PINS_INVALID_CAPACITY_VALUE			(0x03082 + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_TSI_CNCT_ALL_CHANNELS_ARE_OPENED			(0x04000 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_TSI_CNCT_DISABLED							(0x04001 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_TSI_CNCT_INVALID_HANDLE					(0x04002 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_TSI_CNCT_INPUT_TIMESLOT					(0x04003 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_TSI_CNCT_INPUT_STREAM						(0x04004 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_TSI_CNCT_OUTPUT_TIMESLOT					(0x04005 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_TSI_CNCT_OUTPUT_STREAM						(0x04006 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_TSI_CNCT_INPUT_PCM_LAW						(0x04007 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_TSI_CNCT_TIMESLOT							(0x04008 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_TSI_CNCT_STREAM							(0x04009 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_TSI_CNCT_TSST_RESERVED						(0x0400A + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_TSI_CNCT_NOT_OPEN							(0x0400B + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_TSI_CNCT_ASSOCIATED_TSST_RESERVED			(0x0400C + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_TSI_CNCT_NO_MORE_TSI_AVAILABLE				(0x0400D + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_BUFFER_PLAYOUT_DISABLED					(0x05000 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_PATTERN						(0x05001 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_TOO_SMALL					(0x05002 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_PCM_LAW						(0x05003 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_ALL_BUFFERS_OPEN			(0x05004 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_BUF_SIZE					(0x05005 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_BUF_INDEX					(0x05006 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_NOT_OPEN					(0x05007 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_ACTIVE_DEPENDENCIES			(0x05008 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_CHANNEL_HANDLE_INVALID		(0x05009 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_CHANNEL_NOT_OPEN			(0x0500A + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_ROUT_PORT_PLAYING			(0x0500B + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_SOUT_PORT_PLAYING			(0x0500C + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_PORT_INVALID				(0x0500D + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_PLAYOUT_PORT				(0x0500E + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_ADD_EVENT_BUF_FULL			(0x0500F + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_ADD_REPEAT					(0x05010 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_ADD_MIXING					(0x05011 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_STOP_CLEANLY				(0x05012 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_NOT_STARTED					(0x05013 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_WRITE_BYTE_COUNT			(0x05015 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_ECHO_OP_MODE				(0x05016 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_BLOCK_LENGTH_INVALID		(0x05017 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_BLOCK_OFFSET_INVALID		(0x05018 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_EVENT_RESET					(0x05019 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_EVENT_BUF_EMPTY				(0x0501A + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_MAX_EVENT					(0x0501B + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_EVENT_DISABLED				(0x0501C + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_NOTIFY_ON_STOP				(0x0501D + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_ALLOW_ACTIVE				(0x0501E + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_STILL_ACTIVE				(0x0501F + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_REPEAT_USED					(0x05020 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_NLP_DISABLED				(0x05021 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_MALLOC_ZERO					(0x05022 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_NO_MEMORY					(0x05023 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_MALLOC_POINT_NOT_FOUND		(0x05024 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_ADD_REPEAT_COUNT			(0x05025 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_ADD_GAIN_DB					(0x05026 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_BUFFER_PLAYOUT_LIST_EMPTY					(0x05027 + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_MEMORY_ALL_TSI_MEM_ENTRY_RESERVED			(0x06000 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_MEMORY_ALL_ECHO_MEM_ENTRY_RESERVED			(0x06002 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_MEMORY_EXTERNAL_MEMORY_FULL				(0x06003 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_MEMORY_ALL_CONVERSION_MEM_ENTRY_RESERVED	(0x06004 + cOCT6100_ERR_BASE)


#define cOCT6100_ERR_CHANNEL_DISABLED							(0x07000 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_INVALID_HANDLE						(0x07001 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_RIN_NUM_TSSTS						(0x07002 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_SIN_NUM_TSSTS						(0x07003 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ROUT_NUM_TSSTS						(0x07004 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_SOUT_NUM_TSSTS						(0x07005 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_RIN_TIMESLOT						(0x07006 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_RIN_STREAM							(0x07007 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_SIN_TIMESLOT						(0x07008 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_SIN_STREAM							(0x07009 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ROUT_TIMESLOT						(0x0700A + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ROUT_STREAM						(0x0700B + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_SOUT_TIMESLOT						(0x0700C + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_SOUT_STREAM						(0x0700D + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_MISSING_TSST						(0x07012 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_SIL_SUP_ENABLE						(0x07013 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_PHASING_TYPE						(0x07014 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_INVALID_PHASING_HANDLE				(0x07015 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_PHASING_TSST_NOT_OPEN				(0x07016 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_PHASING_INVALID_PHASE				(0x07017 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_DEBUG								(0x07018 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ECHO_OP_MODE						(0x0701F + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_SIN_DC_OFFSET_REM					(0x07020 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_RIN_DC_OFFSET_REM					(0x07021 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_RIN_LEVEL_CONTROL					(0x07022 + cOCT6100_ERR_BASE)	
#define cOCT6100_ERR_CHANNEL_SOUT_LEVEL_CONTROL					(0x07023 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_RIN_LEVEL_CONTROL_GAIN				(0x07024 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_SOUT_LEVEL_CONTROL_GAIN			(0x07025 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_SOUT_ADAPT_NOISE_REDUCTION			(0x07026 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ALL_CHANNELS_ARE_OPENED			(0x07027 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_NOT_OPEN							(0x07029 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ADPCM_NIBBLE						(0x0702A + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_TSST_ADD_PORT						(0x0702B + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_TSST_ADD_TIMESLOT					(0x0702C + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_TSST_ADD_STREAM					(0x0702D + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ECHO_OP_MODE_INVALID				(0x0702E + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_RIN_PCM_LAW						(0x0702F + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_SIN_PCM_LAW						(0x07030 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ROUT_PCM_LAW						(0x07031 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_SOUT_PCM_LAW						(0x07032 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_DECODER_PORT						(0x07033 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ENCODER_PORT						(0x07034 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_DECODING_RATE						(0x07035 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ENCODING_RATE						(0x07036 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ENABLE_NLP							(0x07037 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_COMFORT_NOISE_MODE					(0x07038 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_PHASING_TSST_REQUIRED				(0x07039 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_SIL_SUP_INVALID_ENCODER_PORT		(0x0703A + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_MODIFY_CODEC_CONFIG				(0x0703B + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_MODIFY_VQE_CONFIG					(0x0703C + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_MODIFY_TDM_CONFIG					(0x0703D + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ECHO_OP_MODE_RIN_PORT_INVALID		(0x0703E + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ECHO_OP_MODE_SIN_PORT_INVALID		(0x0703F + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_TSST_REMOVE_PORT					(0x07041 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_TSST_REMOVE_TIMESLOT				(0x07042 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_TSST_REMOVE_STREAM					(0x07043 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_TSST_REMOVE_INVALID_TSST			(0x07044 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_GET_STATS_MAX_BROADCAST_TSST		(0x07045 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ROUT_BROADCAST_TIMESLOT			(0x07046 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ROUT_BROADCAST_STREAM				(0x07047 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_SOUT_BROADCAST_TIMESLOT			(0x07048 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_SOUT_BROADCAST_STREAM				(0x07049 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ACTIVE_DEPENDENCIES				(0x0704A + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_TONE_DISABLER_ENABLE				(0x0704B + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_TAIL_LENGTH						(0x07053 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_TAIL_DISPLACEMENT					(0x07054 + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_CHANNEL_INVALID_RIN_CB_SIZE				(0x07058 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_TSST_REMOVE_NO_BROADCAST_TSST		(0x07059 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_INVALID_CODEC_POSITION				(0x0705A + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_STATS_RESET						(0x0705B + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ENABLE_TAIL_DISPLACEMENT			(0x0705C + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_BIDIR_CHANNEL_HANDLE				(0x0705E + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_BIDIR_FIRST_CHANNEL_HANDLE			(0x0705F + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_BIDIR_SECOND_CHANNEL_HANDLE		(0x07060 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_CODEC_ACTIVATED					(0x07061 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ALREADY_BIDIR						(0x07062 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ALL_BIDIR_CHANNELS_ARE_OPENED		(0x07063 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_FIRST_CHAN_SOUT_PORT				(0x07064 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_FIRST_CHAN_RIN_PORT				(0x07065 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_SECOND_CHAN_SOUT_PORT				(0x07066 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_SECOND_CHAN_RIN_PORT				(0x07067 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_BIDIR_PCM_LAW						(0x07068 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_BIDIR_CHAN_NOT_OPEN				(0x07069 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_RIN_ROUT_LAW_CONVERSION			(0x0706A + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_SIN_SOUT_LAW_CONVERSION			(0x0706B + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_PART_OF_BIDIR_CHANNEL				(0x0706C + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_CHANNEL_NO_VALID_TDM_CLOCKS				(0x0706E + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_CHANNEL_OUT_OF_TSI_MEMORY					(0x07073 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_TONE_REMOVAL						(0x07075 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ACOUSTIC_ECHO						(0x07077 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_DEFAULT_ERL						(0x07079 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_DOUBLE_TALK						(0x0707B + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_PHASE_TYPE_REQUIRED				(0x0707C + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_SIL_SUP_NLP_MUST_BE_ENABLED		(0x0707D + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ENABLE_EXT_TONE_DETECTION			(0x0707E + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_EXT_TONE_DETECTION_DECODER_PORT	(0x0707F + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_EXT_TONE_DETECTION_DISABLED		(0x07080 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_NON_LINEARITY_B					(0x07082 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_FIRST_CHAN_IN_CONFERENCE			(0x07083 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_SECOND_CHAN_IN_CONFERENCE			(0x07084 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_TAIL_DISPLACEMENT_CANNOT_MODIFY	(0x07085 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_NON_LINEARITY_B_CANNOT_MODIFY		(0x07086 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ACOUSTIC_ECHO_NOT_ENABLED			(0x07087 + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_CHANNEL_BIDIR_DISABLED						(0x0708B + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_CHANNEL_TAIL_DISPLACEMENT_INVALID			(0x0708D + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_PER_CHAN_TAIL_DISPLACEMENT			(0x0708E + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_SOUT_CONFERENCE_NOISE_REDUCTION	(0x0708F + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_AEC_DEFAULT_ERL					(0x07092 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ECHO_OP_MODE_NLP_REQUIRED			(0x07093 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_RIN_AUTO_LEVEL_CONTROL				(0x07094 + cOCT6100_ERR_BASE)	
#define cOCT6100_ERR_CHANNEL_SOUT_AUTO_LEVEL_CONTROL			(0x07095 + cOCT6100_ERR_BASE)	
#define cOCT6100_ERR_CHANNEL_RIN_AUTO_LEVEL_CONTROL_TARGET		(0x07096 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_SOUT_AUTO_LEVEL_CONTROL_TARGET		(0x07097 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_RIN_AUTO_LEVEL_MANUAL				(0x07098 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_SOUT_AUTO_LEVEL_MANUAL				(0x07099 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_RIN_HIGH_LEVEL_COMP				(0x0709A + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_RIN_AUTO_LEVEL_HIGH_LEVEL_COMP		(0x0709C + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_RIN_HIGH_LEVEL_COMP_MANUAL			(0x0709D + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_RIN_HIGH_LEVEL_COMP_THRESHOLD		(0x0709E + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_MUTE_MASK							(0x0709F + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_MUTE_MASK_SIN						(0x070A0 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ALE_RATIO							(0x070A1 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_NLE_FLAG							(0x070A2 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ALE_NLE_SIMULTANEOUSLY				(0x070A3 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ROUT_NOISE_REDUCTION				(0x070A4 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ANR_SNR_ENHANCEMENT				(0x070A5 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ANR_SEGREGATION					(0x070A6 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_NLE_RATIO							(0x070A7 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_APPLY_TO_ALL_CHANNELS				(0x070A8 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ROUT_STREAM_UNASSIGN				(0x070A9 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ROUT_TIMESLOT_UNASSIGN				(0x070AA + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_RIN_STREAM_UNASSIGN				(0x070AB + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_RIN_TIMESLOT_UNASSIGN				(0x070AC + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_SOUT_STREAM_UNASSIGN				(0x070AD + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_SOUT_TIMESLOT_UNASSIGN				(0x070AE + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_SIN_STREAM_UNASSIGN				(0x070AF + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_SIN_TIMESLOT_UNASSIGN				(0x070B0 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_DISABLE_TONE_DETECTION				(0x070B1 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_STOP_BUFFER_PLAYOUT				(0x070B2 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_REMOVE_CONF_BRIDGE_PARTICIPANT		(0x070B3 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_REMOVE_BROADCAST_TSSTS				(0x070B4 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_TONE_DISABLER_ACTIVATION_DELAY		(0x070B5 + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_CHANNEL_OUT_OF_MIXER_EVENTS				(0x070B8 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ACOUSTIC_ECHO_TAIL_LENGTH			(0x070B9 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ENABLE_MUSIC_PROTECTION			(0x070BA + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_TAIL_LENGTH_INVALID				(0x070BB + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ACOUSTIC_ECHO_TAIL_SUM				(0x070BC + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_DOUBLE_TALK_MODE					(0x070BD + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_SOUT_NOISE_BLEACHING				(0x070BE + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_SOUT_NOISE_BLEACHING_NR			(0x070BF + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ANR_CNR_SIMULTANEOUSLY				(0x070C0 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_IDLE_CODE_DETECTION				(0x070C1 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_MUST_ENABLE_TONE_DISABLER			(0x070C2 + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_CHANNEL_RIN_AUTO_LEVEL_CONTROL_REQUIRED	(0x070C5 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_SOUT_AUTO_LEVEL_CONTROL_REQUIRED	(0x070C6 + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_CHANNEL_AUTO_LEVEL_CONTROL_REQUIRED		(0x070C8 + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_CHANNEL_COMFORT_NOISE_REQUIRED				(0x070CB + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CHANNEL_ROUT_NOISE_REDUCTION_GAIN			(0x070CC + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_PHASING_TSST_ALL_ENTRIES_ARE_OPENED		(0x08000 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_PHASING_TSST_DISABLED						(0x08001 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_PHASING_TSST_INVALID_HANDLE				(0x08002 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_PHASING_TSST_TIMESLOT						(0x08003 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_PHASING_TSST_STREAM						(0x08004 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_PHASING_TSST_PHASING_LENGTH				(0x08005 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_PHASING_TSST_NOT_OPEN						(0x08006 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_PHASING_TSST_ACTIVE_DEPENDENCIES			(0x08007 + cOCT6100_ERR_BASE)


#define cOCT6100_ERR_CONF_BRIDGE_INVALID_HANDLE					(0x09000 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_DISABLED						(0x09001 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_NOT_OPEN						(0x09002 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_ACTIVE_DEPENDENCIES			(0x09003 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_CHANNEL_ADD_INVALID_HANDLE		(0x09004 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_MIXER_EVENT_NOT_FOUND					(0x09005 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_ALL_BUFFERS_OPEN				(0x09006 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_CHANNEL_REMOVE_INVALID_HANDLE	(0x09007 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_CHAN_NOT_ON_BRIDGE				(0x09008 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_CHANNEL_ADD_MUTE				(0x09009 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_CHANNEL_MUTE_INVALID_HANDLE	(0x0900A + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_CHANNEL_MUTE_ALREADY_MUTED		(0x0900B + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_CHANNEL_MUTE_NOT_MUTED			(0x0900C + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_CHANNEL_ADD_CODEC_ACTIVE		(0x0900D + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_CHANNEL_ADD_MIXER_FULL			(0x0900E + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_CHANNEL_ALREADY_ON_BRIDGE		(0x0900F + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_CHANNEL_REMOVE_ALL				(0x09010 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_CHANNEL_ADD_EXT_TONE_ENABLED	(0x09011 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_INVALID_INPUT_PORT				(0x09012 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_CHANNEL_DOMINANT_SPEAKER		(0x09013 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_CHANNEL_BIDIR					(0x09015 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_CNR_MUST_BE_ENABLED			(0x09016 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_NLP_MUST_BE_ENABLED			(0x09017 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_FLEX_CONF						(0x09018 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_FLEX_CONF_PARTICIPANT_CNT		(0x09019 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_FLEX_CONF_LISTENER_MASK_INDEX	(0x0901A + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_FLEX_CONF_ALL_BUFFERS_OPEN		(0x0901B + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_FLEX_CONF_DISABLED				(0x0901C + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_FLEX_CONF_LISTENER_INDEX_USED	(0x0901D + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_SIMPLE_BRIDGE					(0x0901E + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_COPY_EVENTS					(0x0901F + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_CHANNEL_ADD_INVALID_TAP_HANDLE	(0x09020 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_FLEX_CONF_TAP_NOT_SUPPORTED	(0x09021 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_CHANNEL_TAP_NOT_ON_BRIDGE		(0x09022 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_CHANNEL_TAP_DEPENDENCY			(0x09023 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_CHANNEL_TAP_NOT_ON_SAME_BRIDGE	(0x09024 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_CHANNEL_ADD_TAP_SOUT_ONLY		(0x09025 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_CHANNEL_ADD_ALREADY_TAPPED		(0x09026 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_CHANNEL_TAP_ALWAYS_MUTE		(0x09027 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_CONF_BRIDGE_CHANNEL_LAW_CONVERSION			(0x09028 + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_MISC_CANNOT_ROUND_UP_NUMBER				(0x0A000 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_MISC_ASCII_CONVERSION_FAILED				(0x0A001 + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_TONE_DETECTION_CHANNEL_HANDLE_INVALID		(0x0B000 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_TONE_DETECTION_CHANNEL_NOT_OPEN			(0x0B001 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_TONE_DETECTION_TONE_NUMBER_INVALID			(0x0B002 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_TONE_DETECTION_TONE_NOT_ACTIVATED			(0x0B003 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_TONE_DETECTION_TONE_ACTIVATED				(0x0B004 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_TONE_DETECTION_TONE_NOT_AVAILABLE			(0x0B005 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_TONE_DETECTION_DISABLE_ALL					(0x0B006 + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_EVENTS_GET_TONE_RESET_BUFS					(0x0C000 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_EVENTS_TONE_BUF_EMPTY						(0x0C001 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_EVENTS_MAX_TONES							(0x0C002 + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_INTRPTS_RW_ERROR							(0x0D000 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_INTRPTS_NOT_ACTIVE							(0x0D001 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_INTRPTS_FATAL_GENERAL_CONFIG				(0x0D002 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_INTRPTS_FATAL_MEMORY_CONFIG				(0x0D003 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_INTRPTS_DATA_ERR_MEMORY_CONFIG				(0x0D004 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_INTRPTS_OVERFLOW_TONE_EVENTS_CONFIG		(0x0D005 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_INTRPTS_H100_ERROR_CONFIG					(0x0D006 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_INTRPTS_FATAL_GENERAL_TIMEOUT				(0x0D007 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_INTRPTS_FATAL_MEMORY_TIMEOUT				(0x0D008 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_INTRPTS_DATA_ERR_MEMORY_TIMEOUT			(0x0D009 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_INTRPTS_OVERFLOW_TONE_EVENTS_TIMEOUT		(0x0D00A + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_INTRPTS_H100_ERROR_TIMEOUT					(0x0D00B + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_INTRPTS_AF_TIMESTAMP_READ_TIMEOUT			(0x0D00C + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_INTRPTS_NLP_TIMESTAMP_READ_TIMEOUT			(0x0D00D + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_TSST_TIMESLOT								(0x0E000 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_TSST_STREAM								(0x0E001 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_TSST_TSST_RESERVED							(0x0E002 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_TSST_ASSOCIATED_TSST_RESERVED				(0x0E003 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_TSST_ALL_TSSTS_ARE_OPENED					(0x0E004 + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_MULTIPROC_API_INST_SHARED					(0x10000 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_MULTIPROC_API_INST_LOCAL					(0x10001 + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_DEBUG_CHANNEL_INVALID_HANDLE				(0x11000 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_DEBUG_PORT									(0x11001 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_DEBUG_READ_LENGTH							(0x11002 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_DEBUG_SOUT_READ_LENGTH						(0x11003 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_DEBUG_READ_DATA							(0x11004 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_DEBUG_GET_EVENTS_RESET_BUFS				(0x11005 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_DEBUG_GET_EVENTS_BUF_EMPTY					(0x11006 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_DEBUG_RECORD_RIN_PTR_INVALID				(0x11007 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_DEBUG_RECORD_SIN_PTR_INVALID				(0x11008 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_DEBUG_RECORD_ROUT_PTR_INVALID				(0x11009 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_DEBUG_RECORD_SOUT_PTR_INVALID				(0x1100A + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_DEBUG_RECORD_RAW_DATA_PTR_INVALID			(0x1100B + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_DEBUG_RECORD_LENGTH_INVALID				(0x1100C + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_DEBUG_RECORD_NO_CHAN_SELECTED				(0x1100D + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_DEBUG_PCM_LAW								(0x1100E + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_DEBUG_CHANNEL_RECORDING_DISABLED			(0x1100F + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_DEBUG_GET_DATA_MAX_BYTES					(0x11010 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_DEBUG_GET_DATA_PTR_INVALID					(0x11011 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_DEBUG_RC_CHANNEL_RECORDING_DISABLED		(0x11012 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_DEBUG_GET_DATA_MODE						(0x11013 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_DEBUG_CHANNEL_IN_POWER_DOWN				(0x11014 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_DEBUG_GET_DATA_CONTENT						(0x11015 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_DEBUG_GET_DATA_MODE_CANNOT_CHANGE			(0x11016 + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_MIXER_ALL_COPY_EVENT_ENTRY_OPENED			(0x12000 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_MIXER_COPY_EVENT_HANDLE					(0x12001 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_MIXER_SOURCE_CHAN_HANDLE					(0x12002 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_MIXER_DESTINATION_CHAN_HANDLE				(0x12003 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_MIXER_SOURCE_PORT							(0x12004 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_MIXER_DESTINATION_PORT						(0x12005 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_MIXER_EVENT_NOT_OPEN						(0x12006 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_MIXER_SOURCE_ADPCM_RESOURCES_ACTIVATED		(0x12007 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_MIXER_DEST_ADPCM_RESOURCES_ACTIVATED		(0x12008 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_MIXER_ALL_MIXER_EVENT_ENTRY_OPENED			(0x12009 + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_ADPCM_CHAN_DISABLED						(0x13000 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_ADPCM_CHAN_INVALID_HANDLE					(0x13001 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_ADPCM_CHAN_INPUT_TIMESLOT					(0x13002 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_ADPCM_CHAN_INPUT_STREAM					(0x13003 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_ADPCM_CHAN_OUTPUT_TIMESLOT					(0x13004 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_ADPCM_CHAN_OUTPUT_STREAM					(0x13005 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_ADPCM_CHAN_INPUT_NUM_TSSTS					(0x13006 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_ADPCM_CHAN_OUTPUT_NUM_TSSTS				(0x13007 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_ADPCM_CHAN_INPUT_PCM_LAW					(0x13008 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_ADPCM_CHAN_MODE							(0x13009 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_ADPCM_CHAN_ENCODING_RATE					(0x1300A + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_ADPCM_CHAN_DECODING_RATE					(0x1300B + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_ADPCM_CHAN_INCOMPATIBLE_NUM_TSSTS			(0x1300C + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_ADPCM_CHAN_NO_MORE_TSI_AVAILABLE			(0x1300D + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_ADPCM_CHAN_OUTPUT_PCM_LAW					(0x1300E + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_ADPCM_CHAN_ADPCM_NIBBLE_POSITION			(0x1300F + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_ADPCM_CHAN_NOT_OPEN						(0x13010 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_ADPCM_CHAN_ALL_ADPCM_CHAN_ARE_OPENED		(0x13011 + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_CHIP_STATS_RESET							(0x14000 + cOCT6100_ERR_BASE)



#define cOCT6100_ERR_PRODUCTION_BIST_DISABLED					(0x16000 + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_REMOTEDEBUG_RECEIVED_PKT_PAYLOAD			(0x2C000 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_REMOTEDEBUG_RESPONSE_PKT_PAYLOAD			(0x2C001 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_REMOTEDEBUG_RECEIVED_PKT_LENGTH			(0x2C002 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_REMOTEDEBUG_RESPONSE_PKT_LENGTH			(0x2C003 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_REMOTEDEBUG_ENDIAN_DETECTION_FIELD			(0x2C004 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_REMOTEDEBUG_CHECKSUM						(0x2C005 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_REMOTE_DEBUG_PARSING_ERROR					(0x2C006 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_REMOTEDEBUG_ALL_SESSIONS_OPEN				(0x2C007 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_REMOTEDEBUG_INVALID_PACKET					(0x2C008 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_REMOTEDEBUG_TRANSACTION_ANSWERED			(0x2C009 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_REMOTEDEBUG_INAVLID_SESSION_NUMBER			(0x2C00A + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_REMOTEDEBUG_INVALID_HOT_CHAN_INDEX			(0x2C00B + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_REMOTEDEBUG_DISABLED						(0x2C00C + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_REMOTEDEBUG_INVALID_RPC_COMMAND_NUM		(0x2C00D + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_TLV_TIMEOUT								(0x31000 + cOCT6100_ERR_BASE)

/* Fatal errors must always be greater or equal to 0xE000. */
#define cOCT6100_ERR_FATAL										(0xDE000 + cOCT6100_ERR_BASE)

#define cOCT6100_ERR_FATAL_DRIVER_WRITE_API						(0xDE000 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_FATAL_DRIVER_WRITE_EXT_API					(0xDE001 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_FATAL_DRIVER_WRITE_SMEAR_API				(0xDE002 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_FATAL_DRIVER_WRITE_BURST_API				(0xDE003 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_FATAL_DRIVER_READ_API						(0xDE004 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_FATAL_DRIVER_READ_BURST_API				(0xDE005 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_FATAL_DRIVER_READ_DEBUG_API				(0xDE006 + cOCT6100_ERR_BASE)
#define cOCT6100_ERR_FATAL_DRIVER_WRITE_ARRAY_API				(0xDE007 + cOCT6100_ERR_BASE)

#define	cOCT6100_FATAL_BASE										(0xDF000 + cOCT6100_ERR_BASE)

#define	cOCT6100_ERR_FATAL_0									(0x00000 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_1									(0x00001 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_2									(0x00002 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_3									(0x00003 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_4									(0x00004 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_5									(0x00005 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_6									(0x00006 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_7									(0x00007 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_8									(0x00008 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_9									(0x00009 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_A									(0x0000A + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_B									(0x0000B + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_C									(0x0000C + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_D									(0x0000D + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_E									(0x0000E + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_F									(0x0000F + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_10									(0x00010 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_11									(0x00011 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_12									(0x00012 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_13									(0x00013 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_14									(0x00014 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_15									(0x00015 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_16									(0x00016 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_17									(0x00017 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_18									(0x00018 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_19									(0x00019 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_1A									(0x0001A + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_1B									(0x0001B + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_1C									(0x0001C + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_1D									(0x0001D + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_1E									(0x0001E + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_1F									(0x0001F + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_20									(0x00020 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_21									(0x00021 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_22									(0x00022 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_23									(0x00023 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_24									(0x00024 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_25									(0x00025 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_26									(0x00026 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_27									(0x00027 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_28									(0x00028 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_29									(0x00029 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_2A									(0x0002A + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_2B									(0x0002B + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_2C									(0x0002C + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_2D									(0x0002D + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_2E									(0x0002E + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_2F									(0x0002F + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_30									(0x00030 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_31									(0x00031 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_32									(0x00032 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_33									(0x00033 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_34									(0x00034 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_35									(0x00035 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_36									(0x00036 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_37									(0x00037 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_38									(0x00038 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_39									(0x00039 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_3A									(0x0003A + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_3B									(0x0003B + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_3C									(0x0003C + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_3D									(0x0003D + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_3E									(0x0003E + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_3F									(0x0003F + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_40									(0x00040 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_41									(0x00041 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_42									(0x00042 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_43									(0x00043 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_44									(0x00044 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_45									(0x00045 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_46									(0x00046 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_47									(0x00047 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_48									(0x00048 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_49									(0x00049 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_4A									(0x0004A + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_4B									(0x0004B + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_4C									(0x0004C + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_4D									(0x0004D + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_4E									(0x0004E + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_4F									(0x0004F + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_50									(0x00050 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_51									(0x00051 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_52									(0x00052 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_53									(0x00053 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_54									(0x00054 + cOCT6100_FATAL_BASE)
#define	cOCT6100_ERR_FATAL_55									(0x00055 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_56									(0x00056 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_57									(0x00057 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_58									(0x00058 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_59									(0x00059 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_5A									(0x0005A + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_5B									(0x0005B + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_5C									(0x0005C + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_5D									(0x0005D + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_5E									(0x0005E + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_5F									(0x0005F + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_60									(0x00060 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_61									(0x00061 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_62									(0x00062 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_63									(0x00063 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_64									(0x00064 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_65									(0x00065 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_66									(0x00066 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_67									(0x00067 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_68									(0x00068 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_69									(0x00069 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_6A									(0x0006A + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_6B									(0x0006B + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_6C									(0x0006C + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_6D									(0x0006D + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_6E									(0x0006E + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_6F									(0x0006F + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_70									(0x00070 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_71									(0x00071 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_72									(0x00072 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_73									(0x00073 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_74									(0x00074 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_75									(0x00075 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_76									(0x00076 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_77									(0x00077 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_78									(0x00078 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_79									(0x00079 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_7A									(0x0007A + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_7B									(0x0007B + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_7C									(0x0007C + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_7D									(0x0007D + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_7E									(0x0007E + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_7F									(0x0007F + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_80									(0x00080 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_81									(0x00081 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_82									(0x00082 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_83									(0x00083 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_84									(0x00084 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_85									(0x00085 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_86									(0x00086 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_87									(0x00087 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_88									(0x00088 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_89									(0x00089 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_8A									(0x0008A + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_8B									(0x0008B + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_8C									(0x0008C + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_8D									(0x0008D + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_8E									(0x0008E + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_8F									(0x0008F + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_90									(0x00090 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_91									(0x00091 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_92									(0x00092 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_93									(0x00093 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_94									(0x00094 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_95									(0x00095 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_96									(0x00096 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_97									(0x00097 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_98									(0x00098 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_99									(0x00099 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_9A									(0x0009A + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_9B									(0x0009B + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_9C									(0x0009C + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_9D									(0x0009D + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_9E									(0x0009E + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_9F									(0x0009F + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_A0									(0x000A0 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_A1									(0x000A1 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_A2									(0x000A2 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_A3									(0x000A3 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_A4									(0x000A4 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_A5									(0x000A5 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_A6									(0x000A6 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_A7									(0x000A7 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_A8									(0x000A8 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_A9									(0x000A9 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_AA									(0x000AA + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_AB									(0x000AB + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_AC									(0x000AC + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_AD									(0x000AD + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_AE									(0x000AE + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_AF									(0x000AF + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_B0									(0x000B0 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_B1									(0x000B1 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_B2									(0x000B2 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_B3									(0x000B3 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_B4									(0x000B4 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_B5									(0x000B5 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_B6									(0x000B6 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_B7									(0x000B7 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_B8									(0x000B8 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_B9									(0x000B9 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_BA									(0x000BA + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_BB									(0x000BB + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_BC									(0x000BC + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_BD									(0x000BD + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_BE									(0x000BE + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_BF									(0x000BF + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_C0									(0x000C0 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_C1									(0x000C1 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_C2									(0x000C2 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_C3									(0x000C3 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_C4									(0x000C4 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_C5									(0x000C5 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_C6									(0x000C6 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_C7									(0x000C7 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_C8									(0x000C8 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_C9									(0x000C9 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_CA									(0x000CA + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_CB									(0x000CB + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_CC									(0x000CC + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_CD									(0x000CD + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_CE									(0x000CE + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_CF									(0x000CF + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_D0									(0x000D0 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_D1									(0x000D1 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_D2									(0x000D2 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_D3									(0x000D3 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_D4									(0x000D4 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_D5									(0x000D5 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_D6									(0x000D6 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_D7									(0x000D7 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_D8									(0x000D8 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_D9									(0x000D9 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_DA									(0x000DA + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_DB									(0x000DB + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_DC									(0x000DC + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_DD									(0x000DD + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_DE									(0x000DE + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_DF									(0x000DF + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_E0									(0x000E0 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_E1									(0x000E1 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_E2									(0x000E2 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_E3									(0x000E3 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_E4									(0x000E4 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_E5									(0x000E5 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_E6									(0x000E6 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_E7									(0x000E7 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_E8									(0x000E8 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_E9									(0x000E9 + cOCT6100_FATAL_BASE)
#define cOCT6100_ERR_FATAL_EA									(0x000EA + cOCT6100_FATAL_BASE)

#endif /* __OCT6100_ERRORS_H__ */
